package io.kubernetes.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface V1PodListFluent<A extends V1PodListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,V1Pod item);
    public A setToItems(int index,V1Pod item);
    public A addToItems(V1Pod... items);
    public A addAllToItems(Collection<V1Pod> items);
    public A removeFromItems(V1Pod... items);
    public A removeAllFromItems(Collection<V1Pod> items);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<V1Pod> getItems();
    public List<V1Pod> buildItems();
    public V1Pod buildItem(int index);
    public V1Pod buildFirstItem();
    public V1Pod buildLastItem();
    public V1Pod buildMatchingItem(io.kubernetes.client.fluent.Predicate<V1PodBuilder> predicate);
    public Boolean hasMatchingItem(io.kubernetes.client.fluent.Predicate<V1PodBuilder> predicate);
    public A withItems(List<V1Pod> items);
    public A withItems(V1Pod... items);
    public Boolean hasItems();
    public V1PodListFluent.ItemsNested<A> addNewItem();
    public V1PodListFluent.ItemsNested<A> addNewItemLike(V1Pod item);
    public V1PodListFluent.ItemsNested<A> setNewItemLike(int index,V1Pod item);
    public V1PodListFluent.ItemsNested<A> editItem(int index);
    public V1PodListFluent.ItemsNested<A> editFirstItem();
    public V1PodListFluent.ItemsNested<A> editLastItem();
    public V1PodListFluent.ItemsNested<A> editMatchingItem(io.kubernetes.client.fluent.Predicate<V1PodBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ListMeta getMetadata();
    public V1ListMeta buildMetadata();
    public A withMetadata(V1ListMeta metadata);
    public Boolean hasMetadata();
    public V1PodListFluent.MetadataNested<A> withNewMetadata();
    public V1PodListFluent.MetadataNested<A> withNewMetadataLike(V1ListMeta item);
    public V1PodListFluent.MetadataNested<A> editMetadata();
    public V1PodListFluent.MetadataNested<A> editOrNewMetadata();
    public V1PodListFluent.MetadataNested<A> editOrNewMetadataLike(V1ListMeta item);

    public interface ItemsNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1PodFluent<V1PodListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}
    public interface MetadataNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1ListMetaFluent<V1PodListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
