package io.kubernetes.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Boolean;

public interface V1ReplicationControllerFluent<A extends V1ReplicationControllerFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ObjectMeta getMetadata();
    public V1ObjectMeta buildMetadata();
    public A withMetadata(V1ObjectMeta metadata);
    public Boolean hasMetadata();
    public V1ReplicationControllerFluent.MetadataNested<A> withNewMetadata();
    public V1ReplicationControllerFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item);
    public V1ReplicationControllerFluent.MetadataNested<A> editMetadata();
    public V1ReplicationControllerFluent.MetadataNested<A> editOrNewMetadata();
    public V1ReplicationControllerFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public V1ReplicationControllerSpec getSpec();
    public V1ReplicationControllerSpec buildSpec();
    public A withSpec(V1ReplicationControllerSpec spec);
    public Boolean hasSpec();
    public V1ReplicationControllerFluent.SpecNested<A> withNewSpec();
    public V1ReplicationControllerFluent.SpecNested<A> withNewSpecLike(V1ReplicationControllerSpec item);
    public V1ReplicationControllerFluent.SpecNested<A> editSpec();
    public V1ReplicationControllerFluent.SpecNested<A> editOrNewSpec();
    public V1ReplicationControllerFluent.SpecNested<A> editOrNewSpecLike(V1ReplicationControllerSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public V1ReplicationControllerStatus getStatus();
    public V1ReplicationControllerStatus buildStatus();
    public A withStatus(V1ReplicationControllerStatus status);
    public Boolean hasStatus();
    public V1ReplicationControllerFluent.StatusNested<A> withNewStatus();
    public V1ReplicationControllerFluent.StatusNested<A> withNewStatusLike(V1ReplicationControllerStatus item);
    public V1ReplicationControllerFluent.StatusNested<A> editStatus();
    public V1ReplicationControllerFluent.StatusNested<A> editOrNewStatus();
    public V1ReplicationControllerFluent.StatusNested<A> editOrNewStatusLike(V1ReplicationControllerStatus item);

    public interface MetadataNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1ObjectMetaFluent<V1ReplicationControllerFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1ReplicationControllerSpecFluent<V1ReplicationControllerFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}
    public interface StatusNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1ReplicationControllerStatusFluent<V1ReplicationControllerFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
