package io.kubernetes.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import java.util.List;
import java.lang.Boolean;
import io.kubernetes.client.fluent.Fluent;
import java.lang.StringBuffer;
import java.util.Collection;

public interface V1RoleBindingFluent<A extends V1RoleBindingFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ObjectMeta getMetadata();
    public V1ObjectMeta buildMetadata();
    public A withMetadata(V1ObjectMeta metadata);
    public Boolean hasMetadata();
    public V1RoleBindingFluent.MetadataNested<A> withNewMetadata();
    public V1RoleBindingFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item);
    public V1RoleBindingFluent.MetadataNested<A> editMetadata();
    public V1RoleBindingFluent.MetadataNested<A> editOrNewMetadata();
    public V1RoleBindingFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildRoleRef instead.
 * @return The buildable object.
 */
@Deprecated public V1RoleRef getRoleRef();
    public V1RoleRef buildRoleRef();
    public A withRoleRef(V1RoleRef roleRef);
    public Boolean hasRoleRef();
    public V1RoleBindingFluent.RoleRefNested<A> withNewRoleRef();
    public V1RoleBindingFluent.RoleRefNested<A> withNewRoleRefLike(V1RoleRef item);
    public V1RoleBindingFluent.RoleRefNested<A> editRoleRef();
    public V1RoleBindingFluent.RoleRefNested<A> editOrNewRoleRef();
    public V1RoleBindingFluent.RoleRefNested<A> editOrNewRoleRefLike(V1RoleRef item);
    public A addToSubjects(int index,V1Subject item);
    public A setToSubjects(int index,V1Subject item);
    public A addToSubjects(V1Subject... items);
    public A addAllToSubjects(Collection<V1Subject> items);
    public A removeFromSubjects(V1Subject... items);
    public A removeAllFromSubjects(Collection<V1Subject> items);
    
/**
 * This method has been deprecated, please use method buildSubjects instead.
 * @return The buildable object.
 */
@Deprecated public List<V1Subject> getSubjects();
    public List<V1Subject> buildSubjects();
    public V1Subject buildSubject(int index);
    public V1Subject buildFirstSubject();
    public V1Subject buildLastSubject();
    public V1Subject buildMatchingSubject(io.kubernetes.client.fluent.Predicate<V1SubjectBuilder> predicate);
    public Boolean hasMatchingSubject(io.kubernetes.client.fluent.Predicate<V1SubjectBuilder> predicate);
    public A withSubjects(List<V1Subject> subjects);
    public A withSubjects(V1Subject... subjects);
    public Boolean hasSubjects();
    public V1RoleBindingFluent.SubjectsNested<A> addNewSubject();
    public V1RoleBindingFluent.SubjectsNested<A> addNewSubjectLike(V1Subject item);
    public V1RoleBindingFluent.SubjectsNested<A> setNewSubjectLike(int index,V1Subject item);
    public V1RoleBindingFluent.SubjectsNested<A> editSubject(int index);
    public V1RoleBindingFluent.SubjectsNested<A> editFirstSubject();
    public V1RoleBindingFluent.SubjectsNested<A> editLastSubject();
    public V1RoleBindingFluent.SubjectsNested<A> editMatchingSubject(io.kubernetes.client.fluent.Predicate<V1SubjectBuilder> predicate);

    public interface MetadataNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1ObjectMetaFluent<V1RoleBindingFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface RoleRefNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1RoleRefFluent<V1RoleBindingFluent.RoleRefNested<N>>{

        
    public N and();    public N endRoleRef();
}
    public interface SubjectsNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1SubjectFluent<V1RoleBindingFluent.SubjectsNested<N>>{

        
    public N and();    public N endSubject();
}


}
