package io.kubernetes.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface V1RoleFluent<A extends V1RoleFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ObjectMeta getMetadata();
    public V1ObjectMeta buildMetadata();
    public A withMetadata(V1ObjectMeta metadata);
    public Boolean hasMetadata();
    public V1RoleFluent.MetadataNested<A> withNewMetadata();
    public V1RoleFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item);
    public V1RoleFluent.MetadataNested<A> editMetadata();
    public V1RoleFluent.MetadataNested<A> editOrNewMetadata();
    public V1RoleFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item);
    public A addToRules(int index,V1PolicyRule item);
    public A setToRules(int index,V1PolicyRule item);
    public A addToRules(V1PolicyRule... items);
    public A addAllToRules(Collection<V1PolicyRule> items);
    public A removeFromRules(V1PolicyRule... items);
    public A removeAllFromRules(Collection<V1PolicyRule> items);
    
/**
 * This method has been deprecated, please use method buildRules instead.
 * @return The buildable object.
 */
@Deprecated public List<V1PolicyRule> getRules();
    public List<V1PolicyRule> buildRules();
    public V1PolicyRule buildRule(int index);
    public V1PolicyRule buildFirstRule();
    public V1PolicyRule buildLastRule();
    public V1PolicyRule buildMatchingRule(io.kubernetes.client.fluent.Predicate<V1PolicyRuleBuilder> predicate);
    public Boolean hasMatchingRule(io.kubernetes.client.fluent.Predicate<V1PolicyRuleBuilder> predicate);
    public A withRules(List<V1PolicyRule> rules);
    public A withRules(V1PolicyRule... rules);
    public Boolean hasRules();
    public V1RoleFluent.RulesNested<A> addNewRule();
    public V1RoleFluent.RulesNested<A> addNewRuleLike(V1PolicyRule item);
    public V1RoleFluent.RulesNested<A> setNewRuleLike(int index,V1PolicyRule item);
    public V1RoleFluent.RulesNested<A> editRule(int index);
    public V1RoleFluent.RulesNested<A> editFirstRule();
    public V1RoleFluent.RulesNested<A> editLastRule();
    public V1RoleFluent.RulesNested<A> editMatchingRule(io.kubernetes.client.fluent.Predicate<V1PolicyRuleBuilder> predicate);

    public interface MetadataNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1ObjectMetaFluent<V1RoleFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface RulesNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1PolicyRuleFluent<V1RoleFluent.RulesNested<N>>{

        
    public N and();    public N endRule();
}


}
