package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1RollingUpdateStatefulSetStrategyBuilder extends V1RollingUpdateStatefulSetStrategyFluentImpl<V1RollingUpdateStatefulSetStrategyBuilder> implements VisitableBuilder<V1RollingUpdateStatefulSetStrategy,V1RollingUpdateStatefulSetStrategyBuilder>{

    V1RollingUpdateStatefulSetStrategyFluent<?> fluent;
    Boolean validationEnabled;

    public V1RollingUpdateStatefulSetStrategyBuilder(){
            this(true);
    }
    public V1RollingUpdateStatefulSetStrategyBuilder(Boolean validationEnabled){
            this(new V1RollingUpdateStatefulSetStrategy(), validationEnabled);
    }
    public V1RollingUpdateStatefulSetStrategyBuilder(V1RollingUpdateStatefulSetStrategyFluent<?> fluent){
            this(fluent, true);
    }
    public V1RollingUpdateStatefulSetStrategyBuilder(V1RollingUpdateStatefulSetStrategyFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1RollingUpdateStatefulSetStrategy(), validationEnabled);
    }
    public V1RollingUpdateStatefulSetStrategyBuilder(V1RollingUpdateStatefulSetStrategyFluent<?> fluent,V1RollingUpdateStatefulSetStrategy instance){
            this(fluent, instance, true);
    }
    public V1RollingUpdateStatefulSetStrategyBuilder(V1RollingUpdateStatefulSetStrategyFluent<?> fluent,V1RollingUpdateStatefulSetStrategy instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withPartition(instance.getPartition());

            this.validationEnabled = validationEnabled; 
    }
    public V1RollingUpdateStatefulSetStrategyBuilder(V1RollingUpdateStatefulSetStrategy instance){
            this(instance,true);
    }
    public V1RollingUpdateStatefulSetStrategyBuilder(V1RollingUpdateStatefulSetStrategy instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withPartition(instance.getPartition());

            this.validationEnabled = validationEnabled; 
    }

    public V1RollingUpdateStatefulSetStrategy build(){
            V1RollingUpdateStatefulSetStrategy buildable = new V1RollingUpdateStatefulSetStrategy();
            buildable.setPartition(fluent.getPartition());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1RollingUpdateStatefulSetStrategyBuilder that = (V1RollingUpdateStatefulSetStrategyBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
