package io.kubernetes.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface V1ServiceListFluent<A extends V1ServiceListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,V1Service item);
    public A setToItems(int index,V1Service item);
    public A addToItems(V1Service... items);
    public A addAllToItems(Collection<V1Service> items);
    public A removeFromItems(V1Service... items);
    public A removeAllFromItems(Collection<V1Service> items);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<V1Service> getItems();
    public List<V1Service> buildItems();
    public V1Service buildItem(int index);
    public V1Service buildFirstItem();
    public V1Service buildLastItem();
    public V1Service buildMatchingItem(io.kubernetes.client.fluent.Predicate<V1ServiceBuilder> predicate);
    public Boolean hasMatchingItem(io.kubernetes.client.fluent.Predicate<V1ServiceBuilder> predicate);
    public A withItems(List<V1Service> items);
    public A withItems(V1Service... items);
    public Boolean hasItems();
    public V1ServiceListFluent.ItemsNested<A> addNewItem();
    public V1ServiceListFluent.ItemsNested<A> addNewItemLike(V1Service item);
    public V1ServiceListFluent.ItemsNested<A> setNewItemLike(int index,V1Service item);
    public V1ServiceListFluent.ItemsNested<A> editItem(int index);
    public V1ServiceListFluent.ItemsNested<A> editFirstItem();
    public V1ServiceListFluent.ItemsNested<A> editLastItem();
    public V1ServiceListFluent.ItemsNested<A> editMatchingItem(io.kubernetes.client.fluent.Predicate<V1ServiceBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ListMeta getMetadata();
    public V1ListMeta buildMetadata();
    public A withMetadata(V1ListMeta metadata);
    public Boolean hasMetadata();
    public V1ServiceListFluent.MetadataNested<A> withNewMetadata();
    public V1ServiceListFluent.MetadataNested<A> withNewMetadataLike(V1ListMeta item);
    public V1ServiceListFluent.MetadataNested<A> editMetadata();
    public V1ServiceListFluent.MetadataNested<A> editOrNewMetadata();
    public V1ServiceListFluent.MetadataNested<A> editOrNewMetadataLike(V1ListMeta item);

    public interface ItemsNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1ServiceFluent<V1ServiceListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}
    public interface MetadataNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1ListMetaFluent<V1ServiceListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
