package io.kubernetes.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Boolean;

public interface V1StatusFluent<A extends V1StatusFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public Integer getCode();
    public A withCode(Integer code);
    public Boolean hasCode();
    
/**
 * This method has been deprecated, please use method buildDetails instead.
 * @return The buildable object.
 */
@Deprecated public V1StatusDetails getDetails();
    public V1StatusDetails buildDetails();
    public A withDetails(V1StatusDetails details);
    public Boolean hasDetails();
    public V1StatusFluent.DetailsNested<A> withNewDetails();
    public V1StatusFluent.DetailsNested<A> withNewDetailsLike(V1StatusDetails item);
    public V1StatusFluent.DetailsNested<A> editDetails();
    public V1StatusFluent.DetailsNested<A> editOrNewDetails();
    public V1StatusFluent.DetailsNested<A> editOrNewDetailsLike(V1StatusDetails item);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public String getMessage();
    public A withMessage(String message);
    public Boolean hasMessage();
    public A withNewMessage(String arg1);
    public A withNewMessage(StringBuilder arg1);
    public A withNewMessage(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ListMeta getMetadata();
    public V1ListMeta buildMetadata();
    public A withMetadata(V1ListMeta metadata);
    public Boolean hasMetadata();
    public V1StatusFluent.MetadataNested<A> withNewMetadata();
    public V1StatusFluent.MetadataNested<A> withNewMetadataLike(V1ListMeta item);
    public V1StatusFluent.MetadataNested<A> editMetadata();
    public V1StatusFluent.MetadataNested<A> editOrNewMetadata();
    public V1StatusFluent.MetadataNested<A> editOrNewMetadataLike(V1ListMeta item);
    public String getReason();
    public A withReason(String reason);
    public Boolean hasReason();
    public A withNewReason(String arg1);
    public A withNewReason(StringBuilder arg1);
    public A withNewReason(StringBuffer arg1);
    public String getStatus();
    public A withStatus(String status);
    public Boolean hasStatus();
    public A withNewStatus(String arg1);
    public A withNewStatus(StringBuilder arg1);
    public A withNewStatus(StringBuffer arg1);

    public interface DetailsNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1StatusDetailsFluent<V1StatusFluent.DetailsNested<N>>{

        
    public N and();    public N endDetails();
}
    public interface MetadataNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1ListMetaFluent<V1StatusFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
