package io.kubernetes.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public class V1SubjectAccessReviewSpecFluentImpl<A extends V1SubjectAccessReviewSpecFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1SubjectAccessReviewSpecFluent<A>{

    private Map<String,List<String>> extra;
    private List<String> groups;
    private V1NonResourceAttributesBuilder nonResourceAttributes;
    private V1ResourceAttributesBuilder resourceAttributes;
    private String uid;
    private String user;

    public V1SubjectAccessReviewSpecFluentImpl(){
    }
    public V1SubjectAccessReviewSpecFluentImpl(V1SubjectAccessReviewSpec instance){
            this.withExtra(instance.getExtra());

            this.withGroups(instance.getGroups());

            this.withNonResourceAttributes(instance.getNonResourceAttributes());

            this.withResourceAttributes(instance.getResourceAttributes());

            this.withUid(instance.getUid());

            this.withUser(instance.getUser());

    }

    public A addToExtra(String key,List<String> value){
            if(this.extra == null && key != null && value != null) { this.extra = new LinkedHashMap<String,List<String>>(); }
            if(key != null && value != null) {this.extra.put(key, value);} return (A)this;
    }

    public A addToExtra(Map<String,List<String>> map){
            if(this.extra == null && map != null) { this.extra = new LinkedHashMap<String,List<String>>(); }
            if(map != null) { this.extra.putAll(map);} return (A)this;
    }

    public A removeFromExtra(String key){
            if(this.extra == null) { return (A) this; }
            if(key != null && this.extra != null) {this.extra.remove(key);} return (A)this;
    }

    public A removeFromExtra(Map<String,List<String>> map){
            if(this.extra == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.extra != null){this.extra.remove(key);}}} return (A)this;
    }

    public Map<String,List<String>> getExtra(){
            return this.extra;
    }

    public A withExtra(Map<String,List<String>> extra){
            if (extra == null) { this.extra =  null;} else {this.extra = new LinkedHashMap<String,List<String>>(extra);} return (A) this;
    }

    public Boolean hasExtra(){
            return this.extra != null;
    }

    public A addToGroups(int index,String item){
            if (this.groups == null) {this.groups = new ArrayList<String>();}
            this.groups.add(index, item);
            return (A)this;
    }

    public A setToGroups(int index,String item){
            if (this.groups == null) {this.groups = new ArrayList<String>();}
            this.groups.set(index, item); return (A)this;
    }

    public A addToGroups(String... items){
            if (this.groups == null) {this.groups = new ArrayList<String>();}
            for (String item : items) {this.groups.add(item);} return (A)this;
    }

    public A addAllToGroups(Collection<String> items){
            if (this.groups == null) {this.groups = new ArrayList<String>();}
            for (String item : items) {this.groups.add(item);} return (A)this;
    }

    public A removeFromGroups(String... items){
            for (String item : items) {if (this.groups!= null){ this.groups.remove(item);}} return (A)this;
    }

    public A removeAllFromGroups(Collection<String> items){
            for (String item : items) {if (this.groups!= null){ this.groups.remove(item);}} return (A)this;
    }

    public List<String> getGroups(){
            return this.groups;
    }

    public String getGroup(int index){
            return this.groups.get(index);
    }

    public String getFirstGroup(){
            return this.groups.get(0);
    }

    public String getLastGroup(){
            return this.groups.get(groups.size() - 1);
    }

    public String getMatchingGroup(io.kubernetes.client.fluent.Predicate<String> predicate){
            for (String item: groups) { if(predicate.apply(item)){return item;} } return null;
    }

    public Boolean hasMatchingGroup(io.kubernetes.client.fluent.Predicate<String> predicate){
            for (String item: groups) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withGroups(List<String> groups){
            if (this.groups != null) { _visitables.get("groups").removeAll(this.groups);}
            if (groups != null) {this.groups = new ArrayList<String>(); for (String item : groups){this.addToGroups(item);}} else { this.groups = null;} return (A) this;
    }

    public A withGroups(String... groups){
            if (this.groups != null) {this.groups.clear();}
            if (groups != null) {for (String item :groups){ this.addToGroups(item);}} return (A) this;
    }

    public Boolean hasGroups(){
            return groups != null && !groups.isEmpty();
    }

    public A addNewGroup(String arg1){
            return (A)addToGroups(new String(arg1));
    }

    public A addNewGroup(StringBuilder arg1){
            return (A)addToGroups(new String(arg1));
    }

    public A addNewGroup(StringBuffer arg1){
            return (A)addToGroups(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildNonResourceAttributes instead.
 * @return The buildable object.
 */
@Deprecated public V1NonResourceAttributes getNonResourceAttributes(){
            return this.nonResourceAttributes!=null?this.nonResourceAttributes.build():null;
    }

    public V1NonResourceAttributes buildNonResourceAttributes(){
            return this.nonResourceAttributes!=null?this.nonResourceAttributes.build():null;
    }

    public A withNonResourceAttributes(V1NonResourceAttributes nonResourceAttributes){
            _visitables.get("nonResourceAttributes").remove(this.nonResourceAttributes);
            if (nonResourceAttributes!=null){ this.nonResourceAttributes= new V1NonResourceAttributesBuilder(nonResourceAttributes); _visitables.get("nonResourceAttributes").add(this.nonResourceAttributes);} return (A) this;
    }

    public Boolean hasNonResourceAttributes(){
            return this.nonResourceAttributes != null;
    }

    public V1SubjectAccessReviewSpecFluent.NonResourceAttributesNested<A> withNewNonResourceAttributes(){
            return new NonResourceAttributesNestedImpl();
    }

    public V1SubjectAccessReviewSpecFluent.NonResourceAttributesNested<A> withNewNonResourceAttributesLike(V1NonResourceAttributes item){
            return new NonResourceAttributesNestedImpl(item);
    }

    public V1SubjectAccessReviewSpecFluent.NonResourceAttributesNested<A> editNonResourceAttributes(){
            return withNewNonResourceAttributesLike(getNonResourceAttributes());
    }

    public V1SubjectAccessReviewSpecFluent.NonResourceAttributesNested<A> editOrNewNonResourceAttributes(){
            return withNewNonResourceAttributesLike(getNonResourceAttributes() != null ? getNonResourceAttributes(): new V1NonResourceAttributesBuilder().build());
    }

    public V1SubjectAccessReviewSpecFluent.NonResourceAttributesNested<A> editOrNewNonResourceAttributesLike(V1NonResourceAttributes item){
            return withNewNonResourceAttributesLike(getNonResourceAttributes() != null ? getNonResourceAttributes(): item);
    }

    
/**
 * This method has been deprecated, please use method buildResourceAttributes instead.
 * @return The buildable object.
 */
@Deprecated public V1ResourceAttributes getResourceAttributes(){
            return this.resourceAttributes!=null?this.resourceAttributes.build():null;
    }

    public V1ResourceAttributes buildResourceAttributes(){
            return this.resourceAttributes!=null?this.resourceAttributes.build():null;
    }

    public A withResourceAttributes(V1ResourceAttributes resourceAttributes){
            _visitables.get("resourceAttributes").remove(this.resourceAttributes);
            if (resourceAttributes!=null){ this.resourceAttributes= new V1ResourceAttributesBuilder(resourceAttributes); _visitables.get("resourceAttributes").add(this.resourceAttributes);} return (A) this;
    }

    public Boolean hasResourceAttributes(){
            return this.resourceAttributes != null;
    }

    public V1SubjectAccessReviewSpecFluent.ResourceAttributesNested<A> withNewResourceAttributes(){
            return new ResourceAttributesNestedImpl();
    }

    public V1SubjectAccessReviewSpecFluent.ResourceAttributesNested<A> withNewResourceAttributesLike(V1ResourceAttributes item){
            return new ResourceAttributesNestedImpl(item);
    }

    public V1SubjectAccessReviewSpecFluent.ResourceAttributesNested<A> editResourceAttributes(){
            return withNewResourceAttributesLike(getResourceAttributes());
    }

    public V1SubjectAccessReviewSpecFluent.ResourceAttributesNested<A> editOrNewResourceAttributes(){
            return withNewResourceAttributesLike(getResourceAttributes() != null ? getResourceAttributes(): new V1ResourceAttributesBuilder().build());
    }

    public V1SubjectAccessReviewSpecFluent.ResourceAttributesNested<A> editOrNewResourceAttributesLike(V1ResourceAttributes item){
            return withNewResourceAttributesLike(getResourceAttributes() != null ? getResourceAttributes(): item);
    }

    public String getUid(){
            return this.uid;
    }

    public A withUid(String uid){
            this.uid=uid; return (A) this;
    }

    public Boolean hasUid(){
            return this.uid != null;
    }

    public A withNewUid(String arg1){
            return (A)withUid(new String(arg1));
    }

    public A withNewUid(StringBuilder arg1){
            return (A)withUid(new String(arg1));
    }

    public A withNewUid(StringBuffer arg1){
            return (A)withUid(new String(arg1));
    }

    public String getUser(){
            return this.user;
    }

    public A withUser(String user){
            this.user=user; return (A) this;
    }

    public Boolean hasUser(){
            return this.user != null;
    }

    public A withNewUser(String arg1){
            return (A)withUser(new String(arg1));
    }

    public A withNewUser(StringBuilder arg1){
            return (A)withUser(new String(arg1));
    }

    public A withNewUser(StringBuffer arg1){
            return (A)withUser(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1SubjectAccessReviewSpecFluentImpl that = (V1SubjectAccessReviewSpecFluentImpl) o;
            if (extra != null ? !extra.equals(that.extra) :that.extra != null) return false;
            if (groups != null ? !groups.equals(that.groups) :that.groups != null) return false;
            if (nonResourceAttributes != null ? !nonResourceAttributes.equals(that.nonResourceAttributes) :that.nonResourceAttributes != null) return false;
            if (resourceAttributes != null ? !resourceAttributes.equals(that.resourceAttributes) :that.resourceAttributes != null) return false;
            if (uid != null ? !uid.equals(that.uid) :that.uid != null) return false;
            if (user != null ? !user.equals(that.user) :that.user != null) return false;
            return true;
    }


    public class NonResourceAttributesNestedImpl<N> extends V1NonResourceAttributesFluentImpl<V1SubjectAccessReviewSpecFluent.NonResourceAttributesNested<N>> implements V1SubjectAccessReviewSpecFluent.NonResourceAttributesNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1NonResourceAttributesBuilder builder;
    
            NonResourceAttributesNestedImpl(V1NonResourceAttributes item){
                    this.builder = new V1NonResourceAttributesBuilder(this, item);
            }
            NonResourceAttributesNestedImpl(){
                    this.builder = new V1NonResourceAttributesBuilder(this);
            }
    
    public N and(){
            return (N) V1SubjectAccessReviewSpecFluentImpl.this.withNonResourceAttributes(builder.build());
    }
    public N endNonResourceAttributes(){
            return and();
    }

}
    public class ResourceAttributesNestedImpl<N> extends V1ResourceAttributesFluentImpl<V1SubjectAccessReviewSpecFluent.ResourceAttributesNested<N>> implements V1SubjectAccessReviewSpecFluent.ResourceAttributesNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1ResourceAttributesBuilder builder;
    
            ResourceAttributesNestedImpl(V1ResourceAttributes item){
                    this.builder = new V1ResourceAttributesBuilder(this, item);
            }
            ResourceAttributesNestedImpl(){
                    this.builder = new V1ResourceAttributesBuilder(this);
            }
    
    public N and(){
            return (N) V1SubjectAccessReviewSpecFluentImpl.this.withResourceAttributes(builder.build());
    }
    public N endResourceAttributes(){
            return and();
    }

}


}
