package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1VolumeAttachmentSourceBuilder extends V1VolumeAttachmentSourceFluentImpl<V1VolumeAttachmentSourceBuilder> implements VisitableBuilder<V1VolumeAttachmentSource,V1VolumeAttachmentSourceBuilder>{

    V1VolumeAttachmentSourceFluent<?> fluent;
    Boolean validationEnabled;

    public V1VolumeAttachmentSourceBuilder(){
            this(true);
    }
    public V1VolumeAttachmentSourceBuilder(Boolean validationEnabled){
            this(new V1VolumeAttachmentSource(), validationEnabled);
    }
    public V1VolumeAttachmentSourceBuilder(V1VolumeAttachmentSourceFluent<?> fluent){
            this(fluent, true);
    }
    public V1VolumeAttachmentSourceBuilder(V1VolumeAttachmentSourceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1VolumeAttachmentSource(), validationEnabled);
    }
    public V1VolumeAttachmentSourceBuilder(V1VolumeAttachmentSourceFluent<?> fluent,V1VolumeAttachmentSource instance){
            this(fluent, instance, true);
    }
    public V1VolumeAttachmentSourceBuilder(V1VolumeAttachmentSourceFluent<?> fluent,V1VolumeAttachmentSource instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withPersistentVolumeName(instance.getPersistentVolumeName());

            this.validationEnabled = validationEnabled; 
    }
    public V1VolumeAttachmentSourceBuilder(V1VolumeAttachmentSource instance){
            this(instance,true);
    }
    public V1VolumeAttachmentSourceBuilder(V1VolumeAttachmentSource instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withPersistentVolumeName(instance.getPersistentVolumeName());

            this.validationEnabled = validationEnabled; 
    }

    public V1VolumeAttachmentSource build(){
            V1VolumeAttachmentSource buildable = new V1VolumeAttachmentSource();
            buildable.setPersistentVolumeName(fluent.getPersistentVolumeName());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1VolumeAttachmentSourceBuilder that = (V1VolumeAttachmentSourceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
