package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1WeightedPodAffinityTermBuilder extends V1WeightedPodAffinityTermFluentImpl<V1WeightedPodAffinityTermBuilder> implements VisitableBuilder<V1WeightedPodAffinityTerm,V1WeightedPodAffinityTermBuilder>{

    V1WeightedPodAffinityTermFluent<?> fluent;
    Boolean validationEnabled;

    public V1WeightedPodAffinityTermBuilder(){
            this(true);
    }
    public V1WeightedPodAffinityTermBuilder(Boolean validationEnabled){
            this(new V1WeightedPodAffinityTerm(), validationEnabled);
    }
    public V1WeightedPodAffinityTermBuilder(V1WeightedPodAffinityTermFluent<?> fluent){
            this(fluent, true);
    }
    public V1WeightedPodAffinityTermBuilder(V1WeightedPodAffinityTermFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1WeightedPodAffinityTerm(), validationEnabled);
    }
    public V1WeightedPodAffinityTermBuilder(V1WeightedPodAffinityTermFluent<?> fluent,V1WeightedPodAffinityTerm instance){
            this(fluent, instance, true);
    }
    public V1WeightedPodAffinityTermBuilder(V1WeightedPodAffinityTermFluent<?> fluent,V1WeightedPodAffinityTerm instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withPodAffinityTerm(instance.getPodAffinityTerm());

            fluent.withWeight(instance.getWeight());

            this.validationEnabled = validationEnabled; 
    }
    public V1WeightedPodAffinityTermBuilder(V1WeightedPodAffinityTerm instance){
            this(instance,true);
    }
    public V1WeightedPodAffinityTermBuilder(V1WeightedPodAffinityTerm instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withPodAffinityTerm(instance.getPodAffinityTerm());

            this.withWeight(instance.getWeight());

            this.validationEnabled = validationEnabled; 
    }

    public V1WeightedPodAffinityTerm build(){
            V1WeightedPodAffinityTerm buildable = new V1WeightedPodAffinityTerm();
            buildable.setPodAffinityTerm(fluent.getPodAffinityTerm());
            buildable.setWeight(fluent.getWeight());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1WeightedPodAffinityTermBuilder that = (V1WeightedPodAffinityTermBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
