package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1AuditSinkBuilder extends V1alpha1AuditSinkFluentImpl<V1alpha1AuditSinkBuilder> implements VisitableBuilder<V1alpha1AuditSink,V1alpha1AuditSinkBuilder>{

    V1alpha1AuditSinkFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1AuditSinkBuilder(){
            this(true);
    }
    public V1alpha1AuditSinkBuilder(Boolean validationEnabled){
            this(new V1alpha1AuditSink(), validationEnabled);
    }
    public V1alpha1AuditSinkBuilder(V1alpha1AuditSinkFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1AuditSinkBuilder(V1alpha1AuditSinkFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1AuditSink(), validationEnabled);
    }
    public V1alpha1AuditSinkBuilder(V1alpha1AuditSinkFluent<?> fluent,V1alpha1AuditSink instance){
            this(fluent, instance, true);
    }
    public V1alpha1AuditSinkBuilder(V1alpha1AuditSinkFluent<?> fluent,V1alpha1AuditSink instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            fluent.withSpec(instance.getSpec());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1AuditSinkBuilder(V1alpha1AuditSink instance){
            this(instance,true);
    }
    public V1alpha1AuditSinkBuilder(V1alpha1AuditSink instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withSpec(instance.getSpec());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1AuditSink build(){
            V1alpha1AuditSink buildable = new V1alpha1AuditSink();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            buildable.setSpec(fluent.getSpec());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1AuditSinkBuilder that = (V1alpha1AuditSinkBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
