package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1AuditSinkListBuilder extends V1alpha1AuditSinkListFluentImpl<V1alpha1AuditSinkListBuilder> implements VisitableBuilder<V1alpha1AuditSinkList,V1alpha1AuditSinkListBuilder>{

    V1alpha1AuditSinkListFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1AuditSinkListBuilder(){
            this(true);
    }
    public V1alpha1AuditSinkListBuilder(Boolean validationEnabled){
            this(new V1alpha1AuditSinkList(), validationEnabled);
    }
    public V1alpha1AuditSinkListBuilder(V1alpha1AuditSinkListFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1AuditSinkListBuilder(V1alpha1AuditSinkListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1AuditSinkList(), validationEnabled);
    }
    public V1alpha1AuditSinkListBuilder(V1alpha1AuditSinkListFluent<?> fluent,V1alpha1AuditSinkList instance){
            this(fluent, instance, true);
    }
    public V1alpha1AuditSinkListBuilder(V1alpha1AuditSinkListFluent<?> fluent,V1alpha1AuditSinkList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withItems(instance.getItems());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1AuditSinkListBuilder(V1alpha1AuditSinkList instance){
            this(instance,true);
    }
    public V1alpha1AuditSinkListBuilder(V1alpha1AuditSinkList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withItems(instance.getItems());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1AuditSinkList build(){
            V1alpha1AuditSinkList buildable = new V1alpha1AuditSinkList();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setItems(fluent.getItems());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1AuditSinkListBuilder that = (V1alpha1AuditSinkListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
