package io.kubernetes.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class V1alpha1ClusterRoleBindingFluentImpl<A extends V1alpha1ClusterRoleBindingFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1alpha1ClusterRoleBindingFluent<A>{

    private String apiVersion;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private V1alpha1RoleRefBuilder roleRef;
    private List<V1alpha1SubjectBuilder> subjects;

    public V1alpha1ClusterRoleBindingFluentImpl(){
    }
    public V1alpha1ClusterRoleBindingFluentImpl(V1alpha1ClusterRoleBinding instance){
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withRoleRef(instance.getRoleRef());

            this.withSubjects(instance.getSubjects());

    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public A withNewKind(String arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1){
            return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1){
            return (A)withKind(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public V1ObjectMeta buildMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(V1ObjectMeta metadata){
            _visitables.get("metadata").remove(this.metadata);
            if (metadata!=null){ this.metadata= new V1ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public V1alpha1ClusterRoleBindingFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public V1alpha1ClusterRoleBindingFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public V1alpha1ClusterRoleBindingFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public V1alpha1ClusterRoleBindingFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new V1ObjectMetaBuilder().build());
    }

    public V1alpha1ClusterRoleBindingFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    
/**
 * This method has been deprecated, please use method buildRoleRef instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1RoleRef getRoleRef(){
            return this.roleRef!=null?this.roleRef.build():null;
    }

    public V1alpha1RoleRef buildRoleRef(){
            return this.roleRef!=null?this.roleRef.build():null;
    }

    public A withRoleRef(V1alpha1RoleRef roleRef){
            _visitables.get("roleRef").remove(this.roleRef);
            if (roleRef!=null){ this.roleRef= new V1alpha1RoleRefBuilder(roleRef); _visitables.get("roleRef").add(this.roleRef);} return (A) this;
    }

    public Boolean hasRoleRef(){
            return this.roleRef != null;
    }

    public V1alpha1ClusterRoleBindingFluent.RoleRefNested<A> withNewRoleRef(){
            return new RoleRefNestedImpl();
    }

    public V1alpha1ClusterRoleBindingFluent.RoleRefNested<A> withNewRoleRefLike(V1alpha1RoleRef item){
            return new RoleRefNestedImpl(item);
    }

    public V1alpha1ClusterRoleBindingFluent.RoleRefNested<A> editRoleRef(){
            return withNewRoleRefLike(getRoleRef());
    }

    public V1alpha1ClusterRoleBindingFluent.RoleRefNested<A> editOrNewRoleRef(){
            return withNewRoleRefLike(getRoleRef() != null ? getRoleRef(): new V1alpha1RoleRefBuilder().build());
    }

    public V1alpha1ClusterRoleBindingFluent.RoleRefNested<A> editOrNewRoleRefLike(V1alpha1RoleRef item){
            return withNewRoleRefLike(getRoleRef() != null ? getRoleRef(): item);
    }

    public A addToSubjects(int index,V1alpha1Subject item){
            if (this.subjects == null) {this.subjects = new ArrayList<V1alpha1SubjectBuilder>();}
            V1alpha1SubjectBuilder builder = new V1alpha1SubjectBuilder(item);_visitables.get("subjects").add(index >= 0 ? index : _visitables.get("subjects").size(), builder);this.subjects.add(index >= 0 ? index : subjects.size(), builder); return (A)this;
    }

    public A setToSubjects(int index,V1alpha1Subject item){
            if (this.subjects == null) {this.subjects = new ArrayList<V1alpha1SubjectBuilder>();}
            V1alpha1SubjectBuilder builder = new V1alpha1SubjectBuilder(item);
            if (index < 0 || index >= _visitables.get("subjects").size()) { _visitables.get("subjects").add(builder); } else { _visitables.get("subjects").set(index, builder);}
            if (index < 0 || index >= subjects.size()) { subjects.add(builder); } else { subjects.set(index, builder);}
             return (A)this;
    }

    public A addToSubjects(V1alpha1Subject... items){
            if (this.subjects == null) {this.subjects = new ArrayList<V1alpha1SubjectBuilder>();}
            for (V1alpha1Subject item : items) {V1alpha1SubjectBuilder builder = new V1alpha1SubjectBuilder(item);_visitables.get("subjects").add(builder);this.subjects.add(builder);} return (A)this;
    }

    public A addAllToSubjects(Collection<V1alpha1Subject> items){
            if (this.subjects == null) {this.subjects = new ArrayList<V1alpha1SubjectBuilder>();}
            for (V1alpha1Subject item : items) {V1alpha1SubjectBuilder builder = new V1alpha1SubjectBuilder(item);_visitables.get("subjects").add(builder);this.subjects.add(builder);} return (A)this;
    }

    public A removeFromSubjects(V1alpha1Subject... items){
            for (V1alpha1Subject item : items) {V1alpha1SubjectBuilder builder = new V1alpha1SubjectBuilder(item);_visitables.get("subjects").remove(builder);if (this.subjects != null) {this.subjects.remove(builder);}} return (A)this;
    }

    public A removeAllFromSubjects(Collection<V1alpha1Subject> items){
            for (V1alpha1Subject item : items) {V1alpha1SubjectBuilder builder = new V1alpha1SubjectBuilder(item);_visitables.get("subjects").remove(builder);if (this.subjects != null) {this.subjects.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildSubjects instead.
 * @return The buildable object.
 */
@Deprecated public List<V1alpha1Subject> getSubjects(){
            return build(subjects);
    }

    public List<V1alpha1Subject> buildSubjects(){
            return build(subjects);
    }

    public V1alpha1Subject buildSubject(int index){
            return this.subjects.get(index).build();
    }

    public V1alpha1Subject buildFirstSubject(){
            return this.subjects.get(0).build();
    }

    public V1alpha1Subject buildLastSubject(){
            return this.subjects.get(subjects.size() - 1).build();
    }

    public V1alpha1Subject buildMatchingSubject(io.kubernetes.client.fluent.Predicate<V1alpha1SubjectBuilder> predicate){
            for (V1alpha1SubjectBuilder item: subjects) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingSubject(io.kubernetes.client.fluent.Predicate<V1alpha1SubjectBuilder> predicate){
            for (V1alpha1SubjectBuilder item: subjects) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withSubjects(List<V1alpha1Subject> subjects){
            if (this.subjects != null) { _visitables.get("subjects").removeAll(this.subjects);}
            if (subjects != null) {this.subjects = new ArrayList<V1alpha1SubjectBuilder>(); for (V1alpha1Subject item : subjects){this.addToSubjects(item);}} else { this.subjects = null;} return (A) this;
    }

    public A withSubjects(V1alpha1Subject... subjects){
            if (this.subjects != null) {this.subjects.clear();}
            if (subjects != null) {for (V1alpha1Subject item :subjects){ this.addToSubjects(item);}} return (A) this;
    }

    public Boolean hasSubjects(){
            return subjects != null && !subjects.isEmpty();
    }

    public V1alpha1ClusterRoleBindingFluent.SubjectsNested<A> addNewSubject(){
            return new SubjectsNestedImpl();
    }

    public V1alpha1ClusterRoleBindingFluent.SubjectsNested<A> addNewSubjectLike(V1alpha1Subject item){
            return new SubjectsNestedImpl(-1, item);
    }

    public V1alpha1ClusterRoleBindingFluent.SubjectsNested<A> setNewSubjectLike(int index,V1alpha1Subject item){
            return new SubjectsNestedImpl(index, item);
    }

    public V1alpha1ClusterRoleBindingFluent.SubjectsNested<A> editSubject(int index){
            if (subjects.size() <= index) throw new RuntimeException("Can't edit subjects. Index exceeds size.");
            return setNewSubjectLike(index, buildSubject(index));
    }

    public V1alpha1ClusterRoleBindingFluent.SubjectsNested<A> editFirstSubject(){
            if (subjects.size() == 0) throw new RuntimeException("Can't edit first subjects. The list is empty.");
            return setNewSubjectLike(0, buildSubject(0));
    }

    public V1alpha1ClusterRoleBindingFluent.SubjectsNested<A> editLastSubject(){
            int index = subjects.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last subjects. The list is empty.");
            return setNewSubjectLike(index, buildSubject(index));
    }

    public V1alpha1ClusterRoleBindingFluent.SubjectsNested<A> editMatchingSubject(io.kubernetes.client.fluent.Predicate<V1alpha1SubjectBuilder> predicate){
            int index = -1;
            for (int i=0;i<subjects.size();i++) { 
            if (predicate.apply(subjects.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching subjects. No match found.");
            return setNewSubjectLike(index, buildSubject(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ClusterRoleBindingFluentImpl that = (V1alpha1ClusterRoleBindingFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (roleRef != null ? !roleRef.equals(that.roleRef) :that.roleRef != null) return false;
            if (subjects != null ? !subjects.equals(that.subjects) :that.subjects != null) return false;
            return true;
    }


    public class MetadataNestedImpl<N> extends V1ObjectMetaFluentImpl<V1alpha1ClusterRoleBindingFluent.MetadataNested<N>> implements V1alpha1ClusterRoleBindingFluent.MetadataNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1ObjectMetaBuilder builder;
    
            MetadataNestedImpl(V1ObjectMeta item){
                    this.builder = new V1ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new V1ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1ClusterRoleBindingFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}
    public class RoleRefNestedImpl<N> extends V1alpha1RoleRefFluentImpl<V1alpha1ClusterRoleBindingFluent.RoleRefNested<N>> implements V1alpha1ClusterRoleBindingFluent.RoleRefNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1alpha1RoleRefBuilder builder;
    
            RoleRefNestedImpl(V1alpha1RoleRef item){
                    this.builder = new V1alpha1RoleRefBuilder(this, item);
            }
            RoleRefNestedImpl(){
                    this.builder = new V1alpha1RoleRefBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1ClusterRoleBindingFluentImpl.this.withRoleRef(builder.build());
    }
    public N endRoleRef(){
            return and();
    }

}
    public class SubjectsNestedImpl<N> extends V1alpha1SubjectFluentImpl<V1alpha1ClusterRoleBindingFluent.SubjectsNested<N>> implements V1alpha1ClusterRoleBindingFluent.SubjectsNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1alpha1SubjectBuilder builder;
        private final int index;
    
            SubjectsNestedImpl(int index,V1alpha1Subject item){
                    this.index = index;
                    this.builder = new V1alpha1SubjectBuilder(this, item);
            }
            SubjectsNestedImpl(){
                    this.index = -1;
                    this.builder = new V1alpha1SubjectBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1ClusterRoleBindingFluentImpl.this.setToSubjects(index, builder.build());
    }
    public N endSubject(){
            return and();
    }

}


}
