package io.kubernetes.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1alpha1InitializerFluentImpl<A extends V1alpha1InitializerFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1alpha1InitializerFluent<A>{

    private String name;
    private List<V1alpha1RuleBuilder> rules;

    public V1alpha1InitializerFluentImpl(){
    }
    public V1alpha1InitializerFluentImpl(V1alpha1Initializer instance){
            this.withName(instance.getName());

            this.withRules(instance.getRules());

    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public A withNewName(String arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1){
            return (A)withName(new String(arg1));
    }

    public A addToRules(int index,V1alpha1Rule item){
            if (this.rules == null) {this.rules = new ArrayList<V1alpha1RuleBuilder>();}
            V1alpha1RuleBuilder builder = new V1alpha1RuleBuilder(item);_visitables.get("rules").add(index >= 0 ? index : _visitables.get("rules").size(), builder);this.rules.add(index >= 0 ? index : rules.size(), builder); return (A)this;
    }

    public A setToRules(int index,V1alpha1Rule item){
            if (this.rules == null) {this.rules = new ArrayList<V1alpha1RuleBuilder>();}
            V1alpha1RuleBuilder builder = new V1alpha1RuleBuilder(item);
            if (index < 0 || index >= _visitables.get("rules").size()) { _visitables.get("rules").add(builder); } else { _visitables.get("rules").set(index, builder);}
            if (index < 0 || index >= rules.size()) { rules.add(builder); } else { rules.set(index, builder);}
             return (A)this;
    }

    public A addToRules(V1alpha1Rule... items){
            if (this.rules == null) {this.rules = new ArrayList<V1alpha1RuleBuilder>();}
            for (V1alpha1Rule item : items) {V1alpha1RuleBuilder builder = new V1alpha1RuleBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
    }

    public A addAllToRules(Collection<V1alpha1Rule> items){
            if (this.rules == null) {this.rules = new ArrayList<V1alpha1RuleBuilder>();}
            for (V1alpha1Rule item : items) {V1alpha1RuleBuilder builder = new V1alpha1RuleBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
    }

    public A removeFromRules(V1alpha1Rule... items){
            for (V1alpha1Rule item : items) {V1alpha1RuleBuilder builder = new V1alpha1RuleBuilder(item);_visitables.get("rules").remove(builder);if (this.rules != null) {this.rules.remove(builder);}} return (A)this;
    }

    public A removeAllFromRules(Collection<V1alpha1Rule> items){
            for (V1alpha1Rule item : items) {V1alpha1RuleBuilder builder = new V1alpha1RuleBuilder(item);_visitables.get("rules").remove(builder);if (this.rules != null) {this.rules.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildRules instead.
 * @return The buildable object.
 */
@Deprecated public List<V1alpha1Rule> getRules(){
            return build(rules);
    }

    public List<V1alpha1Rule> buildRules(){
            return build(rules);
    }

    public V1alpha1Rule buildRule(int index){
            return this.rules.get(index).build();
    }

    public V1alpha1Rule buildFirstRule(){
            return this.rules.get(0).build();
    }

    public V1alpha1Rule buildLastRule(){
            return this.rules.get(rules.size() - 1).build();
    }

    public V1alpha1Rule buildMatchingRule(io.kubernetes.client.fluent.Predicate<V1alpha1RuleBuilder> predicate){
            for (V1alpha1RuleBuilder item: rules) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingRule(io.kubernetes.client.fluent.Predicate<V1alpha1RuleBuilder> predicate){
            for (V1alpha1RuleBuilder item: rules) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withRules(List<V1alpha1Rule> rules){
            if (this.rules != null) { _visitables.get("rules").removeAll(this.rules);}
            if (rules != null) {this.rules = new ArrayList<V1alpha1RuleBuilder>(); for (V1alpha1Rule item : rules){this.addToRules(item);}} else { this.rules = null;} return (A) this;
    }

    public A withRules(V1alpha1Rule... rules){
            if (this.rules != null) {this.rules.clear();}
            if (rules != null) {for (V1alpha1Rule item :rules){ this.addToRules(item);}} return (A) this;
    }

    public Boolean hasRules(){
            return rules != null && !rules.isEmpty();
    }

    public V1alpha1InitializerFluent.RulesNested<A> addNewRule(){
            return new RulesNestedImpl();
    }

    public V1alpha1InitializerFluent.RulesNested<A> addNewRuleLike(V1alpha1Rule item){
            return new RulesNestedImpl(-1, item);
    }

    public V1alpha1InitializerFluent.RulesNested<A> setNewRuleLike(int index,V1alpha1Rule item){
            return new RulesNestedImpl(index, item);
    }

    public V1alpha1InitializerFluent.RulesNested<A> editRule(int index){
            if (rules.size() <= index) throw new RuntimeException("Can't edit rules. Index exceeds size.");
            return setNewRuleLike(index, buildRule(index));
    }

    public V1alpha1InitializerFluent.RulesNested<A> editFirstRule(){
            if (rules.size() == 0) throw new RuntimeException("Can't edit first rules. The list is empty.");
            return setNewRuleLike(0, buildRule(0));
    }

    public V1alpha1InitializerFluent.RulesNested<A> editLastRule(){
            int index = rules.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last rules. The list is empty.");
            return setNewRuleLike(index, buildRule(index));
    }

    public V1alpha1InitializerFluent.RulesNested<A> editMatchingRule(io.kubernetes.client.fluent.Predicate<V1alpha1RuleBuilder> predicate){
            int index = -1;
            for (int i=0;i<rules.size();i++) { 
            if (predicate.apply(rules.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching rules. No match found.");
            return setNewRuleLike(index, buildRule(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1InitializerFluentImpl that = (V1alpha1InitializerFluentImpl) o;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (rules != null ? !rules.equals(that.rules) :that.rules != null) return false;
            return true;
    }


    public class RulesNestedImpl<N> extends V1alpha1RuleFluentImpl<V1alpha1InitializerFluent.RulesNested<N>> implements V1alpha1InitializerFluent.RulesNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1alpha1RuleBuilder builder;
        private final int index;
    
            RulesNestedImpl(int index,V1alpha1Rule item){
                    this.index = index;
                    this.builder = new V1alpha1RuleBuilder(this, item);
            }
            RulesNestedImpl(){
                    this.index = -1;
                    this.builder = new V1alpha1RuleBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1InitializerFluentImpl.this.setToRules(index, builder.build());
    }
    public N endRule(){
            return and();
    }

}


}
