package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PriorityClassListBuilder extends V1alpha1PriorityClassListFluentImpl<V1alpha1PriorityClassListBuilder> implements VisitableBuilder<V1alpha1PriorityClassList,V1alpha1PriorityClassListBuilder>{

    V1alpha1PriorityClassListFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PriorityClassListBuilder(){
            this(true);
    }
    public V1alpha1PriorityClassListBuilder(Boolean validationEnabled){
            this(new V1alpha1PriorityClassList(), validationEnabled);
    }
    public V1alpha1PriorityClassListBuilder(V1alpha1PriorityClassListFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PriorityClassListBuilder(V1alpha1PriorityClassListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PriorityClassList(), validationEnabled);
    }
    public V1alpha1PriorityClassListBuilder(V1alpha1PriorityClassListFluent<?> fluent,V1alpha1PriorityClassList instance){
            this(fluent, instance, true);
    }
    public V1alpha1PriorityClassListBuilder(V1alpha1PriorityClassListFluent<?> fluent,V1alpha1PriorityClassList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withItems(instance.getItems());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PriorityClassListBuilder(V1alpha1PriorityClassList instance){
            this(instance,true);
    }
    public V1alpha1PriorityClassListBuilder(V1alpha1PriorityClassList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withItems(instance.getItems());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PriorityClassList build(){
            V1alpha1PriorityClassList buildable = new V1alpha1PriorityClassList();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setItems(fluent.getItems());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PriorityClassListBuilder that = (V1alpha1PriorityClassListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
