package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1StatefulSetSpecBuilder extends V1beta1StatefulSetSpecFluentImpl<V1beta1StatefulSetSpecBuilder> implements VisitableBuilder<V1beta1StatefulSetSpec,V1beta1StatefulSetSpecBuilder>{

    V1beta1StatefulSetSpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta1StatefulSetSpecBuilder(){
            this(true);
    }
    public V1beta1StatefulSetSpecBuilder(Boolean validationEnabled){
            this(new V1beta1StatefulSetSpec(), validationEnabled);
    }
    public V1beta1StatefulSetSpecBuilder(V1beta1StatefulSetSpecFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta1StatefulSetSpecBuilder(V1beta1StatefulSetSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta1StatefulSetSpec(), validationEnabled);
    }
    public V1beta1StatefulSetSpecBuilder(V1beta1StatefulSetSpecFluent<?> fluent,V1beta1StatefulSetSpec instance){
            this(fluent, instance, true);
    }
    public V1beta1StatefulSetSpecBuilder(V1beta1StatefulSetSpecFluent<?> fluent,V1beta1StatefulSetSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withPodManagementPolicy(instance.getPodManagementPolicy());

            fluent.withReplicas(instance.getReplicas());

            fluent.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());

            fluent.withSelector(instance.getSelector());

            fluent.withServiceName(instance.getServiceName());

            fluent.withTemplate(instance.getTemplate());

            fluent.withUpdateStrategy(instance.getUpdateStrategy());

            fluent.withVolumeClaimTemplates(instance.getVolumeClaimTemplates());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta1StatefulSetSpecBuilder(V1beta1StatefulSetSpec instance){
            this(instance,true);
    }
    public V1beta1StatefulSetSpecBuilder(V1beta1StatefulSetSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withPodManagementPolicy(instance.getPodManagementPolicy());

            this.withReplicas(instance.getReplicas());

            this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());

            this.withSelector(instance.getSelector());

            this.withServiceName(instance.getServiceName());

            this.withTemplate(instance.getTemplate());

            this.withUpdateStrategy(instance.getUpdateStrategy());

            this.withVolumeClaimTemplates(instance.getVolumeClaimTemplates());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta1StatefulSetSpec build(){
            V1beta1StatefulSetSpec buildable = new V1beta1StatefulSetSpec();
            buildable.setPodManagementPolicy(fluent.getPodManagementPolicy());
            buildable.setReplicas(fluent.getReplicas());
            buildable.setRevisionHistoryLimit(fluent.getRevisionHistoryLimit());
            buildable.setSelector(fluent.getSelector());
            buildable.setServiceName(fluent.getServiceName());
            buildable.setTemplate(fluent.getTemplate());
            buildable.setUpdateStrategy(fluent.getUpdateStrategy());
            buildable.setVolumeClaimTemplates(fluent.getVolumeClaimTemplates());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta1StatefulSetSpecBuilder that = (V1beta1StatefulSetSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
