package io.kubernetes.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class V1beta1StatefulSetSpecFluentImpl<A extends V1beta1StatefulSetSpecFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1beta1StatefulSetSpecFluent<A>{

    private String podManagementPolicy;
    private Integer replicas;
    private Integer revisionHistoryLimit;
    private V1LabelSelectorBuilder selector;
    private String serviceName;
    private V1PodTemplateSpecBuilder template;
    private V1beta1StatefulSetUpdateStrategyBuilder updateStrategy;
    private List<V1PersistentVolumeClaimBuilder> volumeClaimTemplates;

    public V1beta1StatefulSetSpecFluentImpl(){
    }
    public V1beta1StatefulSetSpecFluentImpl(V1beta1StatefulSetSpec instance){
            this.withPodManagementPolicy(instance.getPodManagementPolicy());

            this.withReplicas(instance.getReplicas());

            this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());

            this.withSelector(instance.getSelector());

            this.withServiceName(instance.getServiceName());

            this.withTemplate(instance.getTemplate());

            this.withUpdateStrategy(instance.getUpdateStrategy());

            this.withVolumeClaimTemplates(instance.getVolumeClaimTemplates());

    }

    public String getPodManagementPolicy(){
            return this.podManagementPolicy;
    }

    public A withPodManagementPolicy(String podManagementPolicy){
            this.podManagementPolicy=podManagementPolicy; return (A) this;
    }

    public Boolean hasPodManagementPolicy(){
            return this.podManagementPolicy != null;
    }

    public A withNewPodManagementPolicy(String arg1){
            return (A)withPodManagementPolicy(new String(arg1));
    }

    public A withNewPodManagementPolicy(StringBuilder arg1){
            return (A)withPodManagementPolicy(new String(arg1));
    }

    public A withNewPodManagementPolicy(StringBuffer arg1){
            return (A)withPodManagementPolicy(new String(arg1));
    }

    public Integer getReplicas(){
            return this.replicas;
    }

    public A withReplicas(Integer replicas){
            this.replicas=replicas; return (A) this;
    }

    public Boolean hasReplicas(){
            return this.replicas != null;
    }

    public Integer getRevisionHistoryLimit(){
            return this.revisionHistoryLimit;
    }

    public A withRevisionHistoryLimit(Integer revisionHistoryLimit){
            this.revisionHistoryLimit=revisionHistoryLimit; return (A) this;
    }

    public Boolean hasRevisionHistoryLimit(){
            return this.revisionHistoryLimit != null;
    }

    
/**
 * This method has been deprecated, please use method buildSelector instead.
 * @return The buildable object.
 */
@Deprecated public V1LabelSelector getSelector(){
            return this.selector!=null?this.selector.build():null;
    }

    public V1LabelSelector buildSelector(){
            return this.selector!=null?this.selector.build():null;
    }

    public A withSelector(V1LabelSelector selector){
            _visitables.get("selector").remove(this.selector);
            if (selector!=null){ this.selector= new V1LabelSelectorBuilder(selector); _visitables.get("selector").add(this.selector);} return (A) this;
    }

    public Boolean hasSelector(){
            return this.selector != null;
    }

    public V1beta1StatefulSetSpecFluent.SelectorNested<A> withNewSelector(){
            return new SelectorNestedImpl();
    }

    public V1beta1StatefulSetSpecFluent.SelectorNested<A> withNewSelectorLike(V1LabelSelector item){
            return new SelectorNestedImpl(item);
    }

    public V1beta1StatefulSetSpecFluent.SelectorNested<A> editSelector(){
            return withNewSelectorLike(getSelector());
    }

    public V1beta1StatefulSetSpecFluent.SelectorNested<A> editOrNewSelector(){
            return withNewSelectorLike(getSelector() != null ? getSelector(): new V1LabelSelectorBuilder().build());
    }

    public V1beta1StatefulSetSpecFluent.SelectorNested<A> editOrNewSelectorLike(V1LabelSelector item){
            return withNewSelectorLike(getSelector() != null ? getSelector(): item);
    }

    public String getServiceName(){
            return this.serviceName;
    }

    public A withServiceName(String serviceName){
            this.serviceName=serviceName; return (A) this;
    }

    public Boolean hasServiceName(){
            return this.serviceName != null;
    }

    public A withNewServiceName(String arg1){
            return (A)withServiceName(new String(arg1));
    }

    public A withNewServiceName(StringBuilder arg1){
            return (A)withServiceName(new String(arg1));
    }

    public A withNewServiceName(StringBuffer arg1){
            return (A)withServiceName(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildTemplate instead.
 * @return The buildable object.
 */
@Deprecated public V1PodTemplateSpec getTemplate(){
            return this.template!=null?this.template.build():null;
    }

    public V1PodTemplateSpec buildTemplate(){
            return this.template!=null?this.template.build():null;
    }

    public A withTemplate(V1PodTemplateSpec template){
            _visitables.get("template").remove(this.template);
            if (template!=null){ this.template= new V1PodTemplateSpecBuilder(template); _visitables.get("template").add(this.template);} return (A) this;
    }

    public Boolean hasTemplate(){
            return this.template != null;
    }

    public V1beta1StatefulSetSpecFluent.TemplateNested<A> withNewTemplate(){
            return new TemplateNestedImpl();
    }

    public V1beta1StatefulSetSpecFluent.TemplateNested<A> withNewTemplateLike(V1PodTemplateSpec item){
            return new TemplateNestedImpl(item);
    }

    public V1beta1StatefulSetSpecFluent.TemplateNested<A> editTemplate(){
            return withNewTemplateLike(getTemplate());
    }

    public V1beta1StatefulSetSpecFluent.TemplateNested<A> editOrNewTemplate(){
            return withNewTemplateLike(getTemplate() != null ? getTemplate(): new V1PodTemplateSpecBuilder().build());
    }

    public V1beta1StatefulSetSpecFluent.TemplateNested<A> editOrNewTemplateLike(V1PodTemplateSpec item){
            return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
    }

    
/**
 * This method has been deprecated, please use method buildUpdateStrategy instead.
 * @return The buildable object.
 */
@Deprecated public V1beta1StatefulSetUpdateStrategy getUpdateStrategy(){
            return this.updateStrategy!=null?this.updateStrategy.build():null;
    }

    public V1beta1StatefulSetUpdateStrategy buildUpdateStrategy(){
            return this.updateStrategy!=null?this.updateStrategy.build():null;
    }

    public A withUpdateStrategy(V1beta1StatefulSetUpdateStrategy updateStrategy){
            _visitables.get("updateStrategy").remove(this.updateStrategy);
            if (updateStrategy!=null){ this.updateStrategy= new V1beta1StatefulSetUpdateStrategyBuilder(updateStrategy); _visitables.get("updateStrategy").add(this.updateStrategy);} return (A) this;
    }

    public Boolean hasUpdateStrategy(){
            return this.updateStrategy != null;
    }

    public V1beta1StatefulSetSpecFluent.UpdateStrategyNested<A> withNewUpdateStrategy(){
            return new UpdateStrategyNestedImpl();
    }

    public V1beta1StatefulSetSpecFluent.UpdateStrategyNested<A> withNewUpdateStrategyLike(V1beta1StatefulSetUpdateStrategy item){
            return new UpdateStrategyNestedImpl(item);
    }

    public V1beta1StatefulSetSpecFluent.UpdateStrategyNested<A> editUpdateStrategy(){
            return withNewUpdateStrategyLike(getUpdateStrategy());
    }

    public V1beta1StatefulSetSpecFluent.UpdateStrategyNested<A> editOrNewUpdateStrategy(){
            return withNewUpdateStrategyLike(getUpdateStrategy() != null ? getUpdateStrategy(): new V1beta1StatefulSetUpdateStrategyBuilder().build());
    }

    public V1beta1StatefulSetSpecFluent.UpdateStrategyNested<A> editOrNewUpdateStrategyLike(V1beta1StatefulSetUpdateStrategy item){
            return withNewUpdateStrategyLike(getUpdateStrategy() != null ? getUpdateStrategy(): item);
    }

    public A addToVolumeClaimTemplates(int index,V1PersistentVolumeClaim item){
            if (this.volumeClaimTemplates == null) {this.volumeClaimTemplates = new ArrayList<V1PersistentVolumeClaimBuilder>();}
            V1PersistentVolumeClaimBuilder builder = new V1PersistentVolumeClaimBuilder(item);_visitables.get("volumeClaimTemplates").add(index >= 0 ? index : _visitables.get("volumeClaimTemplates").size(), builder);this.volumeClaimTemplates.add(index >= 0 ? index : volumeClaimTemplates.size(), builder); return (A)this;
    }

    public A setToVolumeClaimTemplates(int index,V1PersistentVolumeClaim item){
            if (this.volumeClaimTemplates == null) {this.volumeClaimTemplates = new ArrayList<V1PersistentVolumeClaimBuilder>();}
            V1PersistentVolumeClaimBuilder builder = new V1PersistentVolumeClaimBuilder(item);
            if (index < 0 || index >= _visitables.get("volumeClaimTemplates").size()) { _visitables.get("volumeClaimTemplates").add(builder); } else { _visitables.get("volumeClaimTemplates").set(index, builder);}
            if (index < 0 || index >= volumeClaimTemplates.size()) { volumeClaimTemplates.add(builder); } else { volumeClaimTemplates.set(index, builder);}
             return (A)this;
    }

    public A addToVolumeClaimTemplates(V1PersistentVolumeClaim... items){
            if (this.volumeClaimTemplates == null) {this.volumeClaimTemplates = new ArrayList<V1PersistentVolumeClaimBuilder>();}
            for (V1PersistentVolumeClaim item : items) {V1PersistentVolumeClaimBuilder builder = new V1PersistentVolumeClaimBuilder(item);_visitables.get("volumeClaimTemplates").add(builder);this.volumeClaimTemplates.add(builder);} return (A)this;
    }

    public A addAllToVolumeClaimTemplates(Collection<V1PersistentVolumeClaim> items){
            if (this.volumeClaimTemplates == null) {this.volumeClaimTemplates = new ArrayList<V1PersistentVolumeClaimBuilder>();}
            for (V1PersistentVolumeClaim item : items) {V1PersistentVolumeClaimBuilder builder = new V1PersistentVolumeClaimBuilder(item);_visitables.get("volumeClaimTemplates").add(builder);this.volumeClaimTemplates.add(builder);} return (A)this;
    }

    public A removeFromVolumeClaimTemplates(V1PersistentVolumeClaim... items){
            for (V1PersistentVolumeClaim item : items) {V1PersistentVolumeClaimBuilder builder = new V1PersistentVolumeClaimBuilder(item);_visitables.get("volumeClaimTemplates").remove(builder);if (this.volumeClaimTemplates != null) {this.volumeClaimTemplates.remove(builder);}} return (A)this;
    }

    public A removeAllFromVolumeClaimTemplates(Collection<V1PersistentVolumeClaim> items){
            for (V1PersistentVolumeClaim item : items) {V1PersistentVolumeClaimBuilder builder = new V1PersistentVolumeClaimBuilder(item);_visitables.get("volumeClaimTemplates").remove(builder);if (this.volumeClaimTemplates != null) {this.volumeClaimTemplates.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildVolumeClaimTemplates instead.
 * @return The buildable object.
 */
@Deprecated public List<V1PersistentVolumeClaim> getVolumeClaimTemplates(){
            return build(volumeClaimTemplates);
    }

    public List<V1PersistentVolumeClaim> buildVolumeClaimTemplates(){
            return build(volumeClaimTemplates);
    }

    public V1PersistentVolumeClaim buildVolumeClaimTemplate(int index){
            return this.volumeClaimTemplates.get(index).build();
    }

    public V1PersistentVolumeClaim buildFirstVolumeClaimTemplate(){
            return this.volumeClaimTemplates.get(0).build();
    }

    public V1PersistentVolumeClaim buildLastVolumeClaimTemplate(){
            return this.volumeClaimTemplates.get(volumeClaimTemplates.size() - 1).build();
    }

    public V1PersistentVolumeClaim buildMatchingVolumeClaimTemplate(io.kubernetes.client.fluent.Predicate<V1PersistentVolumeClaimBuilder> predicate){
            for (V1PersistentVolumeClaimBuilder item: volumeClaimTemplates) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingVolumeClaimTemplate(io.kubernetes.client.fluent.Predicate<V1PersistentVolumeClaimBuilder> predicate){
            for (V1PersistentVolumeClaimBuilder item: volumeClaimTemplates) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withVolumeClaimTemplates(List<V1PersistentVolumeClaim> volumeClaimTemplates){
            if (this.volumeClaimTemplates != null) { _visitables.get("volumeClaimTemplates").removeAll(this.volumeClaimTemplates);}
            if (volumeClaimTemplates != null) {this.volumeClaimTemplates = new ArrayList<V1PersistentVolumeClaimBuilder>(); for (V1PersistentVolumeClaim item : volumeClaimTemplates){this.addToVolumeClaimTemplates(item);}} else { this.volumeClaimTemplates = null;} return (A) this;
    }

    public A withVolumeClaimTemplates(V1PersistentVolumeClaim... volumeClaimTemplates){
            if (this.volumeClaimTemplates != null) {this.volumeClaimTemplates.clear();}
            if (volumeClaimTemplates != null) {for (V1PersistentVolumeClaim item :volumeClaimTemplates){ this.addToVolumeClaimTemplates(item);}} return (A) this;
    }

    public Boolean hasVolumeClaimTemplates(){
            return volumeClaimTemplates != null && !volumeClaimTemplates.isEmpty();
    }

    public V1beta1StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> addNewVolumeClaimTemplate(){
            return new VolumeClaimTemplatesNestedImpl();
    }

    public V1beta1StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> addNewVolumeClaimTemplateLike(V1PersistentVolumeClaim item){
            return new VolumeClaimTemplatesNestedImpl(-1, item);
    }

    public V1beta1StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> setNewVolumeClaimTemplateLike(int index,V1PersistentVolumeClaim item){
            return new VolumeClaimTemplatesNestedImpl(index, item);
    }

    public V1beta1StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> editVolumeClaimTemplate(int index){
            if (volumeClaimTemplates.size() <= index) throw new RuntimeException("Can't edit volumeClaimTemplates. Index exceeds size.");
            return setNewVolumeClaimTemplateLike(index, buildVolumeClaimTemplate(index));
    }

    public V1beta1StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> editFirstVolumeClaimTemplate(){
            if (volumeClaimTemplates.size() == 0) throw new RuntimeException("Can't edit first volumeClaimTemplates. The list is empty.");
            return setNewVolumeClaimTemplateLike(0, buildVolumeClaimTemplate(0));
    }

    public V1beta1StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> editLastVolumeClaimTemplate(){
            int index = volumeClaimTemplates.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last volumeClaimTemplates. The list is empty.");
            return setNewVolumeClaimTemplateLike(index, buildVolumeClaimTemplate(index));
    }

    public V1beta1StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> editMatchingVolumeClaimTemplate(io.kubernetes.client.fluent.Predicate<V1PersistentVolumeClaimBuilder> predicate){
            int index = -1;
            for (int i=0;i<volumeClaimTemplates.size();i++) { 
            if (predicate.apply(volumeClaimTemplates.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching volumeClaimTemplates. No match found.");
            return setNewVolumeClaimTemplateLike(index, buildVolumeClaimTemplate(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta1StatefulSetSpecFluentImpl that = (V1beta1StatefulSetSpecFluentImpl) o;
            if (podManagementPolicy != null ? !podManagementPolicy.equals(that.podManagementPolicy) :that.podManagementPolicy != null) return false;
            if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
            if (revisionHistoryLimit != null ? !revisionHistoryLimit.equals(that.revisionHistoryLimit) :that.revisionHistoryLimit != null) return false;
            if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
            if (serviceName != null ? !serviceName.equals(that.serviceName) :that.serviceName != null) return false;
            if (template != null ? !template.equals(that.template) :that.template != null) return false;
            if (updateStrategy != null ? !updateStrategy.equals(that.updateStrategy) :that.updateStrategy != null) return false;
            if (volumeClaimTemplates != null ? !volumeClaimTemplates.equals(that.volumeClaimTemplates) :that.volumeClaimTemplates != null) return false;
            return true;
    }


    public class SelectorNestedImpl<N> extends V1LabelSelectorFluentImpl<V1beta1StatefulSetSpecFluent.SelectorNested<N>> implements V1beta1StatefulSetSpecFluent.SelectorNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1LabelSelectorBuilder builder;
    
            SelectorNestedImpl(V1LabelSelector item){
                    this.builder = new V1LabelSelectorBuilder(this, item);
            }
            SelectorNestedImpl(){
                    this.builder = new V1LabelSelectorBuilder(this);
            }
    
    public N and(){
            return (N) V1beta1StatefulSetSpecFluentImpl.this.withSelector(builder.build());
    }
    public N endSelector(){
            return and();
    }

}
    public class TemplateNestedImpl<N> extends V1PodTemplateSpecFluentImpl<V1beta1StatefulSetSpecFluent.TemplateNested<N>> implements V1beta1StatefulSetSpecFluent.TemplateNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1PodTemplateSpecBuilder builder;
    
            TemplateNestedImpl(V1PodTemplateSpec item){
                    this.builder = new V1PodTemplateSpecBuilder(this, item);
            }
            TemplateNestedImpl(){
                    this.builder = new V1PodTemplateSpecBuilder(this);
            }
    
    public N and(){
            return (N) V1beta1StatefulSetSpecFluentImpl.this.withTemplate(builder.build());
    }
    public N endTemplate(){
            return and();
    }

}
    public class UpdateStrategyNestedImpl<N> extends V1beta1StatefulSetUpdateStrategyFluentImpl<V1beta1StatefulSetSpecFluent.UpdateStrategyNested<N>> implements V1beta1StatefulSetSpecFluent.UpdateStrategyNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1beta1StatefulSetUpdateStrategyBuilder builder;
    
            UpdateStrategyNestedImpl(V1beta1StatefulSetUpdateStrategy item){
                    this.builder = new V1beta1StatefulSetUpdateStrategyBuilder(this, item);
            }
            UpdateStrategyNestedImpl(){
                    this.builder = new V1beta1StatefulSetUpdateStrategyBuilder(this);
            }
    
    public N and(){
            return (N) V1beta1StatefulSetSpecFluentImpl.this.withUpdateStrategy(builder.build());
    }
    public N endUpdateStrategy(){
            return and();
    }

}
    public class VolumeClaimTemplatesNestedImpl<N> extends V1PersistentVolumeClaimFluentImpl<V1beta1StatefulSetSpecFluent.VolumeClaimTemplatesNested<N>> implements V1beta1StatefulSetSpecFluent.VolumeClaimTemplatesNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1PersistentVolumeClaimBuilder builder;
        private final int index;
    
            VolumeClaimTemplatesNestedImpl(int index,V1PersistentVolumeClaim item){
                    this.index = index;
                    this.builder = new V1PersistentVolumeClaimBuilder(this, item);
            }
            VolumeClaimTemplatesNestedImpl(){
                    this.index = -1;
                    this.builder = new V1PersistentVolumeClaimBuilder(this);
            }
    
    public N and(){
            return (N) V1beta1StatefulSetSpecFluentImpl.this.setToVolumeClaimTemplates(index, builder.build());
    }
    public N endVolumeClaimTemplate(){
            return and();
    }

}


}
