package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1WebhookBuilder extends V1beta1WebhookFluentImpl<V1beta1WebhookBuilder> implements VisitableBuilder<V1beta1Webhook,V1beta1WebhookBuilder>{

    V1beta1WebhookFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta1WebhookBuilder(){
            this(true);
    }
    public V1beta1WebhookBuilder(Boolean validationEnabled){
            this(new V1beta1Webhook(), validationEnabled);
    }
    public V1beta1WebhookBuilder(V1beta1WebhookFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta1WebhookBuilder(V1beta1WebhookFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta1Webhook(), validationEnabled);
    }
    public V1beta1WebhookBuilder(V1beta1WebhookFluent<?> fluent,V1beta1Webhook instance){
            this(fluent, instance, true);
    }
    public V1beta1WebhookBuilder(V1beta1WebhookFluent<?> fluent,V1beta1Webhook instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withClientConfig(instance.getClientConfig());

            fluent.withFailurePolicy(instance.getFailurePolicy());

            fluent.withName(instance.getName());

            fluent.withNamespaceSelector(instance.getNamespaceSelector());

            fluent.withRules(instance.getRules());

            fluent.withSideEffects(instance.getSideEffects());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta1WebhookBuilder(V1beta1Webhook instance){
            this(instance,true);
    }
    public V1beta1WebhookBuilder(V1beta1Webhook instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withClientConfig(instance.getClientConfig());

            this.withFailurePolicy(instance.getFailurePolicy());

            this.withName(instance.getName());

            this.withNamespaceSelector(instance.getNamespaceSelector());

            this.withRules(instance.getRules());

            this.withSideEffects(instance.getSideEffects());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta1Webhook build(){
            V1beta1Webhook buildable = new V1beta1Webhook();
            buildable.setClientConfig(fluent.getClientConfig());
            buildable.setFailurePolicy(fluent.getFailurePolicy());
            buildable.setName(fluent.getName());
            buildable.setNamespaceSelector(fluent.getNamespaceSelector());
            buildable.setRules(fluent.getRules());
            buildable.setSideEffects(fluent.getSideEffects());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta1WebhookBuilder that = (V1beta1WebhookBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
