package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta2ReplicaSetStatusBuilder extends V1beta2ReplicaSetStatusFluentImpl<V1beta2ReplicaSetStatusBuilder> implements VisitableBuilder<V1beta2ReplicaSetStatus,V1beta2ReplicaSetStatusBuilder>{

    V1beta2ReplicaSetStatusFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta2ReplicaSetStatusBuilder(){
            this(true);
    }
    public V1beta2ReplicaSetStatusBuilder(Boolean validationEnabled){
            this(new V1beta2ReplicaSetStatus(), validationEnabled);
    }
    public V1beta2ReplicaSetStatusBuilder(V1beta2ReplicaSetStatusFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta2ReplicaSetStatusBuilder(V1beta2ReplicaSetStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta2ReplicaSetStatus(), validationEnabled);
    }
    public V1beta2ReplicaSetStatusBuilder(V1beta2ReplicaSetStatusFluent<?> fluent,V1beta2ReplicaSetStatus instance){
            this(fluent, instance, true);
    }
    public V1beta2ReplicaSetStatusBuilder(V1beta2ReplicaSetStatusFluent<?> fluent,V1beta2ReplicaSetStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAvailableReplicas(instance.getAvailableReplicas());

            fluent.withConditions(instance.getConditions());

            fluent.withFullyLabeledReplicas(instance.getFullyLabeledReplicas());

            fluent.withObservedGeneration(instance.getObservedGeneration());

            fluent.withReadyReplicas(instance.getReadyReplicas());

            fluent.withReplicas(instance.getReplicas());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta2ReplicaSetStatusBuilder(V1beta2ReplicaSetStatus instance){
            this(instance,true);
    }
    public V1beta2ReplicaSetStatusBuilder(V1beta2ReplicaSetStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAvailableReplicas(instance.getAvailableReplicas());

            this.withConditions(instance.getConditions());

            this.withFullyLabeledReplicas(instance.getFullyLabeledReplicas());

            this.withObservedGeneration(instance.getObservedGeneration());

            this.withReadyReplicas(instance.getReadyReplicas());

            this.withReplicas(instance.getReplicas());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta2ReplicaSetStatus build(){
            V1beta2ReplicaSetStatus buildable = new V1beta2ReplicaSetStatus();
            buildable.setAvailableReplicas(fluent.getAvailableReplicas());
            buildable.setConditions(fluent.getConditions());
            buildable.setFullyLabeledReplicas(fluent.getFullyLabeledReplicas());
            buildable.setObservedGeneration(fluent.getObservedGeneration());
            buildable.setReadyReplicas(fluent.getReadyReplicas());
            buildable.setReplicas(fluent.getReplicas());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta2ReplicaSetStatusBuilder that = (V1beta2ReplicaSetStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
