package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface V1beta2ReplicaSetStatusFluent<A extends V1beta2ReplicaSetStatusFluent<A>> extends Fluent<A>{


    public Integer getAvailableReplicas();
    public A withAvailableReplicas(Integer availableReplicas);
    public Boolean hasAvailableReplicas();
    public A addToConditions(int index,V1beta2ReplicaSetCondition item);
    public A setToConditions(int index,V1beta2ReplicaSetCondition item);
    public A addToConditions(V1beta2ReplicaSetCondition... items);
    public A addAllToConditions(Collection<V1beta2ReplicaSetCondition> items);
    public A removeFromConditions(V1beta2ReplicaSetCondition... items);
    public A removeAllFromConditions(Collection<V1beta2ReplicaSetCondition> items);
    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<V1beta2ReplicaSetCondition> getConditions();
    public List<V1beta2ReplicaSetCondition> buildConditions();
    public V1beta2ReplicaSetCondition buildCondition(int index);
    public V1beta2ReplicaSetCondition buildFirstCondition();
    public V1beta2ReplicaSetCondition buildLastCondition();
    public V1beta2ReplicaSetCondition buildMatchingCondition(io.kubernetes.client.fluent.Predicate<V1beta2ReplicaSetConditionBuilder> predicate);
    public Boolean hasMatchingCondition(io.kubernetes.client.fluent.Predicate<V1beta2ReplicaSetConditionBuilder> predicate);
    public A withConditions(List<V1beta2ReplicaSetCondition> conditions);
    public A withConditions(V1beta2ReplicaSetCondition... conditions);
    public Boolean hasConditions();
    public V1beta2ReplicaSetStatusFluent.ConditionsNested<A> addNewCondition();
    public V1beta2ReplicaSetStatusFluent.ConditionsNested<A> addNewConditionLike(V1beta2ReplicaSetCondition item);
    public V1beta2ReplicaSetStatusFluent.ConditionsNested<A> setNewConditionLike(int index,V1beta2ReplicaSetCondition item);
    public V1beta2ReplicaSetStatusFluent.ConditionsNested<A> editCondition(int index);
    public V1beta2ReplicaSetStatusFluent.ConditionsNested<A> editFirstCondition();
    public V1beta2ReplicaSetStatusFluent.ConditionsNested<A> editLastCondition();
    public V1beta2ReplicaSetStatusFluent.ConditionsNested<A> editMatchingCondition(io.kubernetes.client.fluent.Predicate<V1beta2ReplicaSetConditionBuilder> predicate);
    public Integer getFullyLabeledReplicas();
    public A withFullyLabeledReplicas(Integer fullyLabeledReplicas);
    public Boolean hasFullyLabeledReplicas();
    public Long getObservedGeneration();
    public A withObservedGeneration(Long observedGeneration);
    public Boolean hasObservedGeneration();
    public Integer getReadyReplicas();
    public A withReadyReplicas(Integer readyReplicas);
    public Boolean hasReadyReplicas();
    public Integer getReplicas();
    public A withReplicas(Integer replicas);
    public Boolean hasReplicas();

    public interface ConditionsNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1beta2ReplicaSetConditionFluent<V1beta2ReplicaSetStatusFluent.ConditionsNested<N>>{

        
    public N and();    public N endCondition();
}


}
