package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta2RollingUpdateStatefulSetStrategyBuilder extends V1beta2RollingUpdateStatefulSetStrategyFluentImpl<V1beta2RollingUpdateStatefulSetStrategyBuilder> implements VisitableBuilder<V1beta2RollingUpdateStatefulSetStrategy,V1beta2RollingUpdateStatefulSetStrategyBuilder>{

    V1beta2RollingUpdateStatefulSetStrategyFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta2RollingUpdateStatefulSetStrategyBuilder(){
            this(true);
    }
    public V1beta2RollingUpdateStatefulSetStrategyBuilder(Boolean validationEnabled){
            this(new V1beta2RollingUpdateStatefulSetStrategy(), validationEnabled);
    }
    public V1beta2RollingUpdateStatefulSetStrategyBuilder(V1beta2RollingUpdateStatefulSetStrategyFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta2RollingUpdateStatefulSetStrategyBuilder(V1beta2RollingUpdateStatefulSetStrategyFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta2RollingUpdateStatefulSetStrategy(), validationEnabled);
    }
    public V1beta2RollingUpdateStatefulSetStrategyBuilder(V1beta2RollingUpdateStatefulSetStrategyFluent<?> fluent,V1beta2RollingUpdateStatefulSetStrategy instance){
            this(fluent, instance, true);
    }
    public V1beta2RollingUpdateStatefulSetStrategyBuilder(V1beta2RollingUpdateStatefulSetStrategyFluent<?> fluent,V1beta2RollingUpdateStatefulSetStrategy instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withPartition(instance.getPartition());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta2RollingUpdateStatefulSetStrategyBuilder(V1beta2RollingUpdateStatefulSetStrategy instance){
            this(instance,true);
    }
    public V1beta2RollingUpdateStatefulSetStrategyBuilder(V1beta2RollingUpdateStatefulSetStrategy instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withPartition(instance.getPartition());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta2RollingUpdateStatefulSetStrategy build(){
            V1beta2RollingUpdateStatefulSetStrategy buildable = new V1beta2RollingUpdateStatefulSetStrategy();
            buildable.setPartition(fluent.getPartition());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta2RollingUpdateStatefulSetStrategyBuilder that = (V1beta2RollingUpdateStatefulSetStrategyBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
