package io.kubernetes.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1beta2StatefulSetStatusFluentImpl<A extends V1beta2StatefulSetStatusFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1beta2StatefulSetStatusFluent<A>{

    private Integer collisionCount;
    private List<V1beta2StatefulSetConditionBuilder> conditions;
    private Integer currentReplicas;
    private String currentRevision;
    private Long observedGeneration;
    private Integer readyReplicas;
    private Integer replicas;
    private String updateRevision;
    private Integer updatedReplicas;

    public V1beta2StatefulSetStatusFluentImpl(){
    }
    public V1beta2StatefulSetStatusFluentImpl(V1beta2StatefulSetStatus instance){
            this.withCollisionCount(instance.getCollisionCount());

            this.withConditions(instance.getConditions());

            this.withCurrentReplicas(instance.getCurrentReplicas());

            this.withCurrentRevision(instance.getCurrentRevision());

            this.withObservedGeneration(instance.getObservedGeneration());

            this.withReadyReplicas(instance.getReadyReplicas());

            this.withReplicas(instance.getReplicas());

            this.withUpdateRevision(instance.getUpdateRevision());

            this.withUpdatedReplicas(instance.getUpdatedReplicas());

    }

    public Integer getCollisionCount(){
            return this.collisionCount;
    }

    public A withCollisionCount(Integer collisionCount){
            this.collisionCount=collisionCount; return (A) this;
    }

    public Boolean hasCollisionCount(){
            return this.collisionCount != null;
    }

    public A addToConditions(int index,V1beta2StatefulSetCondition item){
            if (this.conditions == null) {this.conditions = new ArrayList<V1beta2StatefulSetConditionBuilder>();}
            V1beta2StatefulSetConditionBuilder builder = new V1beta2StatefulSetConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,V1beta2StatefulSetCondition item){
            if (this.conditions == null) {this.conditions = new ArrayList<V1beta2StatefulSetConditionBuilder>();}
            V1beta2StatefulSetConditionBuilder builder = new V1beta2StatefulSetConditionBuilder(item);
            if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
            if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
             return (A)this;
    }

    public A addToConditions(V1beta2StatefulSetCondition... items){
            if (this.conditions == null) {this.conditions = new ArrayList<V1beta2StatefulSetConditionBuilder>();}
            for (V1beta2StatefulSetCondition item : items) {V1beta2StatefulSetConditionBuilder builder = new V1beta2StatefulSetConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(Collection<V1beta2StatefulSetCondition> items){
            if (this.conditions == null) {this.conditions = new ArrayList<V1beta2StatefulSetConditionBuilder>();}
            for (V1beta2StatefulSetCondition item : items) {V1beta2StatefulSetConditionBuilder builder = new V1beta2StatefulSetConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(V1beta2StatefulSetCondition... items){
            for (V1beta2StatefulSetCondition item : items) {V1beta2StatefulSetConditionBuilder builder = new V1beta2StatefulSetConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(Collection<V1beta2StatefulSetCondition> items){
            for (V1beta2StatefulSetCondition item : items) {V1beta2StatefulSetConditionBuilder builder = new V1beta2StatefulSetConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<V1beta2StatefulSetCondition> getConditions(){
            return build(conditions);
    }

    public List<V1beta2StatefulSetCondition> buildConditions(){
            return build(conditions);
    }

    public V1beta2StatefulSetCondition buildCondition(int index){
            return this.conditions.get(index).build();
    }

    public V1beta2StatefulSetCondition buildFirstCondition(){
            return this.conditions.get(0).build();
    }

    public V1beta2StatefulSetCondition buildLastCondition(){
            return this.conditions.get(conditions.size() - 1).build();
    }

    public V1beta2StatefulSetCondition buildMatchingCondition(io.kubernetes.client.fluent.Predicate<V1beta2StatefulSetConditionBuilder> predicate){
            for (V1beta2StatefulSetConditionBuilder item: conditions) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public Boolean hasMatchingCondition(io.kubernetes.client.fluent.Predicate<V1beta2StatefulSetConditionBuilder> predicate){
            for (V1beta2StatefulSetConditionBuilder item: conditions) { if(predicate.apply(item)){return true;} } return false;
    }

    public A withConditions(List<V1beta2StatefulSetCondition> conditions){
            if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
            if (conditions != null) {this.conditions = new ArrayList<V1beta2StatefulSetConditionBuilder>(); for (V1beta2StatefulSetCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(V1beta2StatefulSetCondition... conditions){
            if (this.conditions != null) {this.conditions.clear();}
            if (conditions != null) {for (V1beta2StatefulSetCondition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public Boolean hasConditions(){
            return conditions != null && !conditions.isEmpty();
    }

    public V1beta2StatefulSetStatusFluent.ConditionsNested<A> addNewCondition(){
            return new ConditionsNestedImpl();
    }

    public V1beta2StatefulSetStatusFluent.ConditionsNested<A> addNewConditionLike(V1beta2StatefulSetCondition item){
            return new ConditionsNestedImpl(-1, item);
    }

    public V1beta2StatefulSetStatusFluent.ConditionsNested<A> setNewConditionLike(int index,V1beta2StatefulSetCondition item){
            return new ConditionsNestedImpl(index, item);
    }

    public V1beta2StatefulSetStatusFluent.ConditionsNested<A> editCondition(int index){
            if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public V1beta2StatefulSetStatusFluent.ConditionsNested<A> editFirstCondition(){
            if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
            return setNewConditionLike(0, buildCondition(0));
    }

    public V1beta2StatefulSetStatusFluent.ConditionsNested<A> editLastCondition(){
            int index = conditions.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public V1beta2StatefulSetStatusFluent.ConditionsNested<A> editMatchingCondition(io.kubernetes.client.fluent.Predicate<V1beta2StatefulSetConditionBuilder> predicate){
            int index = -1;
            for (int i=0;i<conditions.size();i++) { 
            if (predicate.apply(conditions.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
            return setNewConditionLike(index, buildCondition(index));
    }

    public Integer getCurrentReplicas(){
            return this.currentReplicas;
    }

    public A withCurrentReplicas(Integer currentReplicas){
            this.currentReplicas=currentReplicas; return (A) this;
    }

    public Boolean hasCurrentReplicas(){
            return this.currentReplicas != null;
    }

    public String getCurrentRevision(){
            return this.currentRevision;
    }

    public A withCurrentRevision(String currentRevision){
            this.currentRevision=currentRevision; return (A) this;
    }

    public Boolean hasCurrentRevision(){
            return this.currentRevision != null;
    }

    public A withNewCurrentRevision(String arg1){
            return (A)withCurrentRevision(new String(arg1));
    }

    public A withNewCurrentRevision(StringBuilder arg1){
            return (A)withCurrentRevision(new String(arg1));
    }

    public A withNewCurrentRevision(StringBuffer arg1){
            return (A)withCurrentRevision(new String(arg1));
    }

    public Long getObservedGeneration(){
            return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration){
            this.observedGeneration=observedGeneration; return (A) this;
    }

    public Boolean hasObservedGeneration(){
            return this.observedGeneration != null;
    }

    public Integer getReadyReplicas(){
            return this.readyReplicas;
    }

    public A withReadyReplicas(Integer readyReplicas){
            this.readyReplicas=readyReplicas; return (A) this;
    }

    public Boolean hasReadyReplicas(){
            return this.readyReplicas != null;
    }

    public Integer getReplicas(){
            return this.replicas;
    }

    public A withReplicas(Integer replicas){
            this.replicas=replicas; return (A) this;
    }

    public Boolean hasReplicas(){
            return this.replicas != null;
    }

    public String getUpdateRevision(){
            return this.updateRevision;
    }

    public A withUpdateRevision(String updateRevision){
            this.updateRevision=updateRevision; return (A) this;
    }

    public Boolean hasUpdateRevision(){
            return this.updateRevision != null;
    }

    public A withNewUpdateRevision(String arg1){
            return (A)withUpdateRevision(new String(arg1));
    }

    public A withNewUpdateRevision(StringBuilder arg1){
            return (A)withUpdateRevision(new String(arg1));
    }

    public A withNewUpdateRevision(StringBuffer arg1){
            return (A)withUpdateRevision(new String(arg1));
    }

    public Integer getUpdatedReplicas(){
            return this.updatedReplicas;
    }

    public A withUpdatedReplicas(Integer updatedReplicas){
            this.updatedReplicas=updatedReplicas; return (A) this;
    }

    public Boolean hasUpdatedReplicas(){
            return this.updatedReplicas != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta2StatefulSetStatusFluentImpl that = (V1beta2StatefulSetStatusFluentImpl) o;
            if (collisionCount != null ? !collisionCount.equals(that.collisionCount) :that.collisionCount != null) return false;
            if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
            if (currentReplicas != null ? !currentReplicas.equals(that.currentReplicas) :that.currentReplicas != null) return false;
            if (currentRevision != null ? !currentRevision.equals(that.currentRevision) :that.currentRevision != null) return false;
            if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
            if (readyReplicas != null ? !readyReplicas.equals(that.readyReplicas) :that.readyReplicas != null) return false;
            if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
            if (updateRevision != null ? !updateRevision.equals(that.updateRevision) :that.updateRevision != null) return false;
            if (updatedReplicas != null ? !updatedReplicas.equals(that.updatedReplicas) :that.updatedReplicas != null) return false;
            return true;
    }


    public class ConditionsNestedImpl<N> extends V1beta2StatefulSetConditionFluentImpl<V1beta2StatefulSetStatusFluent.ConditionsNested<N>> implements V1beta2StatefulSetStatusFluent.ConditionsNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1beta2StatefulSetConditionBuilder builder;
        private final int index;
    
            ConditionsNestedImpl(int index,V1beta2StatefulSetCondition item){
                    this.index = index;
                    this.builder = new V1beta2StatefulSetConditionBuilder(this, item);
            }
            ConditionsNestedImpl(){
                    this.index = -1;
                    this.builder = new V1beta2StatefulSetConditionBuilder(this);
            }
    
    public N and(){
            return (N) V1beta2StatefulSetStatusFluentImpl.this.setToConditions(index, builder.build());
    }
    public N endCondition(){
            return and();
    }

}


}
