package io.kubernetes.client.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class V2beta1ObjectMetricStatusFluentImpl<A extends V2beta1ObjectMetricStatusFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V2beta1ObjectMetricStatusFluent<A>{

    private String averageValue;
    private String currentValue;
    private String metricName;
    private V1LabelSelectorBuilder selector;
    private V2beta1CrossVersionObjectReferenceBuilder target;

    public V2beta1ObjectMetricStatusFluentImpl(){
    }
    public V2beta1ObjectMetricStatusFluentImpl(V2beta1ObjectMetricStatus instance){
            this.withAverageValue(instance.getAverageValue());

            this.withCurrentValue(instance.getCurrentValue());

            this.withMetricName(instance.getMetricName());

            this.withSelector(instance.getSelector());

            this.withTarget(instance.getTarget());

    }

    public String getAverageValue(){
            return this.averageValue;
    }

    public A withAverageValue(String averageValue){
            this.averageValue=averageValue; return (A) this;
    }

    public Boolean hasAverageValue(){
            return this.averageValue != null;
    }

    public A withNewAverageValue(String arg1){
            return (A)withAverageValue(new String(arg1));
    }

    public A withNewAverageValue(StringBuilder arg1){
            return (A)withAverageValue(new String(arg1));
    }

    public A withNewAverageValue(StringBuffer arg1){
            return (A)withAverageValue(new String(arg1));
    }

    public String getCurrentValue(){
            return this.currentValue;
    }

    public A withCurrentValue(String currentValue){
            this.currentValue=currentValue; return (A) this;
    }

    public Boolean hasCurrentValue(){
            return this.currentValue != null;
    }

    public A withNewCurrentValue(String arg1){
            return (A)withCurrentValue(new String(arg1));
    }

    public A withNewCurrentValue(StringBuilder arg1){
            return (A)withCurrentValue(new String(arg1));
    }

    public A withNewCurrentValue(StringBuffer arg1){
            return (A)withCurrentValue(new String(arg1));
    }

    public String getMetricName(){
            return this.metricName;
    }

    public A withMetricName(String metricName){
            this.metricName=metricName; return (A) this;
    }

    public Boolean hasMetricName(){
            return this.metricName != null;
    }

    public A withNewMetricName(String arg1){
            return (A)withMetricName(new String(arg1));
    }

    public A withNewMetricName(StringBuilder arg1){
            return (A)withMetricName(new String(arg1));
    }

    public A withNewMetricName(StringBuffer arg1){
            return (A)withMetricName(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSelector instead.
 * @return The buildable object.
 */
@Deprecated public V1LabelSelector getSelector(){
            return this.selector!=null?this.selector.build():null;
    }

    public V1LabelSelector buildSelector(){
            return this.selector!=null?this.selector.build():null;
    }

    public A withSelector(V1LabelSelector selector){
            _visitables.get("selector").remove(this.selector);
            if (selector!=null){ this.selector= new V1LabelSelectorBuilder(selector); _visitables.get("selector").add(this.selector);} return (A) this;
    }

    public Boolean hasSelector(){
            return this.selector != null;
    }

    public V2beta1ObjectMetricStatusFluent.SelectorNested<A> withNewSelector(){
            return new SelectorNestedImpl();
    }

    public V2beta1ObjectMetricStatusFluent.SelectorNested<A> withNewSelectorLike(V1LabelSelector item){
            return new SelectorNestedImpl(item);
    }

    public V2beta1ObjectMetricStatusFluent.SelectorNested<A> editSelector(){
            return withNewSelectorLike(getSelector());
    }

    public V2beta1ObjectMetricStatusFluent.SelectorNested<A> editOrNewSelector(){
            return withNewSelectorLike(getSelector() != null ? getSelector(): new V1LabelSelectorBuilder().build());
    }

    public V2beta1ObjectMetricStatusFluent.SelectorNested<A> editOrNewSelectorLike(V1LabelSelector item){
            return withNewSelectorLike(getSelector() != null ? getSelector(): item);
    }

    
/**
 * This method has been deprecated, please use method buildTarget instead.
 * @return The buildable object.
 */
@Deprecated public V2beta1CrossVersionObjectReference getTarget(){
            return this.target!=null?this.target.build():null;
    }

    public V2beta1CrossVersionObjectReference buildTarget(){
            return this.target!=null?this.target.build():null;
    }

    public A withTarget(V2beta1CrossVersionObjectReference target){
            _visitables.get("target").remove(this.target);
            if (target!=null){ this.target= new V2beta1CrossVersionObjectReferenceBuilder(target); _visitables.get("target").add(this.target);} return (A) this;
    }

    public Boolean hasTarget(){
            return this.target != null;
    }

    public V2beta1ObjectMetricStatusFluent.TargetNested<A> withNewTarget(){
            return new TargetNestedImpl();
    }

    public V2beta1ObjectMetricStatusFluent.TargetNested<A> withNewTargetLike(V2beta1CrossVersionObjectReference item){
            return new TargetNestedImpl(item);
    }

    public V2beta1ObjectMetricStatusFluent.TargetNested<A> editTarget(){
            return withNewTargetLike(getTarget());
    }

    public V2beta1ObjectMetricStatusFluent.TargetNested<A> editOrNewTarget(){
            return withNewTargetLike(getTarget() != null ? getTarget(): new V2beta1CrossVersionObjectReferenceBuilder().build());
    }

    public V2beta1ObjectMetricStatusFluent.TargetNested<A> editOrNewTargetLike(V2beta1CrossVersionObjectReference item){
            return withNewTargetLike(getTarget() != null ? getTarget(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V2beta1ObjectMetricStatusFluentImpl that = (V2beta1ObjectMetricStatusFluentImpl) o;
            if (averageValue != null ? !averageValue.equals(that.averageValue) :that.averageValue != null) return false;
            if (currentValue != null ? !currentValue.equals(that.currentValue) :that.currentValue != null) return false;
            if (metricName != null ? !metricName.equals(that.metricName) :that.metricName != null) return false;
            if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
            if (target != null ? !target.equals(that.target) :that.target != null) return false;
            return true;
    }


    public class SelectorNestedImpl<N> extends V1LabelSelectorFluentImpl<V2beta1ObjectMetricStatusFluent.SelectorNested<N>> implements V2beta1ObjectMetricStatusFluent.SelectorNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1LabelSelectorBuilder builder;
    
            SelectorNestedImpl(V1LabelSelector item){
                    this.builder = new V1LabelSelectorBuilder(this, item);
            }
            SelectorNestedImpl(){
                    this.builder = new V1LabelSelectorBuilder(this);
            }
    
    public N and(){
            return (N) V2beta1ObjectMetricStatusFluentImpl.this.withSelector(builder.build());
    }
    public N endSelector(){
            return and();
    }

}
    public class TargetNestedImpl<N> extends V2beta1CrossVersionObjectReferenceFluentImpl<V2beta1ObjectMetricStatusFluent.TargetNested<N>> implements V2beta1ObjectMetricStatusFluent.TargetNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V2beta1CrossVersionObjectReferenceBuilder builder;
    
            TargetNestedImpl(V2beta1CrossVersionObjectReference item){
                    this.builder = new V2beta1CrossVersionObjectReferenceBuilder(this, item);
            }
            TargetNestedImpl(){
                    this.builder = new V2beta1CrossVersionObjectReferenceBuilder(this);
            }
    
    public N and(){
            return (N) V2beta1ObjectMetricStatusFluentImpl.this.withTarget(builder.build());
    }
    public N endTarget(){
            return and();
    }

}


}
