/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.spqr.spring.autoconfigure;

import io.leangen.graphql.util.Utils;
import javax.annotation.PostConstruct;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="graphql.spqr")
public class SpqrProperties {
    public static String DEFAULT_ENDPOINT = "/graphql";
    public static String DEFAULT_GUI_ENDPOINT = "/gui";
    private String[] basePackages;
    private boolean abstractInputTypeResolution;
    private int maxComplexity = -1;
    private Relay relay = new Relay();
    private Http http = new Http();
    private WebSocket ws = new WebSocket();
    private Gui gui = new Gui();

    @PostConstruct
    public void setDefaults() {
        if (Utils.isEmpty((String)this.ws.getEndpoint())) {
            this.ws.setEndpoint(this.http.endpoint);
        }
        if (Utils.isEmpty((String)this.gui.getTargetEndpoint())) {
            this.gui.setTargetEndpoint(this.http.endpoint);
        }
        if (Utils.isEmpty((String)this.gui.getTargetWsEndpoint())) {
            this.gui.setTargetWsEndpoint(this.ws.endpoint);
        }
    }

    public String[] getBasePackages() {
        return this.basePackages;
    }

    public void setBasePackages(String[] basePackages) {
        this.basePackages = basePackages;
    }

    public boolean isAbstractInputTypeResolution() {
        return this.abstractInputTypeResolution;
    }

    public void setAbstractInputTypeResolution(boolean abstractInputTypeResolution) {
        this.abstractInputTypeResolution = abstractInputTypeResolution;
    }

    public int getMaxComplexity() {
        return this.maxComplexity;
    }

    public void setMaxComplexity(int maxComplexity) {
        this.maxComplexity = maxComplexity;
    }

    public Relay getRelay() {
        return this.relay;
    }

    public void setRelay(Relay relay) {
        this.relay = relay;
    }

    public Http getHttp() {
        return this.http;
    }

    public void setHttp(Http http) {
        this.http = http;
    }

    public WebSocket getWs() {
        return this.ws;
    }

    public void setWs(WebSocket ws) {
        this.ws = ws;
    }

    public Gui getGui() {
        return this.gui;
    }

    public void setGui(Gui gui) {
        this.gui = gui;
    }

    public static class Relay {
        private boolean enabled;
        private String mutationWrapper;
        private String mutationWrapperDescription;
        private boolean connectionCheckRelaxed;
        private boolean springDataCompatible;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getMutationWrapper() {
            return this.mutationWrapper;
        }

        public void setMutationWrapper(String mutationWrapper) {
            this.mutationWrapper = mutationWrapper;
        }

        public String getMutationWrapperDescription() {
            return this.mutationWrapperDescription;
        }

        public void setMutationWrapperDescription(String mutationWrapperDescription) {
            this.mutationWrapperDescription = mutationWrapperDescription;
        }

        public boolean isConnectionCheckRelaxed() {
            return this.connectionCheckRelaxed;
        }

        public void setConnectionCheckRelaxed(boolean connectionCheckRelaxed) {
            this.connectionCheckRelaxed = connectionCheckRelaxed;
        }

        public boolean isSpringDataCompatible() {
            return this.springDataCompatible;
        }

        public void setSpringDataCompatible(boolean springDataCompatible) {
            this.springDataCompatible = springDataCompatible;
        }
    }

    public static class Http {
        private boolean enabled = true;
        private String endpoint = DEFAULT_ENDPOINT;
        private Mvc mvc = new Mvc();

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public Mvc getMvc() {
            return this.mvc;
        }

        public void setMvc(Mvc mvc) {
            this.mvc = mvc;
        }

        public static class Mvc {
            private Executor executor = Executor.ASYNC;

            public Executor getExecutor() {
                return this.executor;
            }

            public void setExecutor(Executor executor) {
                this.executor = executor;
            }

            public static enum Executor {
                ASYNC,
                BLOCKING;

            }
        }
    }

    public static class WebSocket {
        private boolean enabled = true;
        private String endpoint;
        private int sendTimeLimit = 10000;
        private int sendBufferSizeLimit = 524288;
        private String[] allowedOrigins = new String[]{"*"};
        private KeepAlive keepAlive = new KeepAlive();

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public int getSendTimeLimit() {
            return this.sendTimeLimit;
        }

        public void setSendTimeLimit(int sendTimeLimit) {
            this.sendTimeLimit = sendTimeLimit;
        }

        public int getSendBufferSizeLimit() {
            return this.sendBufferSizeLimit;
        }

        public void setSendBufferSizeLimit(int sendBufferSizeLimit) {
            this.sendBufferSizeLimit = sendBufferSizeLimit;
        }

        public String[] getAllowedOrigins() {
            return this.allowedOrigins;
        }

        public void setAllowedOrigins(String[] allowedOrigins) {
            this.allowedOrigins = allowedOrigins;
        }

        public KeepAlive getKeepAlive() {
            return this.keepAlive;
        }

        public void setKeepAlive(KeepAlive keepAlive) {
            this.keepAlive = keepAlive;
        }

        public static class KeepAlive {
            private boolean enabled;
            private int intervalMillis = 10000;

            public boolean isEnabled() {
                return this.enabled;
            }

            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }

            public int getIntervalMillis() {
                return this.intervalMillis;
            }

            public void setIntervalMillis(int intervalMillis) {
                this.intervalMillis = intervalMillis;
            }
        }
    }

    public static class Gui {
        private boolean enabled = true;
        private String endpoint = DEFAULT_GUI_ENDPOINT;
        private String targetEndpoint;
        private String targetWsEndpoint;
        private String pageTitle = "GraphQL Playground";

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public String getTargetEndpoint() {
            return this.targetEndpoint;
        }

        public void setTargetEndpoint(String targetEndpoint) {
            this.targetEndpoint = targetEndpoint;
        }

        public String getTargetWsEndpoint() {
            return this.targetWsEndpoint;
        }

        public void setTargetWsEndpoint(String targetWsEndpoint) {
            this.targetWsEndpoint = targetWsEndpoint;
        }

        public String getPageTitle() {
            return this.pageTitle;
        }

        public void setPageTitle(String pageTitle) {
            this.pageTitle = pageTitle;
        }
    }
}

