/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.spqr.spring.modules.reactive;

import io.leangen.graphql.execution.ResolverInterceptor;
import io.leangen.graphql.execution.ResolverInterceptorFactory;
import io.leangen.graphql.execution.ResolverInterceptorFactoryParams;
import io.leangen.graphql.generator.mapping.OutputConverter;
import io.leangen.graphql.generator.mapping.SchemaTransformer;
import io.leangen.graphql.generator.mapping.TypeMapper;
import io.leangen.graphql.module.Module;
import io.leangen.graphql.spqr.spring.modules.reactive.FluxAdapter;
import io.leangen.graphql.spqr.spring.modules.reactive.FluxInterceptor;
import io.leangen.graphql.spqr.spring.modules.reactive.MonoAdapter;
import io.leangen.graphql.spqr.spring.modules.reactive.MonoInterceptor;
import io.leangen.graphql.util.ClassUtils;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactorModule
implements Module {
    public void setUp(Module.SetupContext context) {
        MonoAdapter monoAdapter = new MonoAdapter();
        FluxAdapter fluxAdapter = new FluxAdapter();
        context.getSchemaGenerator().withTypeMappers(new TypeMapper[]{monoAdapter, fluxAdapter}).withOutputConverters(new OutputConverter[]{monoAdapter, fluxAdapter}).withSchemaTransformers(new SchemaTransformer[]{fluxAdapter}).withResolverInterceptorFactories((config, factories) -> factories.append((Object[])new ResolverInterceptorFactory[]{new InterceptorFactory()}));
    }

    private static class InterceptorFactory
    implements ResolverInterceptorFactory {
        private InterceptorFactory() {
        }

        public List<ResolverInterceptor> getInterceptors(ResolverInterceptorFactoryParams params) {
            Class returnType = ClassUtils.getRawType((Type)params.getResolver().getReturnType().getType());
            if (Flux.class.isAssignableFrom(returnType)) {
                return Collections.singletonList(new FluxInterceptor());
            }
            if (Mono.class.isAssignableFrom(returnType)) {
                return Collections.singletonList(new MonoInterceptor());
            }
            return Collections.emptyList();
        }
    }
}

