/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql;

import io.leangen.graphql.ConfigurationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class ExtensionList<E>
extends ArrayList<E> {
    public ExtensionList(Collection<? extends E> c) {
        super(c);
    }

    public E getFirstOfType(Class<? extends E> extensionType) {
        return this.get(this.firstIndexOfTypeStrict(extensionType));
    }

    @SafeVarargs
    public final ExtensionList<E> append(E ... extensions) {
        Collections.addAll(this, extensions);
        return this;
    }

    public ExtensionList<E> append(Collection<E> extensions) {
        super.addAll(extensions);
        return this;
    }

    @SafeVarargs
    public final ExtensionList<E> prepend(E ... extensions) {
        return this.insert(0, extensions);
    }

    @SafeVarargs
    public final ExtensionList<E> insert(int index, E ... extensions) {
        for (int i = 0; i < extensions.length; ++i) {
            this.add(index + i, extensions[i]);
        }
        return this;
    }

    @SafeVarargs
    public final ExtensionList<E> insertAfter(Class<? extends E> extensionType, E ... extensions) {
        return this.insert(this.firstIndexOfTypeStrict(extensionType) + 1, extensions);
    }

    @SafeVarargs
    public final ExtensionList<E> insertAfter(E extension, E ... extensions) {
        return this.insert(this.indexOf(extension) + 1, extensions);
    }

    @SafeVarargs
    public final ExtensionList<E> insertBefore(Class<? extends E> extensionType, E ... extensions) {
        return this.insert(this.firstIndexOfTypeStrict(extensionType), extensions);
    }

    @SafeVarargs
    public final ExtensionList<E> insertBefore(E extension, E ... extensions) {
        return this.insert(this.indexOf(extension), extensions);
    }

    @SafeVarargs
    public final ExtensionList<E> insertAfterOrAppend(Class<? extends E> extensionType, E ... extensions) {
        int firstIndexOfType = this.firstIndexOfType(extensionType);
        if (firstIndexOfType >= 0) {
            return this.insert(firstIndexOfType + 1, extensions);
        }
        return this.append(extensions);
    }

    @SafeVarargs
    public final ExtensionList<E> insertBeforeOrPrepend(Class<? extends E> extensionType, E ... extensions) {
        int firstIndexOfType = this.firstIndexOfType(extensionType);
        return this.insert(firstIndexOfType >= 0 ? firstIndexOfType : 0, extensions);
    }

    public ExtensionList<E> drop(int index) {
        super.remove(index);
        return this;
    }

    public ExtensionList<E> drop(Class<? extends E> extensionType) {
        return this.drop(this.firstIndexOfTypeStrict(extensionType));
    }

    public ExtensionList<E> dropAll(Predicate<? super E> filter) {
        super.removeIf(filter);
        return this;
    }

    public ExtensionList<E> replace(int index, E replacement) {
        super.set(index, replacement);
        return this;
    }

    public ExtensionList<E> replace(Class<? extends E> extensionType, E replacement) {
        return this.replace(this.firstIndexOfTypeStrict(extensionType), replacement);
    }

    public ExtensionList<E> replaceOrAppend(Class<? extends E> extensionType, E replacement) {
        int firstIndexOfType = this.firstIndexOfType(extensionType);
        if (firstIndexOfType >= 0) {
            return this.replace(firstIndexOfType, replacement);
        }
        return this.append(replacement);
    }

    public ExtensionList<E> modify(Class<? extends E> extensionType, Consumer<E> modifier) {
        modifier.accept(this.get(this.firstIndexOfTypeStrict(extensionType)));
        return this;
    }

    private int firstIndexOfTypeStrict(Class<? extends E> extensionType) {
        int firstIndexOfType = this.firstIndexOfType(extensionType);
        if (firstIndexOfType < 0) {
            throw new ConfigurationException("Extension of type " + extensionType.getName() + " not found");
        }
        return firstIndexOfType;
    }

    private int firstIndexOfType(Class<? extends E> extensionType) {
        for (int i = 0; i < this.size(); ++i) {
            if (!extensionType.isInstance(this.get(i))) continue;
            return i;
        }
        return -1;
    }
}

