/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.generator.mapping.strategy;

import io.github.classgraph.ClassInfo;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.graphql.generator.BuildContext;
import io.leangen.graphql.generator.mapping.strategy.ImplementationDiscoveryStrategy;
import io.leangen.graphql.metadata.exceptions.TypeMappingException;
import io.leangen.graphql.util.ClassFinder;
import io.leangen.graphql.util.ClassUtils;
import io.leangen.graphql.util.Utils;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DefaultImplementationDiscoveryStrategy
implements ImplementationDiscoveryStrategy {
    private final List<Predicate<ClassInfo>> filters = new ArrayList<Predicate<ClassInfo>>();
    private final List<Class<?>> additionalImplementations;

    public DefaultImplementationDiscoveryStrategy() {
        this.filters.add(ClassFinder.PUBLIC);
        this.additionalImplementations = new ArrayList();
    }

    @Override
    public List<AnnotatedType> findImplementations(AnnotatedType type, boolean autoDiscover, String[] scanPackages, BuildContext buildContext) {
        if (Utils.isArrayEmpty(scanPackages) && Utils.isArrayNotEmpty(buildContext.basePackages)) {
            scanPackages = buildContext.basePackages;
        }
        Predicate<ClassInfo> filter = ClassFinder.NON_IGNORED.and(this.filters.stream().reduce(Predicate::and).orElse(ClassFinder.ALL));
        List<AnnotatedType> additionalImpls = this.additionalImplementationsOf(type);
        if (!autoDiscover) {
            return additionalImpls;
        }
        List<AnnotatedType> discoveredImpls = buildContext.classFinder.findImplementations(type, filter, false, scanPackages);
        HashSet seen = new HashSet(discoveredImpls.size() + additionalImpls.size());
        return Stream.concat(additionalImpls.stream(), discoveredImpls.stream()).filter(impl -> seen.add(GenericTypeReflector.erase((Type)impl.getType()))).collect(Collectors.toList());
    }

    public DefaultImplementationDiscoveryStrategy withNonPublicClasses() {
        this.filters.remove(ClassFinder.PUBLIC);
        return this;
    }

    @SafeVarargs
    public final DefaultImplementationDiscoveryStrategy withFilters(Predicate<ClassInfo> ... filters) {
        Collections.addAll(this.filters, filters);
        return this;
    }

    public DefaultImplementationDiscoveryStrategy withAdditionalImplementations(Class<?> ... additionalImplementations) {
        Collections.addAll(this.additionalImplementations, additionalImplementations);
        return this;
    }

    private List<AnnotatedType> additionalImplementationsOf(AnnotatedType type) {
        return this.additionalImplementations.stream().filter(impl -> ClassUtils.isSuperClass(type, impl)).map(impl -> {
            AnnotatedType implType = GenericTypeReflector.getExactSubType((AnnotatedType)type, (Class)impl);
            if (implType == null || ClassUtils.isMissingTypeParameters(implType.getType())) {
                throw new TypeMappingException(String.format("%s could not be resolved as a subtype of %s", impl.getName(), type.getType().getTypeName()));
            }
            return implType;
        }).collect(Collectors.toList());
    }
}

