/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.module.common.jackson;

import com.fasterxml.jackson.databind.node.BigIntegerNode;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DecimalNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.FloatNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import graphql.language.BooleanValue;
import graphql.language.FloatValue;
import graphql.language.IntValue;
import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.GraphQLScalarType;
import io.leangen.graphql.util.Scalars;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class JacksonScalars {
    public static final GraphQLScalarType JsonTextNode = new GraphQLScalarType("JsonText", "Text JSON node", new Coercing(){

        public Object serialize(Object dataFetcherResult) {
            if (dataFetcherResult instanceof String) {
                return dataFetcherResult;
            }
            if (dataFetcherResult instanceof TextNode) {
                return ((TextNode)dataFetcherResult).textValue();
            }
            throw Scalars.serializationException(dataFetcherResult, String.class, TextNode.class);
        }

        public Object parseValue(Object input) {
            if (input instanceof String) {
                return new TextNode((String)input);
            }
            if (input instanceof TextNode) {
                return input;
            }
            throw Scalars.valueParsingException(input, String.class, TextNode.class);
        }

        public Object parseLiteral(Object input) {
            return new TextNode(Scalars.literalOrException(input, StringValue.class).getValue());
        }
    });
    public static final GraphQLScalarType JsonBinaryNode = new GraphQLScalarType("JsonBase64Binary", "Base64-encoded binary JSON node", new Coercing(){
        private final Base64.Encoder encoder = Base64.getEncoder();
        private final Base64.Decoder decoder = Base64.getDecoder();

        public Object serialize(Object dataFetcherResult) {
            if (dataFetcherResult instanceof String) {
                return dataFetcherResult;
            }
            if (dataFetcherResult instanceof BinaryNode) {
                return this.encoder.encodeToString(((BinaryNode)dataFetcherResult).binaryValue());
            }
            throw Scalars.serializationException(dataFetcherResult, String.class, BinaryNode.class);
        }

        public Object parseValue(Object input) {
            if (input instanceof String) {
                return new BinaryNode(this.decoder.decode(input.toString()));
            }
            if (input instanceof BinaryNode) {
                return input;
            }
            throw Scalars.valueParsingException(input, String.class, BinaryNode.class);
        }

        public Object parseLiteral(Object input) {
            return new BinaryNode(this.decoder.decode(Scalars.literalOrException(input, StringValue.class).getValue()));
        }
    });
    public static final GraphQLScalarType JsonBooleanNode = new GraphQLScalarType("JsonBoolean", "Boolean JSON node", new Coercing(){

        public Object serialize(Object dataFetcherResult) {
            if (dataFetcherResult instanceof Boolean) {
                return dataFetcherResult;
            }
            if (dataFetcherResult instanceof BooleanNode) {
                return ((BooleanNode)dataFetcherResult).booleanValue();
            }
            throw Scalars.serializationException(dataFetcherResult, Boolean.class, BooleanNode.class);
        }

        public Object parseValue(Object input) {
            if (input instanceof Boolean) {
                return (Boolean)input != false ? BooleanNode.TRUE : Boolean.FALSE;
            }
            if (input instanceof BooleanNode) {
                return input;
            }
            throw Scalars.valueParsingException(input, Boolean.class, BooleanNode.class);
        }

        public Object parseLiteral(Object input) {
            return Scalars.literalOrException(input, BooleanValue.class).isValue();
        }
    });
    public static final GraphQLScalarType JsonDecimalNode = new GraphQLScalarType("JsonNumber", "Decimal JSON node", new Coercing(){

        public Object serialize(Object dataFetcherResult) {
            if (dataFetcherResult instanceof DecimalNode) {
                return ((DecimalNode)dataFetcherResult).numberValue();
            }
            throw Scalars.serializationException(dataFetcherResult, IntNode.class);
        }

        public Object parseValue(Object input) {
            if (input instanceof Number || input instanceof String) {
                return JsonNodeFactory.instance.numberNode(new BigDecimal(input.toString()));
            }
            if (input instanceof DecimalNode) {
                return input;
            }
            throw Scalars.valueParsingException(input, Number.class, String.class, DecimalNode.class);
        }

        public Object parseLiteral(Object input) {
            if (input instanceof IntValue) {
                return JsonNodeFactory.instance.numberNode(((IntValue)input).getValue());
            }
            if (input instanceof FloatValue) {
                return JsonNodeFactory.instance.numberNode(((FloatValue)input).getValue());
            }
            throw new CoercingParseLiteralException(Scalars.errorMessage(input, IntValue.class, FloatValue.class));
        }
    });
    public static final GraphQLScalarType JsonIntegerNode = new GraphQLScalarType("JsonInteger", "Integer JSON node", new Coercing(){

        public Object serialize(Object dataFetcherResult) {
            if (dataFetcherResult instanceof IntNode) {
                return ((IntNode)dataFetcherResult).numberValue();
            }
            throw Scalars.serializationException(dataFetcherResult, IntNode.class);
        }

        public Object parseValue(Object input) {
            if (input instanceof Number || input instanceof String) {
                try {
                    return new IntNode(new BigInteger(input.toString()).intValueExact());
                }
                catch (ArithmeticException e) {
                    throw new CoercingParseValueException(input + " does not fit into an int without a loss of precision");
                }
            }
            if (input instanceof IntNode) {
                return input;
            }
            throw Scalars.valueParsingException(input, Number.class, String.class, IntNode.class);
        }

        public Object parseLiteral(Object input) {
            if (input instanceof IntValue) {
                try {
                    return new IntNode(((IntValue)input).getValue().intValueExact());
                }
                catch (ArithmeticException e) {
                    throw new CoercingParseLiteralException(input + " does not fit into an int without a loss of precision");
                }
            }
            throw new CoercingParseLiteralException(Scalars.errorMessage(input, IntValue.class));
        }
    });
    public static final GraphQLScalarType JsonBigIntegerNode = new GraphQLScalarType("JsonBigInteger", "BigInteger JSON node", new Coercing(){

        public Object serialize(Object dataFetcherResult) {
            if (dataFetcherResult instanceof BigIntegerNode) {
                return ((BigIntegerNode)dataFetcherResult).numberValue();
            }
            throw Scalars.serializationException(dataFetcherResult, BigIntegerNode.class);
        }

        public Object parseValue(Object input) {
            if (input instanceof Number || input instanceof String) {
                return new BigIntegerNode(new BigInteger(input.toString()));
            }
            if (input instanceof BigIntegerNode) {
                return input;
            }
            throw Scalars.valueParsingException(input, Number.class, String.class, BigIntegerNode.class);
        }

        public Object parseLiteral(Object input) {
            if (input instanceof IntValue) {
                return new BigIntegerNode(((IntValue)input).getValue());
            }
            throw new CoercingParseLiteralException(Scalars.errorMessage(input, IntValue.class));
        }
    });
    public static final GraphQLScalarType JsonShortNode = new GraphQLScalarType("JsonShort", "Short JSON node", new Coercing(){

        public Object serialize(Object dataFetcherResult) {
            if (dataFetcherResult instanceof ShortNode) {
                return ((ShortNode)dataFetcherResult).numberValue();
            }
            throw Scalars.serializationException(dataFetcherResult, ShortNode.class);
        }

        public Object parseValue(Object input) {
            if (input instanceof Number || input instanceof String) {
                try {
                    return new ShortNode(new BigInteger(input.toString()).shortValueExact());
                }
                catch (ArithmeticException e) {
                    throw new CoercingParseValueException(input + " does not fit into a short without a loss of precision");
                }
            }
            if (input instanceof ShortNode) {
                return input;
            }
            throw Scalars.valueParsingException(input, Number.class, String.class, ShortNode.class);
        }

        public Object parseLiteral(Object input) {
            if (input instanceof IntValue) {
                try {
                    return new ShortNode(((IntValue)input).getValue().shortValueExact());
                }
                catch (ArithmeticException e) {
                    throw new CoercingParseLiteralException(input + " does not fit into a short without a loss of precision");
                }
            }
            throw new CoercingParseLiteralException(Scalars.errorMessage(input, IntValue.class));
        }
    });
    public static final GraphQLScalarType JsonFloatNode = new GraphQLScalarType("JsonFloat", "Float JSON node", new Coercing(){

        public Object serialize(Object dataFetcherResult) {
            if (dataFetcherResult instanceof FloatNode) {
                return ((FloatNode)dataFetcherResult).numberValue();
            }
            throw Scalars.serializationException(dataFetcherResult, FloatNode.class);
        }

        public Object parseValue(Object input) {
            if (input instanceof Number || input instanceof String) {
                return new FloatNode(new BigDecimal(input.toString()).floatValue());
            }
            if (input instanceof FloatNode) {
                return input;
            }
            throw Scalars.valueParsingException(input, Number.class, String.class, FloatNode.class);
        }

        public Object parseLiteral(Object input) {
            if (input instanceof IntValue) {
                return new FloatNode(((IntValue)input).getValue().floatValue());
            }
            if (input instanceof FloatValue) {
                return new FloatNode(((FloatValue)input).getValue().floatValue());
            }
            throw new CoercingParseLiteralException(Scalars.errorMessage(input, IntValue.class, FloatValue.class));
        }
    });
    public static final GraphQLScalarType JsonDoubleNode = new GraphQLScalarType("JsonDouble", "Double JSON node", new Coercing(){

        public Object serialize(Object dataFetcherResult) {
            if (dataFetcherResult instanceof DoubleNode) {
                return ((DoubleNode)dataFetcherResult).numberValue();
            }
            throw Scalars.serializationException(dataFetcherResult, DoubleNode.class);
        }

        public Object parseValue(Object input) {
            if (input instanceof Number || input instanceof String) {
                return new DoubleNode(new BigDecimal(input.toString()).doubleValue());
            }
            if (input instanceof DoubleNode) {
                return input;
            }
            throw Scalars.valueParsingException(input, Number.class, String.class, DoubleNode.class);
        }

        public Object parseLiteral(Object input) {
            if (input instanceof IntValue) {
                return new DoubleNode(((IntValue)input).getValue().doubleValue());
            }
            if (input instanceof FloatValue) {
                return new DoubleNode(((FloatValue)input).getValue().doubleValue());
            }
            throw new CoercingParseLiteralException(Scalars.errorMessage(input, IntValue.class, FloatValue.class));
        }
    });
    private static final Map<Type, GraphQLScalarType> SCALAR_MAPPING = JacksonScalars.getScalarMapping();

    public static boolean isScalar(Type javaType) {
        return SCALAR_MAPPING.containsKey(javaType);
    }

    public static GraphQLScalarType toGraphQLScalarType(Type javaType) {
        return SCALAR_MAPPING.get(javaType);
    }

    private static Map<Type, GraphQLScalarType> getScalarMapping() {
        HashMap<Class, GraphQLScalarType> scalarMapping = new HashMap<Class, GraphQLScalarType>();
        scalarMapping.put(TextNode.class, JsonTextNode);
        scalarMapping.put(BooleanNode.class, JsonBooleanNode);
        scalarMapping.put(BinaryNode.class, JsonBinaryNode);
        scalarMapping.put(BigIntegerNode.class, JsonBigIntegerNode);
        scalarMapping.put(IntNode.class, JsonIntegerNode);
        scalarMapping.put(ShortNode.class, JsonShortNode);
        scalarMapping.put(DecimalNode.class, JsonDecimalNode);
        scalarMapping.put(FloatNode.class, JsonFloatNode);
        scalarMapping.put(DoubleNode.class, JsonDoubleNode);
        scalarMapping.put(NumericNode.class, JsonDecimalNode);
        return Collections.unmodifiableMap(scalarMapping);
    }
}

