/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.RedisCredentials;
import io.lettuce.core.RedisCredentialsProvider;
import io.lettuce.core.internal.LettuceAssert;
import reactor.core.publisher.Mono;

public class StaticCredentialsProvider
implements RedisCredentialsProvider,
RedisCredentialsProvider.ImmediateRedisCredentialsProvider {
    private final RedisCredentials credentials;
    private final Mono<RedisCredentials> mono;

    public StaticCredentialsProvider(String username, char[] password) {
        this(RedisCredentials.just(username, password));
    }

    public StaticCredentialsProvider(RedisCredentials credentials) {
        LettuceAssert.notNull((Object)credentials, "RedisCredentials must not be null");
        this.credentials = RedisCredentials.just(credentials.getUsername(), credentials.getPassword());
        this.mono = Mono.just((Object)credentials);
    }

    @Override
    public Mono<RedisCredentials> resolveCredentials() {
        return this.mono;
    }

    @Override
    public RedisCredentials resolveCredentialsNow() {
        return this.credentials;
    }
}

