/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.search;

import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.codec.StringCodec;
import io.lettuce.core.output.ComplexData;
import io.lettuce.core.output.ComplexDataParser;
import io.lettuce.core.search.SpellCheckResult;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SpellCheckResultParser<K, V>
implements ComplexDataParser<SpellCheckResult<V>> {
    private static final InternalLogger LOG = InternalLoggerFactory.getInstance(SpellCheckResultParser.class);
    private final RedisCodec<K, V> codec;

    public SpellCheckResultParser(RedisCodec<K, V> codec) {
        this.codec = codec;
    }

    @Override
    public SpellCheckResult<V> parse(ComplexData data) {
        if (data == null) {
            return new SpellCheckResult();
        }
        if (data.isList()) {
            return new SpellCheckResp2Parser().parse(data);
        }
        return new SpellCheckResp3Parser().parse(data);
    }

    private V decodeValue(Object value) {
        if (value instanceof ByteBuffer) {
            return this.codec.decodeValue((ByteBuffer)value);
        }
        if (value instanceof String) {
            return (V)value;
        }
        return (V)value;
    }

    private double parseScore(Object scoreObj) {
        if (scoreObj == null) {
            return 0.0;
        }
        if (scoreObj instanceof Number) {
            return ((Number)scoreObj).doubleValue();
        }
        if (scoreObj instanceof String) {
            try {
                return Double.parseDouble((String)scoreObj);
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
        }
        if (scoreObj instanceof ByteBuffer) {
            try {
                String scoreStr = StringCodec.UTF8.decodeValue((ByteBuffer)scoreObj);
                return Double.parseDouble(scoreStr);
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
        }
        return 0.0;
    }

    class SpellCheckResp2Parser
    implements ComplexDataParser<SpellCheckResult<V>> {
        private final ByteBuffer termKeyword = StringCodec.UTF8.encodeKey("TERM");

        SpellCheckResp2Parser() {
        }

        @Override
        public SpellCheckResult<V> parse(ComplexData data) {
            SpellCheckResult<Object> result = new SpellCheckResult<Object>();
            List<Object> elements = data.getDynamicList();
            if (elements == null || elements.isEmpty()) {
                return result;
            }
            for (Object element : elements) {
                boolean isValidTermMarker;
                List<Object> termContents = ((ComplexData)element).getDynamicList();
                if (termContents == null || termContents.size() != 3) {
                    LOG.warn("Failed while parsing FT.SPELLCHECK: each term element must have 3 parts");
                    continue;
                }
                Object termMarker = termContents.get(0);
                boolean bl = isValidTermMarker = this.termKeyword.equals(termMarker) || "TERM".equals(termMarker);
                if (!isValidTermMarker) {
                    LOG.warn("Failed while parsing FT.SPELLCHECK: expected 'TERM' marker, got: " + termMarker);
                    continue;
                }
                Object misspelledTerm = SpellCheckResultParser.this.decodeValue(termContents.get(1));
                ComplexData suggestionsObj = (ComplexData)termContents.get(2);
                List<Object> suggestionsArray = suggestionsObj.getDynamicList();
                List suggestions = this.parseSuggestions(suggestionsArray);
                result.addMisspelledTerm(new SpellCheckResult.MisspelledTerm<Object>(misspelledTerm, suggestions));
            }
            return result;
        }

        private List<SpellCheckResult.Suggestion<V>> parseSuggestions(List<Object> suggestionsArray) {
            ArrayList suggestions = new ArrayList();
            for (Object suggestionObj : suggestionsArray) {
                List<Object> suggestionData = ((ComplexData)suggestionObj).getDynamicList();
                if (suggestionData.size() != 2) {
                    LOG.warn("Failed while parsing FT.SPELLCHECK: each suggestion must have 2 parts");
                    continue;
                }
                double score = SpellCheckResultParser.this.parseScore(suggestionData.get(0));
                Object suggestion = SpellCheckResultParser.this.decodeValue(suggestionData.get(1));
                suggestions.add(new SpellCheckResult.Suggestion<Object>(score, suggestion));
            }
            return suggestions;
        }
    }

    class SpellCheckResp3Parser
    implements ComplexDataParser<SpellCheckResult<V>> {
        private final ByteBuffer resultsKeyword = StringCodec.UTF8.encodeKey("results");

        SpellCheckResp3Parser() {
        }

        @Override
        public SpellCheckResult<V> parse(ComplexData data) {
            SpellCheckResult result = new SpellCheckResult();
            if (data == null) {
                return null;
            }
            Map<Object, Object> elements = data.getDynamicMap();
            if (elements == null || elements.isEmpty() || !elements.containsKey(this.resultsKeyword)) {
                LOG.warn("Failed while parsing FT.SPELLCHECK: data must contain a 'results' key");
                return result;
            }
            ComplexData resultsData = (ComplexData)elements.get(this.resultsKeyword);
            Map<Object, Object> resultsMap = resultsData.getDynamicMap();
            for (Object term : resultsMap.keySet()) {
                Object misspelledTerm = SpellCheckResultParser.this.codec.decodeValue((ByteBuffer)term);
                ComplexData termData = (ComplexData)resultsMap.get(term);
                List<Object> suggestionsArray = termData.getDynamicList();
                List suggestions = this.parseSuggestions(suggestionsArray);
                result.addMisspelledTerm(new SpellCheckResult.MisspelledTerm(misspelledTerm, suggestions));
            }
            return result;
        }

        private List<SpellCheckResult.Suggestion<V>> parseSuggestions(List<Object> suggestionsArray) {
            ArrayList suggestions = new ArrayList();
            for (Object suggestionObj : suggestionsArray) {
                Map<Object, Object> suggestionMap = ((ComplexData)suggestionObj).getDynamicMap();
                for (Object suggestion : suggestionMap.keySet()) {
                    double score = (Double)suggestionMap.get(suggestion);
                    Object suggestionValue = SpellCheckResultParser.this.codec.decodeValue((ByteBuffer)suggestion);
                    suggestions.add(new SpellCheckResult.Suggestion(score, suggestionValue));
                }
            }
            return suggestions;
        }
    }
}

