/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.json.DelegateJsonValue;
import io.lettuce.core.json.JsonArray;
import io.lettuce.core.json.JsonValue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class DelegateJsonArray
extends DelegateJsonValue
implements JsonArray {
    DelegateJsonArray(ObjectMapper objectMapper) {
        super((JsonNode)new ArrayNode(JsonNodeFactory.instance), objectMapper);
    }

    DelegateJsonArray(JsonNode node, ObjectMapper objectMapper) {
        super(node, objectMapper);
    }

    @Override
    public JsonArray add(JsonValue element) {
        JsonNode newNode = null;
        if (element != null) {
            newNode = ((DelegateJsonValue)element).getNode();
        }
        ((ArrayNode)this.node).add(newNode);
        return this;
    }

    @Override
    public void addAll(JsonArray element) {
        LettuceAssert.notNull((Object)element, "Element must not be null");
        ArrayNode otherArray = (ArrayNode)((DelegateJsonValue)((Object)element)).getNode();
        ((ArrayNode)this.node).addAll(otherArray);
    }

    @Override
    public List<JsonValue> asList() {
        ArrayList<JsonValue> result = new ArrayList<JsonValue>();
        for (JsonNode jsonNode : this.node) {
            result.add(DelegateJsonArray.wrap(jsonNode, this.objectMapper));
        }
        return result;
    }

    @Override
    public JsonValue get(int index) {
        JsonNode jsonNode = this.node.get(index);
        return jsonNode == null ? null : DelegateJsonArray.wrap(jsonNode, this.objectMapper);
    }

    @Override
    public JsonValue getFirst() {
        return this.get(0);
    }

    @Override
    public Iterator<JsonValue> iterator() {
        return this.asList().iterator();
    }

    @Override
    public JsonValue remove(int index) {
        JsonNode jsonNode = ((ArrayNode)this.node).remove(index);
        return DelegateJsonArray.wrap(jsonNode, this.objectMapper);
    }

    @Override
    public JsonValue replace(int index, JsonValue newElement) {
        JsonNode replaceWith = ((DelegateJsonValue)newElement).getNode();
        JsonNode replaced = ((ArrayNode)this.node).set(index, replaceWith);
        return DelegateJsonArray.wrap(replaced, this.objectMapper);
    }

    @Override
    public JsonArray swap(int index, JsonValue newElement) {
        JsonNode replaceWith = ((DelegateJsonValue)newElement).getNode();
        ((ArrayNode)this.node).set(index, replaceWith);
        return this;
    }

    @Override
    public int size() {
        return this.node.size();
    }

    @Override
    public JsonArray asJsonArray() {
        return this;
    }
}

