/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.m3u8.model;

import io.lindstrom.m3u8.model.RenditionReport;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;

class RenditionReportBuilder {
    private static final long INIT_BIT_URI = 1L;
    private long initBits = 1L;
    private String uri;
    private Long lastMediaSequenceNumber;
    private Long lastPartialSegmentIndex;

    RenditionReportBuilder() {
        if (!(this instanceof RenditionReport.Builder)) {
            throw new UnsupportedOperationException("Use: new RenditionReport.Builder()");
        }
    }

    public final RenditionReport.Builder from(RenditionReport instance) {
        Optional<Long> lastPartialSegmentIndexOptional;
        Objects.requireNonNull(instance, "instance");
        this.uri(instance.uri());
        Optional<Long> lastMediaSequenceNumberOptional = instance.lastMediaSequenceNumber();
        if (lastMediaSequenceNumberOptional.isPresent()) {
            this.lastMediaSequenceNumber(lastMediaSequenceNumberOptional);
        }
        if ((lastPartialSegmentIndexOptional = instance.lastPartialSegmentIndex()).isPresent()) {
            this.lastPartialSegmentIndex(lastPartialSegmentIndexOptional);
        }
        return (RenditionReport.Builder)this;
    }

    public final RenditionReport.Builder uri(String uri) {
        this.uri = Objects.requireNonNull(uri, "uri");
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return (RenditionReport.Builder)this;
    }

    public final RenditionReport.Builder lastMediaSequenceNumber(long lastMediaSequenceNumber) {
        this.lastMediaSequenceNumber = lastMediaSequenceNumber;
        return (RenditionReport.Builder)this;
    }

    public final RenditionReport.Builder lastMediaSequenceNumber(Optional<Long> lastMediaSequenceNumber) {
        this.lastMediaSequenceNumber = lastMediaSequenceNumber.orElse(null);
        return (RenditionReport.Builder)this;
    }

    public final RenditionReport.Builder lastPartialSegmentIndex(long lastPartialSegmentIndex) {
        this.lastPartialSegmentIndex = lastPartialSegmentIndex;
        return (RenditionReport.Builder)this;
    }

    public final RenditionReport.Builder lastPartialSegmentIndex(Optional<Long> lastPartialSegmentIndex) {
        this.lastPartialSegmentIndex = lastPartialSegmentIndex.orElse(null);
        return (RenditionReport.Builder)this;
    }

    public RenditionReport build() {
        if (this.initBits != 0L) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
        return new ImmutableRenditionReport(this);
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if ((this.initBits & 1L) != 0L) {
            attributes.add("uri");
        }
        return "Cannot build RenditionReport, some of required attributes are not set " + attributes;
    }

    private static final class ImmutableRenditionReport
    implements RenditionReport {
        private final String uri;
        private final Long lastMediaSequenceNumber;
        private final Long lastPartialSegmentIndex;

        private ImmutableRenditionReport(RenditionReportBuilder builder) {
            this.uri = builder.uri;
            this.lastMediaSequenceNumber = builder.lastMediaSequenceNumber;
            this.lastPartialSegmentIndex = builder.lastPartialSegmentIndex;
        }

        @Override
        public String uri() {
            return this.uri;
        }

        @Override
        public Optional<Long> lastMediaSequenceNumber() {
            return Optional.ofNullable(this.lastMediaSequenceNumber);
        }

        @Override
        public Optional<Long> lastPartialSegmentIndex() {
            return Optional.ofNullable(this.lastPartialSegmentIndex);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ImmutableRenditionReport && this.equalTo((ImmutableRenditionReport)another);
        }

        private boolean equalTo(ImmutableRenditionReport another) {
            return this.uri.equals(another.uri) && Objects.equals(this.lastMediaSequenceNumber, another.lastMediaSequenceNumber) && Objects.equals(this.lastPartialSegmentIndex, another.lastPartialSegmentIndex);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.uri.hashCode();
            h += (h << 5) + Objects.hashCode(this.lastMediaSequenceNumber);
            h += (h << 5) + Objects.hashCode(this.lastPartialSegmentIndex);
            return h;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("RenditionReport{");
            builder.append("uri=").append(this.uri);
            if (this.lastMediaSequenceNumber != null) {
                builder.append(", ");
                builder.append("lastMediaSequenceNumber=").append(this.lastMediaSequenceNumber);
            }
            if (this.lastPartialSegmentIndex != null) {
                builder.append(", ");
                builder.append("lastPartialSegmentIndex=").append(this.lastPartialSegmentIndex);
            }
            return builder.append("}").toString();
        }
    }
}

