/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.analytics.model.filter;

import io.meeds.analytics.model.filter.AnalyticsPeriod;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;
import java.time.Year;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAdjusters;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

public enum AnalyticsPeriodType {
    TODAY("today", "day"),
    THIS_WEEK("thisWeek", "week"),
    THIS_MONTH("thisMonth", "month"),
    THIS_QUARTER("thisQuarter", "quarter"),
    THIS_SEMESTER("thisSemester", "182d"),
    THIS_YEAR("thisYear", "year");

    private String typeName;
    private String interval;

    private AnalyticsPeriodType(String typeName, String interval) {
        this.typeName = typeName;
        this.interval = interval;
    }

    public AnalyticsPeriod getCurrentPeriod(LocalDate date, ZoneId timeZone) {
        if (timeZone == null) {
            timeZone = ZoneOffset.UTC;
        }
        LocalDate start = null;
        LocalDate end = null;
        switch (this.ordinal()) {
            case 0: {
                return new AnalyticsPeriod(date, date.plusDays(1L), this.interval, timeZone);
            }
            case 1: {
                start = date.with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY));
                end = start.plusDays(7L);
                return new AnalyticsPeriod(start, end, this.interval, timeZone);
            }
            case 2: {
                start = date.withDayOfMonth(1);
                end = start.plusMonths(1L);
                return new AnalyticsPeriod(start, end, this.interval, timeZone);
            }
            case 3: {
                start = Year.of(date.getYear()).atMonth(date.getMonth().firstMonthOfQuarter()).atDay(1);
                end = start.plusMonths(3L);
                return new AnalyticsPeriod(start, end, this.interval, timeZone);
            }
            case 4: {
                start = date.getMonth().compareTo(Month.JUNE) > 0 ? Year.of(date.getYear()).atMonth(Month.JULY).atDay(1) : Year.of(date.getYear()).atMonth(Month.JANUARY).atDay(1);
                end = start.plusMonths(6L);
                return new AnalyticsPeriod(start, end, this.interval, timeZone);
            }
            case 5: {
                start = date.withDayOfYear(1);
                end = start.plusYears(1L);
                return new AnalyticsPeriod(start, end, this.interval, timeZone);
            }
        }
        return null;
    }

    public long getOffset(long timestamp) {
        if (this == THIS_SEMESTER) {
            return timestamp / 86400000L % 182L;
        }
        return 0L;
    }

    public AnalyticsPeriod getPreviousPeriod(LocalDate date, ZoneId timeZone) {
        switch (this.ordinal()) {
            case 0: {
                return this.getCurrentPeriod(date.minusDays(1L), timeZone);
            }
            case 1: {
                return this.getCurrentPeriod(date.minusWeeks(1L), timeZone);
            }
            case 2: {
                return this.getCurrentPeriod(date.minusMonths(1L), timeZone);
            }
            case 3: {
                return this.getCurrentPeriod(date.minusMonths(3L), timeZone);
            }
            case 4: {
                AnalyticsPeriod currentPeriod = this.getCurrentPeriod(date, timeZone);
                return new AnalyticsPeriod(currentPeriod.getFrom().minusDays(182L), currentPeriod.getTo().minusDays(182L), this.interval);
            }
            case 5: {
                return this.getCurrentPeriod(date.minusYears(1L), timeZone);
            }
        }
        return null;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public static AnalyticsPeriodType periodTypeByName(String typeName) {
        return Arrays.stream(AnalyticsPeriodType.values()).filter(value -> StringUtils.equals((CharSequence)value.getTypeName(), (CharSequence)typeName)).findFirst().orElse(null);
    }

    public String getInterval() {
        return this.interval;
    }
}

