/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.analytics.model.chart;

import io.meeds.analytics.model.chart.ChartAggregationResult;
import io.meeds.analytics.model.chart.ChartAggregationValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ChartData
implements Serializable {
    private static final long serialVersionUID = 7951982952095482899L;
    private ChartAggregationValue key;
    private List<ChartAggregationResult> aggregationResults = new ArrayList<ChartAggregationResult>();
    private String lang;
    private String chartLabel;

    public String getChartKey() {
        return this.key == null || this.key.getAggregation() == null ? null : this.key.getAggregation().getField();
    }

    public void addAggregationResult(ChartAggregationResult aggregationResult, int index, boolean replaceIfExists) {
        int existingIndex = this.aggregationResults.indexOf(aggregationResult);
        if (existingIndex < 0) {
            if (index < 0 || index >= this.aggregationResults.size()) {
                this.aggregationResults.add(aggregationResult);
            } else {
                this.aggregationResults.add(index, aggregationResult);
            }
        } else if (replaceIfExists) {
            this.aggregationResults.remove(existingIndex);
            if (index < 0 || index >= this.aggregationResults.size()) {
                this.aggregationResults.add(aggregationResult);
            } else {
                this.aggregationResults.add(index, aggregationResult);
            }
        }
    }

    public String getChartValue() {
        return this.key == null ? null : this.key.getFieldValue();
    }

    public List<String> getValues() {
        return this.aggregationResults.stream().map(ChartAggregationResult::getValue).toList();
    }

    public ChartAggregationValue getKey() {
        return this.key;
    }

    public List<ChartAggregationResult> getAggregationResults() {
        return this.aggregationResults;
    }

    public String getLang() {
        return this.lang;
    }

    public String getChartLabel() {
        return this.chartLabel;
    }

    public void setKey(ChartAggregationValue key) {
        this.key = key;
    }

    public void setAggregationResults(List<ChartAggregationResult> aggregationResults) {
        this.aggregationResults = aggregationResults;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public void setChartLabel(String chartLabel) {
        this.chartLabel = chartLabel;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChartData)) {
            return false;
        }
        ChartData other = (ChartData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ChartAggregationValue this$key = this.getKey();
        ChartAggregationValue other$key = other.getKey();
        if (this$key == null ? other$key != null : !((Object)this$key).equals(other$key)) {
            return false;
        }
        List<ChartAggregationResult> this$aggregationResults = this.getAggregationResults();
        List<ChartAggregationResult> other$aggregationResults = other.getAggregationResults();
        if (this$aggregationResults == null ? other$aggregationResults != null : !((Object)this$aggregationResults).equals(other$aggregationResults)) {
            return false;
        }
        String this$lang = this.getLang();
        String other$lang = other.getLang();
        if (this$lang == null ? other$lang != null : !this$lang.equals(other$lang)) {
            return false;
        }
        String this$chartLabel = this.getChartLabel();
        String other$chartLabel = other.getChartLabel();
        return !(this$chartLabel == null ? other$chartLabel != null : !this$chartLabel.equals(other$chartLabel));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChartData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ChartAggregationValue $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : ((Object)$key).hashCode());
        List<ChartAggregationResult> $aggregationResults = this.getAggregationResults();
        result = result * 59 + ($aggregationResults == null ? 43 : ((Object)$aggregationResults).hashCode());
        String $lang = this.getLang();
        result = result * 59 + ($lang == null ? 43 : $lang.hashCode());
        String $chartLabel = this.getChartLabel();
        result = result * 59 + ($chartLabel == null ? 43 : $chartLabel.hashCode());
        return result;
    }

    public String toString() {
        return "ChartData(key=" + String.valueOf(this.getKey()) + ", aggregationResults=" + String.valueOf(this.getAggregationResults()) + ", lang=" + this.getLang() + ", chartLabel=" + this.getChartLabel() + ")";
    }

    public ChartData(ChartAggregationValue key, List<ChartAggregationResult> aggregationResults, String lang, String chartLabel) {
        this.key = key;
        this.aggregationResults = aggregationResults;
        this.lang = lang;
        this.chartLabel = chartLabel;
    }
}

