/**
 * This file is part of the Meeds project (https://meeds.io/).
 *
 * Copyright (C) 2020 - 2024 Meeds Association contact@meeds.io
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
const path = require('path');
const ESLintPlugin = require('eslint-webpack-plugin');
const { VueLoaderPlugin } = require('vue-loader')

const config = {
  context: path.resolve(__dirname, '.'),
  mode: 'production',
  module: {
    rules: [
      {
        test: /\.js$/,
        exclude: /node_modules/,
        use: [
          'babel-loader',
        ]
      },
      {
        test: /\.vue$/,
        use: [
          'vue-loader',
        ]
      }
    ]
  },
  entry: {
    commonAnalyticsVueComponents: './src/main/webapp/vue-app/common-components/main.js',
    analytics: './src/main/webapp/vue-app/generic-portlet/main.js',
    breadcrumb: './src/main/webapp/vue-app/breadcrumb-portlet/main.js',
    analyticsRate:'./src/main/webapp/vue-app/rate-portlet/main.js',
    analyticsTable:'./src/main/webapp/vue-app/table-portlet/main.js',
    spacesListWidget:'./src/main/webapp/vue-app/spaces-list-widget/main.js',
    spacesAdministrationExtension:'./src/main/webapp/vue-app/spaces-administration-extension/main.js',
    analyticsApi:'./src/main/webapp/vue-app/analytics-api/main.js',
    analyticsQuickActionExtensions: "./src/main/webapp/vue-app/quick-actions/extensions.js",
  },
  output: {
    path: path.join(__dirname, 'target/analytics/'),
    filename: 'js/[name].bundle.js',
    libraryTarget: 'amd'
  },
  plugins: [
    new ESLintPlugin({
      files: [
        './src/main/webapp/vue-app/*.js',
        './src/main/webapp/vue-app/*.vue',
        './src/main/webapp/vue-app/**/*.js',
        './src/main/webapp/vue-app/**/*.vue',
      ],
    }),
    new VueLoaderPlugin()
  ],
  externals: {
    vue: 'Vue',
    vuetify: 'Vuetify',
    jquery: '$',
  },
};

module.exports = config;
