/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.analytics.queue.service;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.meeds.analytics.api.service.StatisticDataProcessorService;
import io.meeds.analytics.api.service.StatisticDataQueueService;
import io.meeds.analytics.model.StatisticData;
import io.meeds.analytics.model.StatisticDataQueueEntry;
import io.meeds.analytics.queue.service.DummyStatisticDataQueueService$AjcClosure1;
import io.meeds.common.ContainerTransactional;
import io.meeds.common.ContainerTransactionalAspect;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Primary
@Service
public class DummyStatisticDataQueueService
implements StatisticDataQueueService {
    private static final Log LOG;
    private static final String ANALYTICS_QUEUE_CACHE_NAME = "analytics.queue";
    @Autowired
    private StatisticDataProcessorService statisticDataProcessorService;
    @Autowired
    private CacheService cacheService = null;
    private ExoCache<Long, StatisticDataQueueEntry> statisticQueueCache = null;
    private ScheduledExecutorService queueProcessingExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("Analytics-ingestor-%d").build());
    private BigInteger totalExecutionTime = BigInteger.ZERO;
    private long lastExecutionTime = 0L;
    private long executionCount = 0L;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @PostConstruct
    public void init() {
        this.statisticQueueCache = this.cacheService.getCacheInstance(ANALYTICS_QUEUE_CACHE_NAME);
        this.queueProcessingExecutor.scheduleAtFixedRate(this::processQueueTransactional, 0L, 10L, TimeUnit.SECONDS);
    }

    @PreDestroy
    public void shutdown() {
        this.queueProcessingExecutor.shutdown();
    }

    @ContainerTransactional
    public void processQueueTransactional() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        DummyStatisticDataQueueService$AjcClosure1 dummyStatisticDataQueueService$AjcClosure1 = new DummyStatisticDataQueueService$AjcClosure1(objectArray);
        ContainerTransactionalAspect.aspectOf().around(dummyStatisticDataQueueService$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processQueue() {
        ++this.executionCount;
        long startTime = System.currentTimeMillis();
        try {
            List queueEntries = this.statisticQueueCache.getCachedObjects();
            LOG.debug("Processing {} documents", new Object[]{queueEntries.size()});
            this.statisticDataProcessorService.process(queueEntries);
            for (StatisticDataQueueEntry statisticDataQueueEntry : queueEntries) {
                if (!statisticDataQueueEntry.isProcessed()) continue;
                this.statisticQueueCache.remove((Serializable)Long.valueOf(statisticDataQueueEntry.getId()));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while processing statistic documents from queue", (Throwable)e);
        }
        finally {
            this.lastExecutionTime = System.currentTimeMillis() - startTime;
            this.totalExecutionTime = this.totalExecutionTime.add(BigInteger.valueOf(this.lastExecutionTime));
        }
    }

    public void put(StatisticData data) {
        StatisticDataQueueEntry statisticDataQueueEntry = new StatisticDataQueueEntry(data);
        this.statisticQueueCache.put((Serializable)Long.valueOf(statisticDataQueueEntry.getId()), (Object)statisticDataQueueEntry);
    }

    public StatisticData get(long id) {
        StatisticDataQueueEntry statisticDataQueueEntry = (StatisticDataQueueEntry)this.statisticQueueCache.get((Serializable)Long.valueOf(id));
        return statisticDataQueueEntry == null ? null : statisticDataQueueEntry.getStatisticData();
    }

    public int queueSize() {
        return this.statisticQueueCache.getCacheSize();
    }

    public long getAverageExecutionTime() {
        if (this.executionCount < 2L) {
            return this.totalExecutionTime.longValue();
        }
        return this.totalExecutionTime.divide(BigInteger.valueOf(this.executionCount)).longValue();
    }

    public long getExecutionCount() {
        return this.executionCount;
    }

    public long getLastExecutionTime() {
        return this.lastExecutionTime;
    }

    static {
        DummyStatisticDataQueueService.ajc$preClinit();
        LOG = ExoLogger.getLogger(DummyStatisticDataQueueService.class);
    }

    static /* synthetic */ void processQueueTransactional_aroundBody0(DummyStatisticDataQueueService ajc$this, JoinPoint joinPoint) {
        ajc$this.processQueue();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DummyStatisticDataQueueService.java", DummyStatisticDataQueueService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "processQueueTransactional", "io.meeds.analytics.queue.service.DummyStatisticDataQueueService", "", "", "", "void"), 89);
    }
}

