/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.analytics.elasticsearch.service;

import io.meeds.analytics.api.service.AnalyticsService;
import io.meeds.analytics.elasticsearch.service.ElasticsearchAnalyticsService$AjcClosure1;
import io.meeds.analytics.elasticsearch.storage.ElasticsearchAnalyticsStorage;
import io.meeds.analytics.model.StatisticData;
import io.meeds.analytics.model.StatisticFieldMapping;
import io.meeds.analytics.model.StatisticFieldValue;
import io.meeds.analytics.model.StatisticWatcher;
import io.meeds.analytics.model.chart.ChartAggregationLabel;
import io.meeds.analytics.model.chart.ChartAggregationResult;
import io.meeds.analytics.model.chart.ChartAggregationValue;
import io.meeds.analytics.model.chart.ChartData;
import io.meeds.analytics.model.chart.ChartDataList;
import io.meeds.analytics.model.chart.PercentageChartResult;
import io.meeds.analytics.model.chart.PercentageChartValue;
import io.meeds.analytics.model.chart.TableColumnItemValue;
import io.meeds.analytics.model.chart.TableColumnResult;
import io.meeds.analytics.model.filter.AnalyticsFilter;
import io.meeds.analytics.model.filter.AnalyticsPercentageFilter;
import io.meeds.analytics.model.filter.AnalyticsPeriod;
import io.meeds.analytics.model.filter.AnalyticsPeriodType;
import io.meeds.analytics.model.filter.AnalyticsTableColumnFilter;
import io.meeds.analytics.model.filter.AnalyticsTableFilter;
import io.meeds.analytics.model.filter.aggregation.AnalyticsAggregation;
import io.meeds.analytics.model.filter.aggregation.AnalyticsAggregationType;
import io.meeds.analytics.model.filter.aggregation.AnalyticsPercentageLimit;
import io.meeds.analytics.model.filter.search.AnalyticsFieldFilter;
import io.meeds.analytics.utils.AnalyticsUtils;
import io.meeds.common.ContainerTransactional;
import io.meeds.common.ContainerTransactionalAspect;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ElasticsearchAnalyticsService
implements AnalyticsService {
    private static final String VALUE_PARAM = "value";
    private static final String SORT_DIRECTION_REQUEST_BODY_PARAM = "$sortDirection";
    private static final String SORT_FIELD_REQUEST_BODY_PARAM = "$sortField";
    private static final String SIZE_REQUEST_BODY_PARAM = "$size";
    private static final String MAX_BOUND_REQUEST_BODY_PARAM = "$maxBound";
    private static final String MIN_BOUND_REQUEST_BODY_PARAM = "$minBound";
    private static final String MAX_REQUEST_BODY_PARAM = "$max";
    private static final String MIN_REQUEST_BODY_PARAM = "$min";
    private static final String TIME_ZONE_ID_REQUEST_BODY_PARAM = "$timeZoneId";
    private static final String INTERVAL_OFFSET_REQUEST_BODY_PARAM = "$intervalOffset";
    private static final String INTERVAL_REQUEST_BODY_PARAM = "$interval";
    private static final String AGG_FIELD_NAME_REQUEST_BODY_PARAM = "$aggFieldName";
    private static final String AGG_NAME_REQUEST_BODY_PARAM = "$aggName";
    private static final String VALUE_REQUEST_BODY_PARAM = "$value";
    private static final String NAME_REQUEST_BODY_PARAM = "$name";
    private static final String BUCKETS_RESPONSE_BODY = "buckets";
    private static final String AGGREGATIONS_RESPONSE_BODY = "aggregations";
    private static final String ERROR_PARSING_RESULTS_MESSAGE = "Error parsing results with - filter: %s - query: %s  - response: %s";
    private static final String FILTER_AGGREGATIONS_IS_MANDATORY_MESSAGE = "Filter aggregations is mandatory";
    private static final String FILTER_IS_MANDATORY_MESSAGE = "Filter is mandatory";
    private static final Log LOG;
    private static final String AGGREGATION_KEYS_SEPARATOR = "-";
    private static final String AGGREGATION_RESULT_PARAM = "aggregation_result";
    private static final String AGGREGATION_RESULT_VALUE_PARAM = "aggregation_result_value";
    private static final String AGGREGATION_BUCKETS_VALUE_PARAM = "aggregation_buckets_value";
    private static final Context CONTEXT;
    private static final Scope ES_SCOPE;
    private static final String ES_AGGREGATED_MAPPING = "ES_AGGREGATED_MAPPING";
    @Autowired
    private ElasticsearchAnalyticsStorage elasticsearchStorage;
    @Autowired
    private SettingService settingService;
    private List<StatisticWatcher> uiWatchers = new ArrayList<StatisticWatcher>();
    private Map<String, StatisticFieldMapping> esMappings = new HashMap<String, StatisticFieldMapping>();
    private ScheduledExecutorService esMappingUpdater = Executors.newScheduledThreadPool(1);
    @Value(value="${analytics.aggregation.terms.doc_size:200}")
    private int aggregationReturnedDocumentsSize;
    @Value(value="${analytics.admin.permission:*:/platform/analytics}")
    List<String> administratorsPermissions;
    @Value(value="${analytics.viewall.permissions:*:/platform/administrators}")
    List<String> viewAllPermissions;
    @Value(value="${analytics.view.permission:*:/platform/users}")
    List<String> viewPermissions;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @PostConstruct
    public void start() {
        this.esMappingUpdater.scheduleAtFixedRate(() -> this.retrieveMapping(true), 1L, 2L, TimeUnit.MINUTES);
    }

    @PreDestroy
    public void stop() {
        this.esMappingUpdater.shutdown();
    }

    @ContainerTransactional
    public Set<StatisticFieldMapping> retrieveMapping(boolean forceRefresh) {
        boolean bl = forceRefresh;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        Object[] objectArray = new Object[]{this, Conversions.booleanObject((boolean)bl), joinPoint};
        ElasticsearchAnalyticsService$AjcClosure1 elasticsearchAnalyticsService$AjcClosure1 = new ElasticsearchAnalyticsService$AjcClosure1(objectArray);
        return (Set)ContainerTransactionalAspect.aspectOf().around(elasticsearchAnalyticsService$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public List<StatisticFieldValue> retrieveFieldValues(String field, int limit) {
        StatisticFieldMapping fieldMapping = this.getFieldMapping(field);
        if (fieldMapping == null || !fieldMapping.isAggregation()) {
            return Collections.emptyList();
        }
        String esQuery = this.buildAnalyticsQuery(Collections.singletonList(new AnalyticsAggregation(AnalyticsAggregationType.TERMS, fieldMapping.getAggregationFieldName(), "desc", null, (long)limit)), null, null, 0L, 0L);
        String jsonResponse = this.elasticsearchStorage.search(esQuery);
        try {
            return this.buildFieldValuesResponse(jsonResponse);
        }
        catch (JSONException e) {
            throw new IllegalStateException("Error parsing results for field: " + field + ", response: " + jsonResponse, e);
        }
    }

    public PercentageChartResult computePercentageChartData(AnalyticsPercentageFilter percentageFilter) {
        if (percentageFilter == null) {
            throw new IllegalArgumentException(FILTER_IS_MANDATORY_MESSAGE);
        }
        AnalyticsPeriod currentPeriod = percentageFilter.getCurrentAnalyticsPeriod();
        AnalyticsPeriod previousPeriod = percentageFilter.getPreviousAnalyticsPeriod();
        PercentageChartResult percentageChartResult = new PercentageChartResult();
        AnalyticsPercentageLimit percentageLimit = percentageFilter.getPercentageLimit();
        if (percentageLimit != null) {
            long previousPeriodLimit;
            this.computePercentageLimits(percentageFilter, percentageChartResult, currentPeriod, previousPeriod);
            long currentPeriodLimit = percentageFilter.getCurrentPeriodLimit();
            if (currentPeriodLimit > 0L) {
                this.computePercentageValuesPerPeriod(percentageChartResult, percentageFilter.computeValueFilter(currentPeriod, currentPeriodLimit), currentPeriod, null, true, true);
            }
            if ((previousPeriodLimit = percentageFilter.getPreviousPeriodLimit()) > 0L) {
                this.computePercentageValuesPerPeriod(percentageChartResult, percentageFilter.computeValueFilter(previousPeriod, previousPeriodLimit), null, previousPeriod, true, true);
            }
        } else {
            this.computePercentageValuesPerPeriod(percentageChartResult, percentageFilter.computeValueFilter(), currentPeriod, previousPeriod, true, false);
        }
        this.computePercentageValuesPerPeriod(percentageChartResult, percentageFilter.computeThresholdFilter(), currentPeriod, previousPeriod, false, false);
        return percentageChartResult;
    }

    public TableColumnResult computeTableColumnData(TableColumnResult columnResult, AnalyticsTableFilter tableFilter, AnalyticsFilter filter, AnalyticsPeriod period, AnalyticsPeriodType periodType, int columnIndex, boolean isValue) {
        if (filter == null) {
            throw new IllegalArgumentException(FILTER_IS_MANDATORY_MESSAGE);
        }
        if (filter.getAggregations() == null || filter.getAggregations().isEmpty()) {
            throw new IllegalArgumentException(FILTER_AGGREGATIONS_IS_MANDATORY_MESSAGE);
        }
        String esQueryString = this.buildAnalyticsQuery(filter.getAggregations(), filter.getFilters(), filter.zoneId(), filter.getOffset(), filter.getLimit());
        String jsonResponse = this.elasticsearchStorage.search(esQueryString);
        try {
            return this.buildTableColumnDataFromESResponse(columnResult, tableFilter, period, periodType, columnIndex, isValue, jsonResponse, filter.getLimit());
        }
        catch (JSONException e) {
            throw new IllegalStateException(String.format(ERROR_PARSING_RESULTS_MESSAGE, filter, esQueryString, jsonResponse), e);
        }
    }

    public ChartDataList computeChartData(AnalyticsFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException(FILTER_IS_MANDATORY_MESSAGE);
        }
        if (filter.getAggregations() == null || filter.getAggregations().isEmpty()) {
            throw new IllegalArgumentException(FILTER_AGGREGATIONS_IS_MANDATORY_MESSAGE);
        }
        String esQueryString = this.buildAnalyticsQuery(filter.getAggregations(), filter.getFilters(), filter.zoneId(), filter.getOffset(), filter.getLimit());
        String jsonResponse = this.elasticsearchStorage.search(esQueryString);
        try {
            return this.buildChartDataFromESResponse(filter, jsonResponse);
        }
        catch (JSONException e) {
            throw new IllegalStateException(String.format(ERROR_PARSING_RESULTS_MESSAGE, filter, esQueryString, jsonResponse), e);
        }
    }

    public PercentageChartValue computePercentageChartData(AnalyticsFilter filter, AnalyticsPeriod currentPeriod, AnalyticsPeriod previousPeriod, boolean hasLimitAggregation) {
        if (filter == null) {
            throw new IllegalArgumentException(FILTER_IS_MANDATORY_MESSAGE);
        }
        if (filter.getAggregations() == null || filter.getAggregations().isEmpty()) {
            throw new IllegalArgumentException(FILTER_AGGREGATIONS_IS_MANDATORY_MESSAGE);
        }
        AnalyticsAggregation yAxisAggregation = filter.getYAxisAggregation();
        AnalyticsAggregationType aggregationType = yAxisAggregation == null ? AnalyticsAggregationType.COUNT : yAxisAggregation.getType();
        String esQueryString = this.buildAnalyticsQuery(filter.getAggregations(), filter.getFilters(), aggregationType, hasLimitAggregation, filter.zoneId(), filter.getOffset(), filter.getLimit());
        String jsonResponse = this.elasticsearchStorage.search(esQueryString);
        try {
            return this.buildPercentageChartValuesFromESResponse(jsonResponse, currentPeriod, previousPeriod);
        }
        catch (JSONException e) {
            throw new IllegalStateException(String.format(ERROR_PARSING_RESULTS_MESSAGE, filter, esQueryString, jsonResponse), e);
        }
    }

    public List<StatisticData> retrieveData(AnalyticsFilter filter) {
        List filters = filter == null ? Collections.emptyList() : filter.getFilters();
        long offset = filter == null ? 0L : filter.getOffset();
        long limit = filter == null ? 10L : filter.getLimit();
        ZoneId timeZone = filter == null ? null : filter.zoneId();
        String esQueryString = this.buildAnalyticsQuery(null, filters, timeZone, offset, limit);
        String jsonResponse = this.elasticsearchStorage.search(esQueryString);
        try {
            return this.buildSearchResultFromESResponse(jsonResponse);
        }
        catch (JSONException e) {
            throw new IllegalStateException("Error parsing results with filter: " + String.valueOf(filter) + ", response: " + jsonResponse, e);
        }
    }

    public List<StatisticWatcher> getUIWatchers() {
        return this.uiWatchers;
    }

    public StatisticWatcher getUIWatcher(String name) {
        return this.uiWatchers.stream().filter(watcher -> StringUtils.equals((CharSequence)name, (CharSequence)watcher.getName())).findFirst().orElse(null);
    }

    public void addUIWatcher(StatisticWatcher uiWatcher) {
        this.uiWatchers.add(uiWatcher);
    }

    public List<StatisticData> getSamples(List<String> operations, String fieldName, List<String> fieldValues, String sortBy, String sortDirection, int limit) {
        AnalyticsFilter searchFilter = new AnalyticsFilter();
        ArrayList filters = new ArrayList();
        searchFilter.setFilters(filters);
        if (CollectionUtils.isNotEmpty(operations)) {
            searchFilter.addInSetFilter("operation", operations.toArray(new String[operations.size()]));
        }
        if (StringUtils.isNotEmpty((CharSequence)fieldName) && CollectionUtils.isNotEmpty(fieldValues)) {
            searchFilter.addInSetFilter(fieldName, fieldValues.toArray(new String[fieldValues.size()]));
        }
        searchFilter.addXAxisAggregation(new AnalyticsAggregation(AnalyticsAggregationType.TERMS, sortBy, sortDirection, null, (long)limit));
        searchFilter.setLimit((long)limit);
        return this.retrieveData(searchFilter);
    }

    public ChartDataList getChart(List<String> operations, String fieldName, List<String> fieldValues, String xAggregationField, AnalyticsAggregationType xAggregationType, String xAggregationSortDirection, String yAggregationField, AnalyticsAggregationType yAggregationType, String yAggregationSortDirection, int limit) {
        AnalyticsFilter searchFilter = new AnalyticsFilter();
        searchFilter.setFilters(new ArrayList());
        if (CollectionUtils.isNotEmpty(operations)) {
            searchFilter.addInSetFilter("operation", operations.toArray(new String[operations.size()]));
        }
        if (StringUtils.isNotEmpty((CharSequence)fieldName) && CollectionUtils.isNotEmpty(fieldValues)) {
            searchFilter.addInSetFilter(fieldName, fieldValues.toArray(new String[fieldValues.size()]));
        }
        searchFilter.addXAxisAggregation(new AnalyticsAggregation(xAggregationType, xAggregationField, xAggregationSortDirection, null, (long)limit));
        searchFilter.setYAxisAggregation(new AnalyticsAggregation(yAggregationType, yAggregationField, yAggregationSortDirection, null, 1L));
        searchFilter.setHideLabel(true);
        return this.computeChartData(searchFilter);
    }

    private List<StatisticFieldValue> buildFieldValuesResponse(String jsonResponse) throws JSONException {
        JSONArray buckets;
        JSONObject result;
        JSONObject aggregations;
        JSONObject json = new JSONObject(jsonResponse);
        JSONObject jSONObject = aggregations = json.has(AGGREGATIONS_RESPONSE_BODY) ? json.getJSONObject(AGGREGATIONS_RESPONSE_BODY) : null;
        if (aggregations == null) {
            return Collections.emptyList();
        }
        JSONObject jSONObject2 = result = aggregations.has(AGGREGATION_RESULT_PARAM) ? aggregations.getJSONObject(AGGREGATION_RESULT_PARAM) : null;
        if (result == null) {
            return Collections.emptyList();
        }
        JSONArray jSONArray = buckets = result.has(BUCKETS_RESPONSE_BODY) ? result.getJSONArray(BUCKETS_RESPONSE_BODY) : null;
        if (buckets == null) {
            return Collections.emptyList();
        }
        ArrayList<StatisticFieldValue> results = new ArrayList<StatisticFieldValue>();
        for (int i = 0; i < buckets.length(); ++i) {
            JSONObject bucket = buckets.getJSONObject(i);
            String value = this.getResultKeyAsString(bucket);
            long count = bucket.getLong("doc_count");
            results.add(new StatisticFieldValue(value, count));
        }
        return results;
    }

    private void addESDateSubField(String dateFieldName) {
        StatisticFieldMapping fieldMapping = new StatisticFieldMapping("doc['timestamp'].value." + dateFieldName, "long", false, true);
        this.esMappings.put(fieldMapping.getName(), fieldMapping);
    }

    private String buildAnalyticsQuery(List<AnalyticsAggregation> aggregations, List<AnalyticsFieldFilter> filters, ZoneId timeZone, long offset, long limit) {
        return this.buildAnalyticsQuery(aggregations, filters, null, false, timeZone, offset, limit);
    }

    private String buildAnalyticsQuery(List<AnalyticsAggregation> aggregations, List<AnalyticsFieldFilter> filters, AnalyticsAggregationType aggregationType, boolean hasLimitAggregation, ZoneId timeZone, long offset, long limit) {
        boolean isCount = aggregations != null;
        StringBuilder esQuery = new StringBuilder();
        esQuery.append("{");
        this.buildSearchFilterQuery(esQuery, filters, offset, limit, isCount);
        if (isCount) {
            this.buildAggregationQuery(esQuery, aggregations, aggregationType, timeZone, hasLimitAggregation);
        }
        esQuery.append("}");
        String esQueryString = esQuery.toString();
        esQueryString = AnalyticsUtils.fixJSONStringFormat((String)esQueryString);
        LOG.debug("ES query to compute chart data with aggregations :{}, filters :{} . Query: {}", new Object[]{aggregations, filters, esQueryString});
        return esQueryString;
    }

    private void buildSearchFilterQuery(StringBuilder esQuery, List<AnalyticsFieldFilter> filters, long offset, long limit, boolean isCount) {
        if (isCount) {
            esQuery.append("     \"size\" : 0");
        } else {
            if (offset > 0L) {
                esQuery.append("     \"from\" : ").append(offset).append(",");
            }
            if (limit <= 0L || limit > Integer.MAX_VALUE) {
                limit = 10000L;
            }
            esQuery.append("     \"size\" : ").append(limit).append(",");
            esQuery.append("     \"sort\" : [{ \"timestamp\":{\"order\" : \"desc\"}}]");
        }
        this.appendSearchFilterConditions(filters, esQuery);
    }

    private void appendSearchFilterConditions(List<AnalyticsFieldFilter> filters, StringBuilder esQuery) {
        filters = filters == null ? new ArrayList<AnalyticsFieldFilter>() : new ArrayList<AnalyticsFieldFilter>(filters);
        esQuery.append(",\n\"query\": {\n  \"bool\" : {\n    \"must\" : [\n");
        for (AnalyticsFieldFilter fieldFilter : filters) {
            String esFieldName = fieldFilter.getField();
            StatisticFieldMapping fieldMapping = this.esMappings.get(esFieldName);
            if (fieldMapping != null) {
                esFieldName = fieldMapping.getAggregationFieldName();
            }
            String esQueryValue = fieldMapping == null ? StatisticFieldMapping.computeESQueryValue((String)fieldFilter.getValueString()) : fieldMapping.getESQueryValue(fieldFilter.getValueString());
            switch (fieldFilter.getType()) {
                case NOT_NULL: {
                    esQuery.append("{\"exists\" : {\"field\": \"$name\"}},\n".replace(NAME_REQUEST_BODY_PARAM, esFieldName));
                    break;
                }
                case IS_NULL: {
                    esQuery.append("{\"bool\" : {\"must_not\": {\"exists\": {\"field\": \"$name\"}}}},\n".replace(NAME_REQUEST_BODY_PARAM, esFieldName));
                    break;
                }
                case EQUAL: {
                    esQuery.append("{\"match\" : {\"$name\": $value}},\n".replace(NAME_REQUEST_BODY_PARAM, esFieldName).replace(VALUE_REQUEST_BODY_PARAM, esQueryValue));
                    break;
                }
                case NOT_EQUAL: {
                    esQuery.append("{\"bool\": {\"must_not\": {\"match\" : {\"$name\": $value}}}},\n".replace(NAME_REQUEST_BODY_PARAM, esFieldName).replace(VALUE_REQUEST_BODY_PARAM, esQueryValue));
                    break;
                }
                case GREATER: {
                    esQuery.append("{\"range\": {\"$name\": {\"gte\": $value}}},\n".replace(NAME_REQUEST_BODY_PARAM, esFieldName).replace(VALUE_REQUEST_BODY_PARAM, esQueryValue));
                    break;
                }
                case LESS: {
                    esQuery.append("{\"range\": {\"$name\": {\"lte\": $value}}},\n".replace(NAME_REQUEST_BODY_PARAM, esFieldName).replace(VALUE_REQUEST_BODY_PARAM, esQueryValue));
                    break;
                }
                case RANGE: {
                    AnalyticsFilter.Range range = fieldFilter.getRange();
                    esQuery.append("{\"range\": {\n  \"$name\": {\n    \"gte\": $min,\n    \"lte\": $max\n  }\n}},\n".replace(NAME_REQUEST_BODY_PARAM, esFieldName).replace(MIN_REQUEST_BODY_PARAM, range.getMin()).replace(MAX_REQUEST_BODY_PARAM, range.getMax()));
                    break;
                }
                case IN_SET: {
                    esQuery.append("{\"terms\": {\"$name\": $value}},\n".replace(NAME_REQUEST_BODY_PARAM, esFieldName).replace(VALUE_REQUEST_BODY_PARAM, AnalyticsUtils.collectionToJSONString((String)fieldFilter.getValueString())));
                    break;
                }
                case NOT_IN_SET: {
                    esQuery.append("{\"bool\": {\"must_not\": {\"terms\": {\"$name\": $value}}}},\n".replace(NAME_REQUEST_BODY_PARAM, esFieldName).replace(VALUE_REQUEST_BODY_PARAM, AnalyticsUtils.collectionToJSONString((String)fieldFilter.getValueString())));
                    break;
                }
            }
        }
        esQuery.append("        ],\n      },\n    },\n");
    }

    private void buildAggregationQuery(StringBuilder esQuery, List<AnalyticsAggregation> aggregations, AnalyticsAggregationType percentageAggregationType, ZoneId timeZone, boolean hasLimitAggregation) {
        if (aggregations != null && !aggregations.isEmpty()) {
            StringBuffer endOfQuery = new StringBuffer();
            int aggregationsSize = aggregations.size();
            for (int i = 0; i < aggregationsSize; ++i) {
                AnalyticsAggregation aggregation = aggregations.get(i);
                AnalyticsAggregationType aggregationType = aggregation.getType();
                if (aggregationType.isUseInterval() && StringUtils.isBlank((CharSequence)aggregation.getInterval())) {
                    throw new IllegalStateException("Analytics aggregation type '" + String.valueOf(aggregationType) + "' is using intervals while it has empty interval");
                }
                String fieldName = this.getAggregationFieldName(aggregationType);
                long limit = aggregation.getLimit();
                if (aggregationType.isUseLimit() && limit <= 0L) {
                    limit = this.aggregationReturnedDocumentsSize;
                }
                String aggregationFieldName = aggregation.getField();
                StatisticFieldMapping aggregationField = this.getFieldMapping(aggregationFieldName);
                this.appendStartAggregationFieldQuery(esQuery, aggregationType, fieldName);
                this.appendAggregationNameQuery(esQuery, aggregationFieldName, aggregationField);
                this.appendIntervalQuery(esQuery, timeZone, aggregation, aggregationType, aggregationFieldName);
                this.appendLimitQuery(esQuery, aggregationType, limit);
                this.appendSortQuery(esQuery, aggregations, aggregationsSize, i, aggregation, aggregationType);
                this.appendEndAggregationFieldQuery(esQuery);
                this.appendEndOfAggregations(endOfQuery, percentageAggregationType, hasLimitAggregation, aggregationsSize, i);
            }
            esQuery.append(endOfQuery);
        }
    }

    private void appendStartAggregationFieldQuery(StringBuilder esQuery, AnalyticsAggregationType aggregationType, String fieldName) {
        esQuery.append(",\n \"aggs\": {\n   \"$name\": {\n     \"$aggName\": {\n\n".replace(NAME_REQUEST_BODY_PARAM, fieldName).replace(AGG_NAME_REQUEST_BODY_PARAM, aggregationType.getAggName()));
    }

    private void appendAggregationNameQuery(StringBuilder esQuery, String aggregationFieldName, StatisticFieldMapping aggregationField) {
        if (aggregationField == null || !aggregationField.isScriptedField()) {
            esQuery.append("          \"field\": \"$aggFieldName\"\n".replace(AGG_FIELD_NAME_REQUEST_BODY_PARAM, aggregationFieldName));
        } else {
            esQuery.append("         \"script\": {\n           \"lang\": \"painless\",\n           \"source\": \"$aggFieldName\"\n         }\n".replace(AGG_FIELD_NAME_REQUEST_BODY_PARAM, aggregationFieldName));
        }
    }

    private void appendIntervalQuery(StringBuilder esQuery, ZoneId timeZone, AnalyticsAggregation aggregation, AnalyticsAggregationType aggregationType, String aggregationFieldName) {
        if (aggregationType.isUseInterval()) {
            this.appendIntervalTypeQuery(esQuery, aggregation);
            this.appendIntervalOffsetQuery(esQuery, aggregation);
            this.appendIntervalTimeZoneQuery(esQuery, timeZone, aggregationFieldName);
            this.appendIntervalBoundQuery(esQuery, aggregation);
        }
    }

    private void appendIntervalTypeQuery(StringBuilder esQuery, AnalyticsAggregation aggregation) {
        if (AnalyticsAggregation.ALL_INTERVALS.contains(aggregation.getInterval())) {
            esQuery.append("        ,\n        \"calendar_interval\": \"$interval\"\n".replace(INTERVAL_REQUEST_BODY_PARAM, aggregation.getInterval()));
        } else {
            esQuery.append("        ,\n        \"fixed_interval\": \"$interval\"\n".replace(INTERVAL_REQUEST_BODY_PARAM, aggregation.getInterval()));
        }
    }

    private void appendIntervalOffsetQuery(StringBuilder esQuery, AnalyticsAggregation aggregation) {
        if (aggregation.getOffset() != null) {
            esQuery.append("       ,\n        \"offset\": \"$intervalOffset\"\n".replace(INTERVAL_OFFSET_REQUEST_BODY_PARAM, aggregation.getOffset()));
        }
    }

    private void appendIntervalTimeZoneQuery(StringBuilder esQuery, ZoneId timeZone, String aggregationFieldName) {
        if (timeZone != null && !ZoneOffset.UTC.equals(timeZone) && aggregationFieldName.equals("timestamp")) {
            esQuery.append("       ,\n        \"time_zone\": \"$timeZoneId\"\n".replace(TIME_ZONE_ID_REQUEST_BODY_PARAM, timeZone.getId()));
        }
    }

    private void appendIntervalBoundQuery(StringBuilder esQuery, AnalyticsAggregation aggregation) {
        if (aggregation.isUseBounds()) {
            esQuery.append("        ,\n        \"min_doc_count\": 0,\n        \"extended_bounds\": {\n           \"min\": $minBound,\n           \"max\": $maxBound\n        }\n".replace(MIN_BOUND_REQUEST_BODY_PARAM, String.valueOf(aggregation.getMinBound())).replace(MAX_BOUND_REQUEST_BODY_PARAM, String.valueOf(aggregation.getMaxBound())));
        }
    }

    private void appendLimitQuery(StringBuilder esQuery, AnalyticsAggregationType aggregationType, long limit) {
        if (aggregationType.isUseLimit() && limit > 0L) {
            esQuery.append("         ,\n          \"size\": $size\n".replace(SIZE_REQUEST_BODY_PARAM, String.valueOf(limit)));
        }
    }

    private void appendSortQuery(StringBuilder esQuery, List<AnalyticsAggregation> aggregations, int aggregationsSize, int i, AnalyticsAggregation aggregation, AnalyticsAggregationType aggregationType) {
        if (aggregationType.isUseSort()) {
            String sortField = null;
            String sortDirection = aggregation.getSortDirection();
            if (i + 1 < aggregationsSize) {
                AnalyticsAggregation nextAggregation = aggregations.get(i + 1);
                sortField = this.getSortField(nextAggregation);
                if (nextAggregation != null) {
                    sortDirection = nextAggregation.getSortDirection();
                }
            } else if (aggregationType == AnalyticsAggregationType.TERMS) {
                sortField = "_count";
            }
            if (sortField != null) {
                esQuery.append("         ,\n          \"order\": {\"$sortField\": \"$sortDirection\"}\n".replace(SORT_FIELD_REQUEST_BODY_PARAM, sortField).replace(SORT_DIRECTION_REQUEST_BODY_PARAM, sortDirection));
            }
        }
    }

    private void appendEndAggregationFieldQuery(StringBuilder esQuery) {
        esQuery.append("         }\n");
    }

    private void appendEndOfAggregations(StringBuffer endOfQuery, AnalyticsAggregationType percentageAggregationType, boolean hasLimitAggregation, int aggregationsSize, int i) {
        endOfQuery.append("         }\n");
        if (hasLimitAggregation && percentageAggregationType != null) {
            if (i != aggregationsSize - 1) {
                endOfQuery.append("     }");
            }
            if (i == aggregationsSize - 2) {
                endOfQuery.append("},\n\"aggregation_buckets_value\": {\n  \"$bucketAggregationType\": {\"buckets_path\": \"aggregation_result>aggregation_result_value.value\"}\n}\n".replace("$bucketAggregationType", this.getBucketAggregationType(percentageAggregationType)));
            }
        } else {
            endOfQuery.append("     }");
        }
    }

    private String getAggregationFieldName(AnalyticsAggregationType aggregationType) {
        String fieldName = null;
        fieldName = AnalyticsAggregationType.TERMS == aggregationType || AnalyticsAggregationType.DATE == aggregationType || AnalyticsAggregationType.HISTOGRAM == aggregationType ? AGGREGATION_RESULT_PARAM : AGGREGATION_RESULT_VALUE_PARAM;
        return fieldName;
    }

    private String getSortField(AnalyticsAggregation nextAggregation) {
        if (nextAggregation == null) {
            return null;
        }
        if (nextAggregation.getType().isNumericResult()) {
            return this.getAggregationFieldName(nextAggregation.getType()) + ".value";
        }
        return "_count";
    }

    private void computePercentageLimits(AnalyticsPercentageFilter percentageFilter, PercentageChartResult percentageChartResult, AnalyticsPeriod currentPeriod, AnalyticsPeriod previousPeriod) {
        AnalyticsPercentageLimit percentageLimit = percentageFilter.getPercentageLimit();
        PercentageChartValue chartValue = this.computePercentageChartData(percentageFilter.computeLimitFilter(), currentPeriod, previousPeriod, false);
        double currentPeriodLimit = chartValue.getCurrentPeriodValue();
        double previousPeriodLimit = chartValue.getPreviousPeriodValue();
        percentageChartResult.setCurrentPeriodLimit(currentPeriodLimit);
        percentageChartResult.setPreviousPeriodLimit(previousPeriodLimit);
        percentageFilter.setCurrentPeriodLimit(Math.round(currentPeriodLimit * percentageLimit.getPercentage() / 100.0));
        percentageFilter.setPreviousPeriodLimit(Math.round(previousPeriodLimit * percentageLimit.getPercentage() / 100.0));
    }

    private void computePercentageValuesPerPeriod(PercentageChartResult percentageResult, AnalyticsFilter analyticsFilter, AnalyticsPeriod currentPeriod, AnalyticsPeriod previousPeriod, boolean isValue, boolean hasLimitAggregation) {
        PercentageChartValue chartValue = this.computePercentageChartData(analyticsFilter, currentPeriod, previousPeriod, hasLimitAggregation);
        if (isValue) {
            if (chartValue.getCurrentPeriodValue() > 0.0) {
                percentageResult.setCurrentPeriodValue(chartValue.getCurrentPeriodValue());
            }
            if (chartValue.getPreviousPeriodValue() > 0.0) {
                percentageResult.setPreviousPeriodValue(chartValue.getPreviousPeriodValue());
            }
        } else {
            percentageResult.setCurrentPeriodThreshold(chartValue.getCurrentPeriodValue());
            percentageResult.setPreviousPeriodThreshold(chartValue.getPreviousPeriodValue());
        }
        percentageResult.setComputingTime(percentageResult.getComputingTime() + chartValue.getComputingTime());
        percentageResult.setDataCount(percentageResult.getDataCount() + chartValue.getDataCount());
    }

    private TableColumnResult buildTableColumnDataFromESResponse(TableColumnResult tableColumnResult, AnalyticsTableFilter tableFilter, AnalyticsPeriod period, AnalyticsPeriodType periodType, int columnIndex, boolean isValue, String jsonResponse, long limit) throws JSONException {
        JSONArray buckets;
        JSONObject result;
        JSONObject json;
        JSONObject aggregations;
        if (tableColumnResult == null) {
            tableColumnResult = new TableColumnResult();
        }
        JSONObject jSONObject = aggregations = (json = new JSONObject(jsonResponse)).has(AGGREGATIONS_RESPONSE_BODY) ? json.getJSONObject(AGGREGATIONS_RESPONSE_BODY) : null;
        if (aggregations == null) {
            return tableColumnResult;
        }
        JSONObject jSONObject2 = result = aggregations.has(AGGREGATION_RESULT_PARAM) ? aggregations.getJSONObject(AGGREGATION_RESULT_PARAM) : null;
        if (result == null) {
            return tableColumnResult;
        }
        JSONArray jSONArray = buckets = result.has(BUCKETS_RESPONSE_BODY) ? result.getJSONArray(BUCKETS_RESPONSE_BODY) : null;
        if (buckets == null) {
            return tableColumnResult;
        }
        AnalyticsTableColumnFilter columnFilter = tableFilter.getColumnFilter(columnIndex);
        LinkedHashMap<String, TableColumnItemValue> itemValues = new LinkedHashMap<String, TableColumnItemValue>();
        tableColumnResult.getItems().forEach(item -> itemValues.put(item.getKey(), (TableColumnItemValue)item));
        if (columnFilter.isPreviousPeriod()) {
            AnalyticsPeriod currentPeriod = tableFilter.getCurrentPeriod(period, periodType);
            AnalyticsPeriod previousPeriod = tableFilter.getPreviousPeriod(period, periodType);
            for (int i = buckets.length() - 1; i >= 0; --i) {
                JSONObject bucket = buckets.getJSONObject(i);
                long timestamp = bucket.getLong("key");
                boolean isCurrent = currentPeriod.isInPeriod(timestamp);
                if (!isCurrent && !previousPeriod.isInPeriod(timestamp) || !bucket.has(AGGREGATION_RESULT_PARAM) || !bucket.getJSONObject(AGGREGATION_RESULT_PARAM).has(BUCKETS_RESPONSE_BODY)) continue;
                JSONArray subBuckets = bucket.getJSONObject(AGGREGATION_RESULT_PARAM).getJSONArray(BUCKETS_RESPONSE_BODY);
                for (int j = 0; j < subBuckets.length(); ++j) {
                    JSONObject subBucket = subBuckets.getJSONObject(j);
                    String key = this.getResultKeyAsString(subBucket);
                    TableColumnItemValue itemValue = itemValues.computeIfAbsent(key, mapKey -> new TableColumnItemValue());
                    itemValue.setKey(key);
                    if (columnIndex == 0) {
                        itemValue.setValue((Object)key);
                        continue;
                    }
                    this.computeColumnItemValue(itemValue, subBucket, isCurrent, isValue);
                }
            }
        } else {
            for (int i = 0; i < buckets.length(); ++i) {
                JSONObject bucket = buckets.getJSONObject(i);
                String key = this.getResultKeyAsString(bucket);
                TableColumnItemValue itemValue = new TableColumnItemValue();
                itemValue.setKey(key);
                if (columnIndex == 0) {
                    itemValue.setValue((Object)key);
                } else {
                    this.computeColumnItemValue(itemValue, bucket, true, isValue);
                }
                itemValues.put(itemValue.getKey(), itemValue);
            }
        }
        List itemsList = null;
        itemsList = limit > 0L ? itemValues.values().stream().limit(limit).toList() : new ArrayList(itemValues.values());
        tableColumnResult.setItems(itemsList);
        return tableColumnResult;
    }

    private void computeColumnItemValue(TableColumnItemValue itemValue, JSONObject bucket, boolean isCurrent, boolean isValue) throws JSONException {
        Object value;
        if (bucket.has(AGGREGATION_RESULT_VALUE_PARAM)) {
            value = bucket.getJSONObject(AGGREGATION_RESULT_VALUE_PARAM).get(VALUE_PARAM);
        } else if (bucket.has(AGGREGATION_RESULT_PARAM)) {
            JSONObject subAggregationResult = bucket.getJSONObject(AGGREGATION_RESULT_PARAM);
            ArrayList<String> values = new ArrayList<String>();
            if (subAggregationResult.has(BUCKETS_RESPONSE_BODY)) {
                JSONArray subAggregationBuckets = subAggregationResult.getJSONArray(BUCKETS_RESPONSE_BODY);
                for (int j = 0; j < subAggregationBuckets.length(); ++j) {
                    JSONObject subAggregationBucket = subAggregationBuckets.getJSONObject(j);
                    values.add(this.getResultKeyAsString(subAggregationBucket));
                }
            }
            value = values;
        } else {
            value = bucket.has(VALUE_PARAM) ? bucket.get(VALUE_PARAM) : null;
        }
        if (isValue) {
            if (isCurrent) {
                itemValue.setValue((Object)this.toString(value));
            } else {
                itemValue.setPreviousValue((Object)this.toString(value));
            }
        } else if (isCurrent) {
            itemValue.setThreshold((Object)this.toString(value));
        } else {
            itemValue.setPreviousThreshold((Object)this.toString(value));
        }
    }

    private PercentageChartValue buildPercentageChartValuesFromESResponse(String jsonResponse, AnalyticsPeriod currentPeriod, AnalyticsPeriod previousPeriod) throws JSONException {
        PercentageChartValue percentageChartValue = new PercentageChartValue();
        JSONObject json = new JSONObject(jsonResponse);
        JSONObject aggregations = json.getJSONObject(AGGREGATIONS_RESPONSE_BODY);
        if (aggregations == null) {
            return percentageChartValue;
        }
        percentageChartValue.setComputingTime(json.getLong("took"));
        JSONObject hitsResult = json.getJSONObject("hits");
        percentageChartValue.setDataCount(hitsResult.getJSONObject("total").getLong(VALUE_PARAM));
        if (aggregations.has(AGGREGATION_BUCKETS_VALUE_PARAM)) {
            double valueDouble;
            String value = this.toString(aggregations.getJSONObject(AGGREGATION_BUCKETS_VALUE_PARAM).get(VALUE_PARAM));
            double d = valueDouble = StringUtils.isBlank((CharSequence)value) || StringUtils.equals((CharSequence)"null", (CharSequence)value) ? 0.0 : Double.parseDouble(value);
            if (currentPeriod != null) {
                percentageChartValue.setCurrentPeriodValue(valueDouble);
            } else if (previousPeriod != null) {
                percentageChartValue.setPreviousPeriodValue(valueDouble);
            }
        } else if (aggregations.has(AGGREGATION_RESULT_PARAM)) {
            JSONArray buckets = aggregations.getJSONObject(AGGREGATION_RESULT_PARAM).getJSONArray(BUCKETS_RESPONSE_BODY);
            HashMap<Long, Double> values = new HashMap<Long, Double>();
            if (buckets.length() > 0) {
                for (int i = 0; i < buckets.length(); ++i) {
                    String value;
                    JSONObject bucket = buckets.getJSONObject(i);
                    Long timestamp = bucket.getLong("key");
                    if (bucket.has(AGGREGATION_BUCKETS_VALUE_PARAM)) {
                        value = this.toString(bucket.getJSONObject(AGGREGATION_BUCKETS_VALUE_PARAM).get(VALUE_PARAM));
                        values.put(timestamp, StringUtils.isBlank((CharSequence)value) || StringUtils.equals((CharSequence)"null", (CharSequence)value) ? 0.0 : Double.parseDouble(value));
                        continue;
                    }
                    if (bucket.has(AGGREGATION_RESULT_VALUE_PARAM)) {
                        value = this.toString(bucket.getJSONObject(AGGREGATION_RESULT_VALUE_PARAM).get(VALUE_PARAM));
                        values.put(timestamp, StringUtils.isBlank((CharSequence)value) || StringUtils.equals((CharSequence)"null", (CharSequence)value) ? 0.0 : Double.parseDouble(value));
                        continue;
                    }
                    LOG.warn("Can't extract value from bucket {}", new Object[]{bucket});
                }
                if (currentPeriod != null) {
                    double currentPeriodValue = values.entrySet().stream().filter(aggregationValue -> {
                        long timestamp = (Long)aggregationValue.getKey();
                        return timestamp < currentPeriod.getToInMS() && timestamp >= currentPeriod.getFromInMS();
                    }).map(Map.Entry::getValue).findFirst().orElse(0.0);
                    percentageChartValue.setCurrentPeriodValue(currentPeriodValue);
                }
                if (previousPeriod != null) {
                    double previousPeriodValue = values.entrySet().stream().filter(aggregationValue -> {
                        long timestamp = (Long)aggregationValue.getKey();
                        return timestamp < previousPeriod.getToInMS() && timestamp >= previousPeriod.getFromInMS();
                    }).map(Map.Entry::getValue).findFirst().orElse(0.0);
                    percentageChartValue.setPreviousPeriodValue(previousPeriodValue);
                }
            }
        }
        return percentageChartValue;
    }

    private ChartDataList buildChartDataFromESResponse(AnalyticsFilter filter, String jsonResponse) throws JSONException {
        AnalyticsAggregation multipleChartsAggregation = filter.getMultipleChartsAggregation();
        String lang = filter.getLang();
        ChartDataList chartsData = new ChartDataList(lang);
        JSONObject json = new JSONObject(jsonResponse);
        JSONObject aggregations = json.getJSONObject(AGGREGATIONS_RESPONSE_BODY);
        if (aggregations == null) {
            return chartsData;
        }
        JSONObject hitsResult = (JSONObject)json.get("hits");
        chartsData.setComputingTime(json.getLong("took"));
        chartsData.setDataCount(hitsResult.getJSONObject("total").getLong(VALUE_PARAM));
        int level = multipleChartsAggregation == null ? 0 : -1;
        this.computeAggregatedResultEntry(filter, aggregations, chartsData, multipleChartsAggregation, null, null, level);
        this.addEmptyResultsToNotExistingEntries(chartsData);
        return chartsData;
    }

    private void computeAggregatedResultEntry(AnalyticsFilter filter, JSONObject aggregations, ChartDataList chartsData, AnalyticsAggregation multipleChartsAggregation, ChartAggregationValue parentAggregation, ArrayList<ChartAggregationValue> aggregationValues, int level) throws JSONException {
        String lang = filter.getLang();
        JSONObject aggsResult = aggregations.getJSONObject(AGGREGATION_RESULT_PARAM);
        JSONArray buckets = aggsResult.getJSONArray(BUCKETS_RESPONSE_BODY);
        if (buckets.length() > 0) {
            int nextLevel = level + 1;
            for (int i = 0; i < buckets.length(); ++i) {
                String key;
                JSONObject bucketResult = buckets.getJSONObject(i);
                ArrayList<ChartAggregationValue> childAggregationValues = new ArrayList<ChartAggregationValue>();
                if (aggregationValues != null) {
                    childAggregationValues.addAll(aggregationValues);
                }
                if (bucketResult.isNull(AGGREGATION_RESULT_PARAM)) {
                    key = this.getResultKeyAsString(bucketResult);
                    String result = null;
                    if (bucketResult.isNull(AGGREGATION_RESULT_VALUE_PARAM)) {
                        Object docCount = bucketResult.get("doc_count");
                        result = docCount.toString();
                    } else {
                        JSONObject valueResult = bucketResult.getJSONObject(AGGREGATION_RESULT_VALUE_PARAM);
                        Object value = valueResult.get(VALUE_PARAM);
                        if (value instanceof BigDecimal) {
                            BigDecimal bd = (BigDecimal)value;
                            result = bd.toPlainString();
                        } else {
                            result = value.toString();
                        }
                    }
                    this.addAggregationValue(key, filter, childAggregationValues, level);
                    List<String> labels = childAggregationValues.stream().map(ChartAggregationValue::getFieldLabel).toList();
                    String label = StringUtils.join(labels, (String)AGGREGATION_KEYS_SEPARATOR);
                    ChartAggregationLabel chartLabel = new ChartAggregationLabel(childAggregationValues, label, lang);
                    ChartAggregationResult aggregationResult = new ChartAggregationResult(chartLabel, chartLabel.getLabel(), result);
                    chartsData.addAggregationResult(filter, parentAggregation, aggregationResult);
                    continue;
                }
                key = this.getResultKeyAsString(bucketResult);
                ChartAggregationValue parentAggregationToUse = parentAggregation;
                if (multipleChartsAggregation != null && level == -1) {
                    String fieldLabel = multipleChartsAggregation.getType() == AnalyticsAggregationType.DATE ? multipleChartsAggregation.getLabel(key, filter.zoneId(), filter.getLang()) : (filter.isHideLabel() ? key : multipleChartsAggregation.getLabel(key));
                    parentAggregationToUse = new ChartAggregationValue(multipleChartsAggregation, key, fieldLabel);
                } else {
                    this.addAggregationValue(key, filter, childAggregationValues, level);
                }
                this.computeAggregatedResultEntry(filter, bucketResult, chartsData, multipleChartsAggregation, parentAggregationToUse, childAggregationValues, nextLevel);
            }
        }
    }

    private void addAggregationValue(String key, AnalyticsFilter filter, ArrayList<ChartAggregationValue> aggregationValues, int level) {
        AnalyticsAggregation aggregation = null;
        if (filter.getXAxisAggregations().size() < level) {
            if (filter.getYAxisAggregation() == null) {
                throw new IllegalStateException("Can't find relative aggregation to index " + level);
            }
            aggregation = filter.getYAxisAggregation();
        } else {
            aggregation = (AnalyticsAggregation)filter.getXAxisAggregations().get(level);
        }
        String fieldLabel = null;
        fieldLabel = aggregation == null || filter.isHideLabel() ? key : (aggregation.getType() == AnalyticsAggregationType.DATE ? aggregation.getLabel(key, filter.zoneId(), filter.getLang()) : aggregation.getLabel(key));
        ChartAggregationValue aggregationValue = new ChartAggregationValue(aggregation, key, fieldLabel);
        aggregationValues.add(aggregationValue);
    }

    private List<StatisticData> buildSearchResultFromESResponse(String jsonResponse) throws JSONException {
        ArrayList<StatisticData> results = new ArrayList<StatisticData>();
        JSONObject json = new JSONObject(jsonResponse);
        JSONObject jsonResult = (JSONObject)json.get("hits");
        if (jsonResult == null) {
            return results;
        }
        JSONArray jsonHits = jsonResult.getJSONArray("hits");
        for (int i = 0; i < jsonHits.length(); ++i) {
            JSONObject statisticDataJsonObject = jsonHits.getJSONObject(i).getJSONObject("_source");
            int statusOrdinal = statisticDataJsonObject.getInt("status");
            statisticDataJsonObject.put("status", (Object)StatisticData.StatisticStatus.values()[statusOrdinal]);
            StatisticData statisticData = (StatisticData)AnalyticsUtils.fromJsonString((String)statisticDataJsonObject.toString(), StatisticData.class);
            AnalyticsUtils.DEFAULT_FIELDS.stream().forEach(arg_0 -> ((JSONObject)statisticDataJsonObject).remove(arg_0));
            statisticData.setParameters(new HashMap());
            Iterator remainingKeys = statisticDataJsonObject.keys();
            while (remainingKeys.hasNext()) {
                String key = (String)remainingKeys.next();
                statisticData.getParameters().put(key, this.toString(statisticDataJsonObject.get(key)));
            }
            results.add(statisticData);
        }
        return results;
    }

    private StatisticFieldMapping getFieldMapping(String fieldName) {
        return this.esMappings.get(fieldName);
    }

    private String getBucketAggregationType(AnalyticsAggregationType percentageAggregationType) {
        switch (percentageAggregationType) {
            case MIN: {
                return "min_bucket";
            }
            case MAX: {
                return "max_bucket";
            }
            case AVG: {
                return "avg_bucket";
            }
        }
        return "sum_bucket";
    }

    private void readFieldsMapping() {
        SettingValue existingMapping = this.settingService.get(CONTEXT, ES_SCOPE, ES_AGGREGATED_MAPPING);
        if (existingMapping == null) {
            return;
        }
        String esMappingSerialized = existingMapping.getValue().toString();
        try {
            JSONObject jsonObject = new JSONObject(esMappingSerialized);
            Iterator keys = jsonObject.keys();
            while (keys.hasNext()) {
                String key = keys.next().toString();
                String fieldMappingString = this.toString(jsonObject.get(key));
                StatisticFieldMapping fieldMapping = (StatisticFieldMapping)AnalyticsUtils.fromJsonString((String)fieldMappingString, StatisticFieldMapping.class);
                this.esMappings.put(key, fieldMapping);
            }
        }
        catch (JSONException e) {
            LOG.error((Object)"Error reading ES mapped fields", (Throwable)e);
        }
    }

    private void storeFieldsMappings() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        Set<String> keys = this.esMappings.keySet();
        for (String key : keys) {
            jsonObject.put(key, (Object)AnalyticsUtils.toJsonString((Object)this.esMappings.get(key)));
        }
        this.settingService.set(CONTEXT, ES_SCOPE, ES_AGGREGATED_MAPPING, SettingValue.create((String)jsonObject.toString()));
    }

    private void addEmptyResultsToNotExistingEntries(ChartDataList chartsData) {
        LinkedHashSet aggregationLabels = chartsData.getAggregationLabels();
        int index = 0;
        for (ChartAggregationLabel chartAggregationLabel : aggregationLabels) {
            ChartAggregationResult emptyResult = new ChartAggregationResult(chartAggregationLabel, chartAggregationLabel.getLabel(), null);
            LinkedHashSet charts = chartsData.getCharts();
            for (ChartData chartData : charts) {
                chartData.addAggregationResult(emptyResult, index, false);
            }
            ++index;
        }
    }

    private String getResultKeyAsString(JSONObject bucketResult) throws JSONException {
        return bucketResult.has("key_as_string") ? bucketResult.getString("key_as_string") : this.toString(bucketResult.get("key"));
    }

    private String toString(Object value) {
        return Objects.toString(value, null);
    }

    @Generated
    public List<String> getAdministratorsPermissions() {
        return this.administratorsPermissions;
    }

    @Generated
    public List<String> getViewAllPermissions() {
        return this.viewAllPermissions;
    }

    @Generated
    public List<String> getViewPermissions() {
        return this.viewPermissions;
    }

    static {
        ElasticsearchAnalyticsService.ajc$preClinit();
        LOG = ExoLogger.getLogger(ElasticsearchAnalyticsService.class);
        CONTEXT = Context.GLOBAL.id("ANALYTICS");
        ES_SCOPE = Scope.GLOBAL.id("elasticsearch");
    }

    static final /* synthetic */ Set retrieveMapping_aroundBody0(ElasticsearchAnalyticsService ajc$this, boolean forceRefresh, JoinPoint joinPoint) {
        if (!forceRefresh) {
            if (ajc$this.esMappings.isEmpty()) {
                ajc$this.readFieldsMapping();
            }
            return new HashSet<StatisticFieldMapping>(ajc$this.esMappings.values());
        }
        try {
            String mappingJsonString = ajc$this.elasticsearchStorage.retrieveAllAnalyticsIndexesMapping();
            if (StringUtils.isBlank((CharSequence)mappingJsonString)) {
                return new HashSet<StatisticFieldMapping>(ajc$this.esMappings.values());
            }
            JSONObject result = new JSONObject(mappingJsonString);
            JSONObject mappingObject = AnalyticsUtils.getJSONObject((JSONObject)result, (int)0, (String[])new String[]{null, "mappings", "properties"});
            if (mappingObject != null) {
                String[] fieldNames;
                for (String fieldName : fieldNames = JSONObject.getNames((JSONObject)mappingObject)) {
                    JSONObject esField = mappingObject.getJSONObject(fieldName);
                    if (esField == null || !esField.has("type")) continue;
                    String fieldType = esField.getString("type");
                    JSONObject keywordField = AnalyticsUtils.getJSONObject((JSONObject)esField, (int)0, (String[])new String[]{"fields", "keyword"});
                    StatisticFieldMapping esFieldMapping = new StatisticFieldMapping(fieldName, fieldType, keywordField != null);
                    ajc$this.esMappings.put(fieldName, esFieldMapping);
                }
            }
            ajc$this.addESDateSubField("hourOfDay");
            ajc$this.addESDateSubField("dayOfMonth");
            ajc$this.addESDateSubField("dayOfWeek");
            ajc$this.addESDateSubField("dayOfYear");
            ajc$this.addESDateSubField("monthOfYear");
            ajc$this.addESDateSubField("year");
            ajc$this.storeFieldsMappings();
        }
        catch (Exception e) {
            LOG.error((Object)"Error getting mapping of analytics", (Throwable)e);
        }
        return new HashSet<StatisticFieldMapping>(ajc$this.esMappings.values());
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ElasticsearchAnalyticsService.java", ElasticsearchAnalyticsService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "retrieveMapping", "io.meeds.analytics.elasticsearch.service.ElasticsearchAnalyticsService", "boolean", "forceRefresh", "", "java.util.Set"), 204);
    }
}

