/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.analytics.elasticsearch.storage;

import io.meeds.analytics.elasticsearch.model.ElasticsearchResponse;
import io.meeds.analytics.elasticsearch.storage.ElasticsearchConfiguration;
import io.meeds.analytics.model.StatisticData;
import io.meeds.analytics.model.StatisticDataQueueEntry;
import io.meeds.analytics.model.StatisticFieldMapping;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.ResolverStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.exoplatform.commons.search.domain.Document;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;

@Component
public class ElasticsearchAnalyticsStorage {
    private static final String TEXT_MAPPING_TYPE = "text";
    private static final String KEYWORD_MAPPING_TYPE = "keyword";
    private static final String BOOLEAN_MAPPING_TYPE = "boolean";
    private static final String FLOAT_MAPPING_TYPE = "float";
    private static final String LONG_MAPPING_TYPE = "long";
    private static final Log LOG = ExoLogger.getExoLogger(ElasticsearchAnalyticsStorage.class);
    private static final long DAY_IN_MS = 86400000L;
    private static final String DAY_DATE_FORMAT = "yyyy-MM-dd";
    public static final DateTimeFormatter DAY_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd").withResolverStyle(ResolverStyle.LENIENT);
    private List<String> ignoredFieldNames = Collections.synchronizedList(new ArrayList());
    @Autowired
    private ListenerService listenerService;
    @Autowired
    private ElasticsearchConfiguration elasticsearchConfiguration;
    @Autowired
    @Qualifier(value="elasticsearchHttpClient")
    private HttpClient httpClient;

    @PostConstruct
    public void init() {
        try {
            this.checkIndexTemplateExistence();
            CompletableFuture.runAsync(this::sendRolloverRequest);
        }
        catch (Exception e) {
            LOG.warn((Object)"Error while initializing Elasticsearch connection", (Throwable)e);
        }
    }

    public void sendCreateBulkDocumentsRequest(List<StatisticDataQueueEntry> dataQueueEntries, Set<StatisticFieldMapping> esMappings) {
        if (dataQueueEntries == null || dataQueueEntries.isEmpty()) {
            return;
        }
        LOG.debug("Indexing in bulk {} documents", new Object[]{dataQueueEntries.size()});
        this.sendCreateIndexRequest();
        StringBuilder request = new StringBuilder();
        for (StatisticDataQueueEntry statisticDataQueueEntry : dataQueueEntries) {
            String singleDocumentQuery = this.getCreateDocumentRequestContent(String.valueOf(statisticDataQueueEntry.getId()), statisticDataQueueEntry.getStatisticData(), esMappings);
            request.append(singleDocumentQuery);
        }
        LOG.debug("Create documents request to ES: {}", new Object[]{request});
        this.sendPutRequest("_bulk", request.toString());
        this.sendRefreshIndex();
    }

    public String search(String esQuery) {
        ElasticsearchResponse elasticResponse = this.sendPostRequest(this.elasticsearchConfiguration.getIndexAlias() + "/_search", esQuery);
        String response = elasticResponse.getMessage();
        int statusCode = elasticResponse.getStatusCode();
        if (StringUtils.isBlank((CharSequence)response)) {
            response = "Empty response was sent by ES";
        } else if (!this.isError(elasticResponse)) {
            JSONObject json = null;
            try {
                json = new JSONObject(response);
                if (json.has("status") && this.isError(json.getInt("status"))) {
                    throw new IllegalStateException("Error occured while requesting ES HTTP error code: '" + statusCode + "', HTTP response: '" + response + "'");
                }
            }
            catch (JSONException e) {
                throw new IllegalStateException("Error occured while requesting ES HTTP code: '" + statusCode + "', Error parsing response to JSON format, content = '" + response + "'", e);
            }
        }
        return response;
    }

    public String retrieveAllAnalyticsIndexesMapping() {
        ElasticsearchResponse response = this.sendGetRequest(this.elasticsearchConfiguration.getIndexAlias() + "/_mapping", false);
        if (this.isError(response)) {
            LOG.warn("Error getting mapping of analytics : - \t\tcode : {} - \t\tmessage: {}", new Object[]{response.getStatusCode(), response.getMessage()});
            return null;
        }
        return response.getMessage();
    }

    public ElasticsearchResponse sendGetRequest(String uri) {
        return this.sendGetRequest(uri, true);
    }

    public ElasticsearchResponse sendGetRequest(String uri, boolean handleResponse) {
        ElasticsearchResponse response = this.sendHttpGetRequest(this.elasticsearchConfiguration.getUrlClient() + "/" + uri);
        if (handleResponse) {
            return this.handleESResponse(response, uri, null);
        }
        return response;
    }

    public ElasticsearchResponse sendHeadRequest(String uri) {
        ElasticsearchResponse response = this.sendHttpHeadRequest(this.elasticsearchConfiguration.getUrlClient() + "/" + uri);
        return this.handleESResponse(response, uri, null);
    }

    public ElasticsearchResponse sendPutRequest(String uri, String content) {
        ElasticsearchResponse response = this.sendHttpPutRequest(this.elasticsearchConfiguration.getUrlClient() + "/" + uri, content);
        return this.handleESResponse(response, uri, content);
    }

    public ElasticsearchResponse sendDeleteRequest(String uri) {
        ElasticsearchResponse response = this.sendHttpDeleteRequest(this.elasticsearchConfiguration.getUrlClient() + "/" + uri);
        return this.handleESResponse(response, uri, null);
    }

    public ElasticsearchResponse sendPostRequest(String uri, String content) {
        ElasticsearchResponse response = this.sendHttpPostRequest(this.elasticsearchConfiguration.getUrlClient() + "/" + uri, content);
        return this.handleESResponse(response, uri, content);
    }

    private boolean sendCreateIndexRequest() {
        String index = this.getIndex();
        if (this.sendIsIndexExistsRequest(index)) {
            LOG.debug("Index {} already exists. Index creation requests will not be sent.", new Object[]{index});
            return false;
        }
        this.sendTurnOffWriteOnAllAnalyticsIndexes();
        this.sendCreateIndex(index);
        if (this.sendIsIndexExistsRequest(index)) {
            LOG.info("New analytics index {} created.", new Object[]{index});
            return true;
        }
        throw new IllegalStateException("Error creating index " + index + " on elasticsearch");
    }

    private void sendTurnOffWriteOnAllAnalyticsIndexes() {
        if (this.sendIsIndexExistsRequest(this.elasticsearchConfiguration.getIndexAlias())) {
            String esQuery = this.getTurnOffWriteOnAllAnalyticsIndexes();
            try {
                this.sendPostRequest("_aliases", esQuery);
                LOG.info((Object)"All analytics indexes switched to RO mode to prepare creation of a new index");
            }
            catch (Exception e) {
                LOG.warn((Object)"Analytics old indexes seems to not be turned off on write access");
            }
        }
    }

    @Cacheable(value={"analytics.indexExists"})
    private boolean sendIsIndexExistsRequest(String esIndex) {
        ElasticsearchResponse responseExists = this.sendGetRequest(esIndex, false);
        return responseExists.getStatusCode() == 200;
    }

    @CacheEvict(value={"analytics.indexExists"})
    private void sendCreateIndex(String index) {
        this.sendPutRequest(index, this.getCreateIndexRequestContent());
        CompletableFuture.runAsync(this::sendRolloverRequest);
    }

    private boolean sendIsIndexTemplateExistsRequest() {
        ElasticsearchResponse responseExists = this.sendGetRequest("_index_template/" + this.elasticsearchConfiguration.getIndexTemplateName(), false);
        return responseExists.getStatusCode() == 200;
    }

    private void sendRefreshIndex() {
        this.sendRefreshIndex(this.elasticsearchConfiguration.getIndexAlias());
    }

    private void sendRefreshIndex(String index) {
        this.sendPostRequest(index + "/_refresh", null);
    }

    private ElasticsearchResponse sendHttpPostRequest(String url, String content) {
        HttpPost httpTypeRequest = new HttpPost(url);
        if (StringUtils.isNotBlank((CharSequence)content)) {
            httpTypeRequest.setEntity((HttpEntity)new StringEntity(content, ContentType.APPLICATION_JSON));
        }
        return (ElasticsearchResponse)this.httpClient.execute((ClassicHttpRequest)httpTypeRequest, this::handleHttpResponse);
    }

    private ElasticsearchResponse sendHttpPutRequest(String url, String content) {
        HttpPut httpTypeRequest = new HttpPut(url);
        if (StringUtils.isNotBlank((CharSequence)content)) {
            httpTypeRequest.setEntity((HttpEntity)new StringEntity(content, ContentType.APPLICATION_JSON));
        }
        return (ElasticsearchResponse)this.httpClient.execute((ClassicHttpRequest)httpTypeRequest, this::handleHttpResponse);
    }

    private ElasticsearchResponse sendHttpDeleteRequest(String url) {
        HttpDelete httpDeleteRequest = new HttpDelete(url);
        return (ElasticsearchResponse)this.httpClient.execute((ClassicHttpRequest)httpDeleteRequest, this::handleHttpResponse);
    }

    private ElasticsearchResponse sendHttpGetRequest(String url) {
        HttpGet httpGetRequest = new HttpGet(url);
        return (ElasticsearchResponse)this.httpClient.execute((ClassicHttpRequest)httpGetRequest, this::handleHttpResponse);
    }

    private ElasticsearchResponse sendHttpHeadRequest(String url) {
        HttpHead httpHeadRequest = new HttpHead(url);
        return (ElasticsearchResponse)this.httpClient.execute((ClassicHttpRequest)httpHeadRequest, this::handleHttpResponse);
    }

    private String getCreateIndexRequestContent() {
        return " {\"aliases\": {  \"" + this.elasticsearchConfiguration.getIndexAlias() + "\": {    \"is_write_index\" : true  }}}";
    }

    private String getTurnOffWriteOnAllAnalyticsIndexes() {
        return "{\"actions\": [  {    \"add\": {      \"index\": \"" + this.elasticsearchConfiguration.getIndexPrefix() + "*\",      \"alias\": \"" + this.elasticsearchConfiguration.getIndexAlias() + "\",      \"is_write_index\": false    }  }]}";
    }

    private String getCreateDocumentRequestContent(String id, StatisticData data, Set<StatisticFieldMapping> esMappings) {
        JSONObject jsonObject = this.createCUDHeaderRequestContent(id);
        String timestampString = String.valueOf(data.getTimestamp());
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("id", id);
        fields.put("timestamp", timestampString);
        fields.put("userId", String.valueOf(data.getUserId()));
        fields.put("spaceId", String.valueOf(data.getSpaceId()));
        fields.put("module", data.getModule());
        fields.put("subModule", data.getSubModule());
        fields.put("operation", data.getOperation());
        fields.put("status", String.valueOf(data.getStatus().ordinal()));
        fields.put("errorCode", String.valueOf(data.getErrorCode()));
        fields.put("errorMessage", data.getErrorMessage());
        fields.put("duration", String.valueOf(data.getDuration()));
        fields.put("isAnalytics", "true");
        Map mappedFields = esMappings.stream().collect(Collectors.toMap(StatisticFieldMapping::getName, Function.identity()));
        if (MapUtils.isNotEmpty((Map)data.getParameters())) {
            data.getParameters().keySet().stream().filter(p -> !mappedFields.containsKey(p)).forEach(f -> this.createFieldMapping((String)f, data.getParameters().get(f)));
            Map<String, String> parameters = data.getParameters().entrySet().stream().filter(e -> e.getValue() != null && StringUtils.isNotBlank((CharSequence)e.getValue().toString())).filter(e -> {
                StatisticFieldMapping mapping;
                String name = (String)e.getKey();
                Object value = e.getValue();
                if (this.checkFieldMapping(value, mapping = (StatisticFieldMapping)mappedFields.get(name))) {
                    return true;
                }
                if (!this.ignoredFieldNames.contains(name)) {
                    this.ignoredFieldNames.add(name);
                    LOG.warn("Field with name '{}' and type '{}' isn't compatible with ES type '{}'. Ignore adding it in indexed document.", new Object[]{name, this.getFieldMappingType(value), mapping.getType()});
                }
                return false;
            }).collect(Collectors.toMap(Map.Entry::getKey, e -> this.getFieldValue(e.getValue())));
            fields.putAll(parameters);
        }
        Document document = new Document(String.valueOf(id), null, null, (Set)null, fields);
        if (MapUtils.isNotEmpty((Map)data.getListParameters())) {
            data.getListParameters().keySet().stream().filter(p -> !mappedFields.containsKey(p)).filter(p -> CollectionUtils.isNotEmpty((Collection)((Collection)data.getListParameters().get(p)))).forEach(p -> this.createFieldMapping((String)p, data.getListParameters().get(p)));
            Map<String, Collection> parameters = data.getListParameters().entrySet().stream().filter(e -> CollectionUtils.isNotEmpty((Collection)((Collection)e.getValue()))).filter(e -> {
                String name;
                StatisticFieldMapping mapping;
                Collection value = (Collection)e.getValue();
                if (this.checkFieldMapping(value, mapping = (StatisticFieldMapping)mappedFields.get(name = (String)e.getKey()))) {
                    return true;
                }
                if (!this.ignoredFieldNames.contains(name)) {
                    this.ignoredFieldNames.add(name);
                    LOG.warn("Field with name '{}' doesn't have the expected type {} in ES ('{}'). Ignore adding it in indexed document.", new Object[]{name, this.getFieldMappingType(value), mapping.getType()});
                }
                return false;
            }).collect(Collectors.toMap(Map.Entry::getKey, e -> this.getFieldValue((Collection)e.getValue())));
            document.setListFields(parameters);
        }
        JSONObject createRequest = new JSONObject();
        createRequest.put("create", (Object)jsonObject);
        return createRequest.toString() + "\n" + document.toJSON() + "\n";
    }

    private void createFieldMapping(String f, Object value) {
        String type = this.getFieldMappingType(value);
        try {
            this.sendPutRequest(this.elasticsearchConfiguration.getIndexAlias() + "/_mapping", String.format("{\n  \"properties\": {\n    \"%s\" : {\n      \"type\" : \"%s\"\n    }\n  }\n}\n", f, type));
            LOG.info("Create ES Mapping for field '{}' with type '{}'", new Object[]{f, type});
            this.listenerService.broadcast("analytics.field.mapping.created", (Object)f, (Object)type);
        }
        catch (Exception e) {
            LOG.warn("Error while creating ES Mapping for field '{}' with type '{}'. It may already exists.", new Object[]{f, type, e});
        }
    }

    private boolean checkFieldMapping(Object value, StatisticFieldMapping mapping) {
        if (mapping == null) {
            return true;
        }
        String fieldMappingType = this.getFieldMappingType(value);
        String mappedType = mapping.getType();
        if (StringUtils.equalsIgnoreCase((CharSequence)mappedType, (CharSequence)fieldMappingType)) {
            return true;
        }
        return switch (mappedType) {
            case LONG_MAPPING_TYPE -> StringUtils.isNumeric((CharSequence)value.toString());
            case FLOAT_MAPPING_TYPE -> LONG_MAPPING_TYPE.equals(fieldMappingType);
            case BOOLEAN_MAPPING_TYPE -> StringUtils.equalsAny((CharSequence)value.toString(), (CharSequence[])new CharSequence[]{"true", "false"});
            case KEYWORD_MAPPING_TYPE -> true;
            case TEXT_MAPPING_TYPE -> true;
            default -> false;
        };
    }

    private String getFieldMappingType(Object value) {
        Object object = value;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Integer.class, Long.class, Byte.class, Float.class, Double.class, Boolean.class, Collection.class}, (Object)object2, n)) {
            case 0 -> {
                Integer v = (Integer)object2;
                yield LONG_MAPPING_TYPE;
            }
            case 1 -> {
                Long v = (Long)object2;
                yield LONG_MAPPING_TYPE;
            }
            case 2 -> {
                Byte v = (Byte)object2;
                yield LONG_MAPPING_TYPE;
            }
            case 3 -> {
                Float v = (Float)object2;
                yield FLOAT_MAPPING_TYPE;
            }
            case 4 -> {
                Double v = (Double)object2;
                yield FLOAT_MAPPING_TYPE;
            }
            case 5 -> {
                Boolean v = (Boolean)object2;
                yield BOOLEAN_MAPPING_TYPE;
            }
            case 6 -> {
                Collection v = (Collection)object2;
                yield this.getFieldMappingType(v.toArray()[0]);
            }
            default -> KEYWORD_MAPPING_TYPE;
        };
    }

    private String getFieldValue(Object value) {
        Object object = value;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Integer.class, Long.class, Byte.class, Float.class, Double.class}, (Object)object2, n)) {
            case 0 -> {
                Integer v = (Integer)object2;
                yield BigDecimal.valueOf(v.intValue()).toPlainString();
            }
            case 1 -> {
                Long v = (Long)object2;
                yield BigDecimal.valueOf(v).toPlainString();
            }
            case 2 -> {
                Byte v = (Byte)object2;
                yield BigDecimal.valueOf(v.byteValue()).toPlainString();
            }
            case 3 -> {
                Float v = (Float)object2;
                yield BigDecimal.valueOf(v.floatValue()).toPlainString();
            }
            case 4 -> {
                Double v = (Double)object2;
                yield BigDecimal.valueOf(v).toPlainString();
            }
            default -> String.valueOf(value);
        };
    }

    private Collection<String> getFieldValue(Collection<Object> value) {
        return value.stream().map(this::getFieldValue).toList();
    }

    private JSONObject createCUDHeaderRequestContent(String id) {
        JSONObject cudHeader = new JSONObject();
        cudHeader.put("_index", (Object)this.elasticsearchConfiguration.getIndexAlias());
        cudHeader.put("_id", (Object)id);
        return cudHeader;
    }

    private ElasticsearchResponse handleHttpResponse(ClassicHttpResponse httpResponse) throws IOException {
        HttpEntity entity = httpResponse.getEntity();
        int statusCode = httpResponse.getCode();
        return new ElasticsearchResponse(EntityUtils.toString((HttpEntity)entity), statusCode);
    }

    private boolean isError(ElasticsearchResponse response) {
        return this.isError(response.getStatusCode());
    }

    private boolean isError(int status) {
        return status / 100 != 2;
    }

    private ElasticsearchResponse handleESResponse(ElasticsearchResponse response, String uri, String content) {
        if (this.isError(response)) {
            throw new IllegalStateException(String.format("Error message returned from ES: %s. URI: %s. Content: %s", response.getMessage(), uri, content));
        }
        if (StringUtils.contains((CharSequence)response.getMessage(), (CharSequence)"\"errors\":true")) {
            if (StringUtils.contains((CharSequence)response.getMessage(), (CharSequence)"\"type\":\"version_conflict_engine_exception\"") && StringUtils.countMatches((CharSequence)response.getMessage(), (CharSequence)"{\"create\":{") == 1) {
                LOG.warn("ID conflict in some content: {}", new Object[]{response.getMessage()});
            } else {
                throw new IllegalStateException(String.format("Error message returned from ES: %s. URI: %s. Content: %s", response.getMessage(), uri, content));
            }
        }
        return response;
    }

    private void checkIndexTemplateExistence() {
        if (!this.sendIsIndexTemplateExistsRequest()) {
            String indexTemplate = this.elasticsearchConfiguration.getIndexTemplateName();
            this.sendPostRequest("_index_template/" + indexTemplate, this.elasticsearchConfiguration.getIndexTemplateMapping());
            if (this.sendIsIndexTemplateExistsRequest()) {
                LOG.info("Index Template {} created.", new Object[]{indexTemplate});
            } else {
                throw new IllegalStateException("Error while creating Index Template " + indexTemplate);
            }
        }
    }

    private void sendRolloverRequest() {
        LOG.info((Object)"Analytics Indices rollover process start");
        ElasticsearchResponse response = this.sendGetRequest(this.elasticsearchConfiguration.getIndexPrefix() + "_*?allow_no_indices=true&ignore_unavailable=true");
        String indexListJsonString = response.getMessage();
        JSONObject jsonObject = new JSONObject(indexListJsonString);
        List<String> outdatedIndices = jsonObject.keySet().stream().sorted((s1, s2) -> StringUtils.compare((String)s2, (String)s1)).skip(this.elasticsearchConfiguration.getMaxIndexCount()).filter(Objects::nonNull).toList();
        while (!outdatedIndices.isEmpty()) {
            List outdatedIndicesSubList = outdatedIndices.stream().limit(10L).toList();
            String outdatedIndiceNames = StringUtils.join(outdatedIndicesSubList, (String)",");
            LOG.info("Deleting {} outdated analytics Indices: [{}]", new Object[]{outdatedIndicesSubList.size(), outdatedIndiceNames});
            this.sendDeleteRequest(outdatedIndiceNames);
            outdatedIndices = outdatedIndices.stream().skip(10L).toList();
        }
        LOG.info((Object)"Analytics Indices rollover process finished successfully.");
    }

    private final String getIndex() {
        return this.getIndex(System.currentTimeMillis() / this.getIndexPerDaysMs());
    }

    @Cacheable(value={"analytics.indexName"})
    private final String getIndex(long indexPeriodIndex) {
        long periodEpochMs = indexPeriodIndex * this.getIndexPerDaysMs();
        String indexSuffix = DAY_DATE_FORMATTER.format(Instant.ofEpochMilli(periodEpochMs).atZone(ZoneOffset.UTC));
        return this.elasticsearchConfiguration.getIndexPrefix() + "_" + indexSuffix;
    }

    private long getIndexPerDaysMs() {
        return 86400000L * Math.max(this.elasticsearchConfiguration.getIndexPerDays(), 1L);
    }
}

