/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.analytics.portlet;

import com.google.javascript.jscomp.jarjar.com.google.re2j.Pattern;
import io.meeds.analytics.api.service.AnalyticsService;
import io.meeds.analytics.model.chart.ChartDataList;
import io.meeds.analytics.model.filter.AnalyticsFilter;
import io.meeds.analytics.model.filter.aggregation.AnalyticsAggregation;
import io.meeds.analytics.utils.AnalyticsUtils;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.PortletException;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.portlet.GenericDispatchedViewPortlet;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.Utils;

public class AnalyticsQueryPortlet
extends GenericDispatchedViewPortlet {
    private static final String FROM_TIMESTAMP_PARAM = "{fromTimestamp}";
    private static final String TO_TIMESTAMP_PARAM = "{toTimestamp}";
    private static final String SPACE_IDS_PARAM = "{spaceIds}";
    private static final String SPACE_MEMBER_IDS_PARAM = "{spaceMemberIds}";
    private static final Pattern NUMBER_LIST_PATTERN = Pattern.compile((String)"[\\d,]*");
    private static final int MAX_SPACE_IDS = 1000;
    private static Map<String, String> filters = new ConcurrentHashMap();
    private AnalyticsService analyticsService;
    private SpaceService spaceService;

    public final void serveResource(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        AnalyticsFilter filter;
        try {
            filter = this.getFilter(request);
        }
        catch (IllegalAccessException e) {
            throw new PortletException((Throwable)e);
        }
        String limit = request.getParameter("limit");
        if (StringUtils.isBlank((CharSequence)limit)) {
            limit = request.getParameter("xLimit");
            ((AnalyticsAggregation)filter.getXAxisAggregations().get(0)).setLimit(Long.parseLong(limit));
        } else {
            filter.setLimit(Long.parseLong(limit));
        }
        ChartDataList result = this.getAnalyticsService().computeChartData(filter);
        response.getWriter().write(AnalyticsUtils.toJsonString((Object)result));
        response.setContentType("application/json");
    }

    private AnalyticsFilter getFilter(ResourceRequest request) throws IllegalAccessException {
        String filterName = request.getParameter("queryName");
        String filterString = this.getFilterContent(filterName);
        if (filterString.contains("{userIdentityId}")) {
            filterString = filterString.replace("{userIdentityId}", Utils.getViewerIdentityId());
        }
        if (filterString.contains(SPACE_IDS_PARAM)) {
            String spaceIds = request.getParameter("spaceIds");
            if (!NUMBER_LIST_PATTERN.matches(spaceIds)) {
                throw new IllegalAccessException("Illegal Chars found in parameter 'spaceIds'");
            }
            filterString = filterString.replace(SPACE_IDS_PARAM, spaceIds);
        }
        if (filterString.contains(SPACE_MEMBER_IDS_PARAM)) {
            List memberSpacesIds = this.getSpaceService().getMemberSpacesIds(request.getRemoteUser(), 0, 1000);
            filterString = filterString.replace(SPACE_MEMBER_IDS_PARAM, StringUtils.join((Iterable)memberSpacesIds, (String)","));
        }
        if (filterString.contains(FROM_TIMESTAMP_PARAM)) {
            String fromTimestamp = request.getParameter("fromTimestamp");
            if (!NUMBER_LIST_PATTERN.matches(fromTimestamp)) {
                throw new IllegalAccessException("Illegal Chars found in parameter 'fromTimestamp'");
            }
            filterString = filterString.replace(FROM_TIMESTAMP_PARAM, fromTimestamp);
        }
        if (filterString.contains(TO_TIMESTAMP_PARAM)) {
            String toTimestamp = request.getParameter("toTimestamp");
            if (!NUMBER_LIST_PATTERN.matches(toTimestamp)) {
                throw new IllegalAccessException("Illegal Chars found in parameter 'toTimestamp'");
            }
            filterString = filterString.replace(TO_TIMESTAMP_PARAM, toTimestamp);
        }
        return (AnalyticsFilter)AnalyticsUtils.fromJsonString((String)filterString, AnalyticsFilter.class);
    }

    private String getFilterContent(String filterName) {
        return filters.computeIfAbsent(filterName, n -> this.getInitParameter(filterName));
    }

    private AnalyticsService getAnalyticsService() {
        if (this.analyticsService == null) {
            this.analyticsService = (AnalyticsService)ExoContainerContext.getService(AnalyticsService.class);
        }
        return this.analyticsService;
    }

    private SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)ExoContainerContext.getService(SpaceService.class);
        }
        return this.spaceService;
    }
}

