/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.analytics.portlet;

import io.meeds.analytics.model.chart.PercentageChartResult;
import io.meeds.analytics.model.filter.AbstractAnalyticsFilter;
import io.meeds.analytics.model.filter.AnalyticsPercentageFilter;
import io.meeds.analytics.model.filter.AnalyticsPeriod;
import io.meeds.analytics.model.filter.AnalyticsPeriodType;
import io.meeds.analytics.portlet.AbstractAnalyticsPortlet;
import io.meeds.analytics.utils.AnalyticsUtils;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDate;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;

public class AnalyticsRatePortlet
extends AbstractAnalyticsPortlet<AnalyticsPercentageFilter> {
    protected String getViewPagePath() {
        return "/WEB-INF/jsp/analytics-rate.jsp";
    }

    protected Class<AnalyticsPercentageFilter> getFilterClass() {
        return AnalyticsPercentageFilter.class;
    }

    protected void readSettingsReadOnly(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        AnalyticsPercentageFilter filter = (AnalyticsPercentageFilter)this.getFilterFromPreferences(request);
        JSONObject jsonResponse = new JSONObject();
        this.addJSONParam(jsonResponse, "title", (Object)filter.getTitle());
        this.addJSONParam(jsonResponse, "chartType", (Object)filter.getChartType());
        this.addJSONParam(jsonResponse, "colors", (Object)filter.getColors());
        this.addJSONParam(jsonResponse, "canEdit", (Object)this.canModifySettings((PortletRequest)request));
        response.setContentType("application/json");
        response.getWriter().write(jsonResponse.toString());
    }

    protected void readSettings(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        AnalyticsPercentageFilter filter = (AnalyticsPercentageFilter)this.getFilterFromPreferences(request);
        response.setContentType("application/json");
        response.getWriter().write(AnalyticsUtils.toJsonString((Object)filter));
    }

    protected void readData(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        AnalyticsPercentageFilter filter = (AnalyticsPercentageFilter)this.getFilterFromPreferences(request);
        this.addLanguageFilter(request, filter);
        this.addTimeZoneFilter(request, (AbstractAnalyticsFilter)filter);
        this.addPeriodFilter(request, filter);
        PercentageChartResult result = this.getAnalyticsService().computePercentageChartData(filter);
        response.setContentType("application/json");
        response.getWriter().write(AnalyticsUtils.toJsonString((Object)result));
    }

    private void addLanguageFilter(ResourceRequest request, AnalyticsPercentageFilter filter) {
        String lang = request.getParameter("lang");
        filter.setLang(lang);
    }

    private void addPeriodFilter(ResourceRequest request, AnalyticsPercentageFilter filter) {
        String fromDateString = request.getParameter("min");
        String toDateString = request.getParameter("max");
        String periodType = request.getParameter("periodType");
        AnalyticsPeriod period = new AnalyticsPeriod(Long.parseLong(fromDateString), Long.parseLong(toDateString), filter.zoneId());
        if (StringUtils.isNotBlank((CharSequence)periodType)) {
            AnalyticsPeriodType analyticsPeriodType = AnalyticsPeriodType.periodTypeByName((String)periodType);
            long middleOfPeriod = (period.getFromInMS() + period.getToInMS()) / 2L;
            LocalDate middlePeriodDate = Instant.ofEpochMilli(middleOfPeriod).atZone(filter.zoneId()).toLocalDate();
            period = analyticsPeriodType.getCurrentPeriod(middlePeriodDate, filter.zoneId());
            middleOfPeriod = (period.getFromInMS() + period.getToInMS()) / 2L;
            filter.setPeriodDateInMS(middleOfPeriod);
            filter.setPeriodType(periodType);
        } else {
            filter.setCustomPeriod(period);
        }
    }
}

