/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.appcenter.upgrade;

import io.meeds.appcenter.entity.ApplicationEntity;
import io.meeds.appcenter.entity.FavoriteApplicationEntity;
import io.meeds.appcenter.upgrade.CleanFavoriteApplications$AjcClosure1;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CleanFavoriteApplications
extends UpgradeProductPlugin {
    private static final Log log;
    private static final String GROUP_ID_PARAM = "product.group.id";
    private static final String TARGET_VERSION_PARAM = "plugin.upgrade.target.version";
    private static final String EXECUTION_ORDER_PARAM = "plugin.execution.order";
    private static final String EXECUTION_ONCE_PARAM = "plugin.upgrade.execute.once";
    private static final String ASYNC_EXECUTION_PARAM = "plugin.upgrade.async.execution";
    private static final String PLUGIN_NAME = "CleanFavoriteApplications";
    private final EntityManagerService entityManagerService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @Autowired
    public CleanFavoriteApplications(EntityManagerService entityManagerService) {
        super(CleanFavoriteApplications.getInitParams());
        this.entityManagerService = entityManagerService;
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        long startupTime = System.currentTimeMillis();
        EntityManager entityManager = this.entityManagerService.getEntityManager();
        List<Object[]> duplicatedFavoriteAppsEntityList = this.getDuplicatedFavoriteAppsEntityList(entityManager);
        if (duplicatedFavoriteAppsEntityList.isEmpty()) {
            return;
        }
        log.info("Start upgrade of cleaning for favorite applications, {} favorite applications should be deleted", new Object[]{duplicatedFavoriteAppsEntityList.size()});
        HashSet uniqueUserNames = new HashSet();
        duplicatedFavoriteAppsEntityList.forEach(favoriteApplicationEntity -> uniqueUserNames.add((String)favoriteApplicationEntity[2]));
        log.info("{} favorite applications duplicated for {} users", new Object[]{duplicatedFavoriteAppsEntityList.size(), uniqueUserNames.size()});
        int favoriteApplicationCount = this.cleanFavoriteApps(entityManager, duplicatedFavoriteAppsEntityList);
        log.info("End upgrade : Deleted {} favorite applications done it took {} ms", new Object[]{favoriteApplicationCount, System.currentTimeMillis() - startupTime});
    }

    private List<Object[]> getDuplicatedFavoriteAppsEntityList(EntityManager entityManager) {
        String selectQuery = "SELECT * FROM AC_FAVORITE_APPLICATION favoriteApp WHERE (favoriteApp.APPLICATION_ID, favoriteApp.USER_NAME) IN (    SELECT favoriteApplication.APPLICATION_ID, favoriteApplication.USER_NAME     FROM AC_FAVORITE_APPLICATION favoriteApplication     GROUP BY favoriteApplication.APPLICATION_ID, favoriteApplication.USER_NAME     HAVING COUNT(*) > 1)";
        Query nativeQuery = entityManager.createNativeQuery(selectQuery);
        return nativeQuery.getResultList();
    }

    protected int cleanFavoriteApps(EntityManager entityManager, List<Object[]> duplicatedFavoriteApplicationsEntityList) {
        List<FavoriteApplicationEntity> duplicatedFavoriteAppsEntityList = this.toFavoriteAppsEntityList(duplicatedFavoriteApplicationsEntityList);
        ArrayList<FavoriteApplicationEntity> favoriteAppsEntityList = new ArrayList<FavoriteApplicationEntity>();
        int favoriteAppCount = 0;
        for (FavoriteApplicationEntity favoriteApplicationEntity : duplicatedFavoriteAppsEntityList) {
            FavoriteApplicationEntity favoriteAppEntityOfIdNull = new FavoriteApplicationEntity(0L, favoriteApplicationEntity.getApplication(), favoriteApplicationEntity.getUserName(), favoriteApplicationEntity.getOrder());
            if (favoriteAppsEntityList.contains(favoriteAppEntityOfIdNull)) {
                this.deleteFavoriteApplication(entityManager, favoriteApplicationEntity.getId());
                ++favoriteAppCount;
                continue;
            }
            favoriteAppsEntityList.add(favoriteAppEntityOfIdNull);
        }
        return favoriteAppCount;
    }

    List<FavoriteApplicationEntity> toFavoriteAppsEntityList(List<Object[]> objects) {
        ArrayList<FavoriteApplicationEntity> favoriteAppsEntityList = new ArrayList<FavoriteApplicationEntity>();
        objects.forEach(object -> {
            ApplicationEntity applicationEntity = new ApplicationEntity();
            applicationEntity.setId((Long)object[1]);
            favoriteAppsEntityList.add(new FavoriteApplicationEntity((Long)object[0], applicationEntity, (String)object[2], null));
        });
        return favoriteAppsEntityList;
    }

    @ExoTransactional
    protected void deleteFavoriteApplication(EntityManager entityManager, Long favoriteApplicationId) {
        EntityManager entityManager2 = entityManager;
        Long l = favoriteApplicationId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)entityManager2, (Object)l);
        Object[] objectArray = new Object[]{this, entityManager2, l, joinPoint};
        CleanFavoriteApplications$AjcClosure1 cleanFavoriteApplications$AjcClosure1 = new CleanFavoriteApplications$AjcClosure1(objectArray);
        ExoTransactionalAspect.aspectOf().around(cleanFavoriteApplications$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    private static InitParams getInitParams() {
        InitParams initParams = new InitParams();
        ValueParam groupIdParam = new ValueParam();
        groupIdParam.setName(GROUP_ID_PARAM);
        groupIdParam.setValue("org.exoplatform.platform");
        initParams.addParameter((Parameter)groupIdParam);
        ValueParam targetVersionParam = new ValueParam();
        targetVersionParam.setName(TARGET_VERSION_PARAM);
        targetVersionParam.setValue("7.0.0");
        initParams.addParameter((Parameter)targetVersionParam);
        ValueParam executionOrderParam = new ValueParam();
        executionOrderParam.setName(EXECUTION_ORDER_PARAM);
        executionOrderParam.setValue("10");
        initParams.addParameter((Parameter)executionOrderParam);
        ValueParam executionOnceParam = new ValueParam();
        executionOnceParam.setName(EXECUTION_ONCE_PARAM);
        executionOnceParam.setValue("true");
        initParams.addParameter((Parameter)executionOnceParam);
        ValueParam asyncExecutionParam = new ValueParam();
        asyncExecutionParam.setName(ASYNC_EXECUTION_PARAM);
        asyncExecutionParam.setValue("true");
        initParams.addParameter((Parameter)asyncExecutionParam);
        return initParams;
    }

    public String getName() {
        return PLUGIN_NAME;
    }

    static {
        CleanFavoriteApplications.ajc$preClinit();
        log = ExoLogger.getLogger((String)CleanFavoriteApplications.class.getName());
    }

    static final /* synthetic */ void deleteFavoriteApplication_aroundBody0(CleanFavoriteApplications ajc$this, EntityManager entityManager, Long favoriteApplicationId, JoinPoint joinPoint) {
        String deleteQuery = "DELETE FROM AC_FAVORITE_APPLICATION WHERE ID = " + favoriteApplicationId;
        Query query = entityManager.createNativeQuery(deleteQuery);
        query.executeUpdate();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("CleanFavoriteApplications.java", CleanFavoriteApplications.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "deleteFavoriteApplication", "io.meeds.appcenter.upgrade.CleanFavoriteApplications", "jakarta.persistence.EntityManager:java.lang.Long", "entityManager:favoriteApplicationId", "", "void"), 111);
    }
}

