/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.appcenter.rest;

import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.meeds.appcenter.constant.ApplicationType;
import io.meeds.appcenter.model.Application;
import io.meeds.appcenter.model.ApplicationList;
import io.meeds.appcenter.rest.ApplicationRest;
import io.meeds.appcenter.service.ApplicationCenterService;
import io.meeds.spring.web.security.PortalAuthenticationManager;
import io.meeds.spring.web.security.WebSecurityConfiguration;
import jakarta.servlet.Filter;
import java.util.Collections;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureWebMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.http.MediaType;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.test.web.servlet.request.SecurityMockMvcRequestPostProcessors;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

@SpringBootTest(classes={ApplicationRest.class, PortalAuthenticationManager.class})
@ContextConfiguration(classes={WebSecurityConfiguration.class})
@AutoConfigureWebMvc
@AutoConfigureMockMvc(addFilters=false)
@ExtendWith(value={MockitoExtension.class})
public class ApplicationRestTest {
    private static final String APPLICATIONS_PATH = "/applications";
    private static final String ALL_APPLICATIONS_PATH = "/applications/all";
    private static final String SIMPLE_USER = "simple";
    private static final String ADMIN_USER = "admin";
    private static final String TEST_PASSWORD = "testPassword";
    static final ObjectMapper OBJECT_MAPPER = ((JsonMapper.Builder)JsonMapper.builder().configure(JsonReadFeature.ALLOW_MISSING_VALUES, true).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false)).build();
    @MockBean
    private ApplicationCenterService applicationCenterService;
    @Autowired
    private SecurityFilterChain filterChain;
    @Autowired
    private WebApplicationContext context;
    private MockMvc mockMvc;

    @BeforeEach
    void setup() {
        this.mockMvc = ((DefaultMockMvcBuilder)MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.context).addFilters(this.filterChain.getFilters().toArray(new Filter[0]))).build();
    }

    @Test
    void getAllApplicationsAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)ALL_APPLICATIONS_PATH, (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void getAllApplications() throws Exception {
        Mockito.when((Object)this.applicationCenterService.getApplications(0, 10, "")).thenReturn((Object)this.applicationList());
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)ALL_APPLICATIONS_PATH, (Object[])new Object[0]).with(this.testAdminUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    void getApplicationsAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)APPLICATIONS_PATH, (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void getApplications() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)APPLICATIONS_PATH, (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    void createApplication() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)APPLICATIONS_PATH, (Object[])new Object[0]).with(this.testAdminUser()).content(ApplicationRestTest.asJsonString(this.application())).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    void updateApplication() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)APPLICATIONS_PATH, (Object[])new Object[0]).with(this.testAdminUser()).content(ApplicationRestTest.asJsonString(this.application())).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON}));
        response.andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    void deleteApplication() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/applications/1", (Object[])new Object[0]).with(this.testAdminUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
    }

    private RequestPostProcessor testAdminUser() {
        return SecurityMockMvcRequestPostProcessors.user((String)ADMIN_USER).password(TEST_PASSWORD).authorities(new GrantedAuthority[]{new SimpleGrantedAuthority("administrators")});
    }

    private RequestPostProcessor testSimpleUser() {
        return SecurityMockMvcRequestPostProcessors.user((String)SIMPLE_USER).password(TEST_PASSWORD).authorities(new GrantedAuthority[]{new SimpleGrantedAuthority("users")});
    }

    private ApplicationList applicationList() {
        ApplicationList result = new ApplicationList();
        result.setApplications(Collections.singletonList(this.application()));
        return result;
    }

    private Application application() {
        return new Application(Long.valueOf(1L), "title", "url", true, "", "description", "g", ApplicationType.LINK, false, true, false, true, false, true, null, null, Long.valueOf(5L), "icon", null, null, false);
    }

    public static String asJsonString(Object obj) {
        return OBJECT_MAPPER.writeValueAsString(obj);
    }

    static {
        OBJECT_MAPPER.registerModule((Module)new JavaTimeModule());
    }
}

