/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.appcenter.plugin;

import io.meeds.appcenter.constant.ApplicationType;
import io.meeds.appcenter.model.Application;
import io.meeds.appcenter.model.ApplicationList;
import io.meeds.appcenter.plugin.AppCenterPwaShortcutPlugin;
import io.meeds.appcenter.service.ApplicationCenterService;
import io.meeds.pwa.model.PwaShortcut;
import io.meeds.pwa.model.PwaShortcutIcon;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.resources.ResourceBundleService;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.data.domain.Pageable;

@SpringBootTest(classes={AppCenterPwaShortcutPlugin.class})
@ExtendWith(value={MockitoExtension.class})
public class AppCenterPwaShortcutPluginTest {
    private static final String TEST_USER = "testuser";
    @MockBean
    private PortalContainer container;
    @MockBean
    private UserPortalConfigService portalConfigService;
    @MockBean
    private ApplicationCenterService applicationCenterService;
    @Autowired
    private AppCenterPwaShortcutPlugin pwaShortcutPlugin;

    @BeforeEach
    public void setup() {
        Mockito.lenient().when((Object)((ApplicationCenterService)this.container.getComponentInstanceOfType(ApplicationCenterService.class))).thenReturn((Object)this.applicationCenterService);
    }

    @Test
    public void getShortcuts() {
        ApplicationList applicationList = new ApplicationList();
        applicationList.setApplications(Collections.emptyList());
        Mockito.when((Object)this.applicationCenterService.getMandatoryAndFavoriteApplications((Pageable)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)TEST_USER), (Locale)ArgumentMatchers.eq((Object)ResourceBundleService.DEFAULT_CROWDIN_LOCALE))).thenReturn((Object)applicationList);
        PortalConfig portalConfig = (PortalConfig)Mockito.mock(PortalConfig.class);
        Mockito.when((Object)portalConfig.getName()).thenReturn((Object)"meeds");
        Mockito.when((Object)this.portalConfigService.getDefaultSite(TEST_USER)).thenReturn((Object)portalConfig);
        List shortcuts = this.pwaShortcutPlugin.getShortcuts(TEST_USER);
        Assert.assertNotNull((Object)shortcuts);
        Assertions.assertEquals((int)0, (int)shortcuts.size());
        Application application = new Application(Long.valueOf(1L), "title", "./url", true, "helpPageURL", "description", "s", ApplicationType.LINK, true, true, true, true, true, true, null, null, null, "icon", "imageUrl", null, false);
        applicationList.setApplications(Collections.singletonList(application));
        shortcuts = this.pwaShortcutPlugin.getShortcuts(TEST_USER);
        Assert.assertNotNull((Object)shortcuts);
        Assertions.assertEquals((int)1, (int)shortcuts.size());
        PwaShortcut pwaShortcut = (PwaShortcut)shortcuts.get(0);
        Assert.assertNotNull((Object)pwaShortcut);
        Assertions.assertEquals((Object)application.getTitle(), (Object)pwaShortcut.getName());
        Assertions.assertEquals((Object)"/portal/meeds/url", (Object)pwaShortcut.getUrl());
        Assertions.assertEquals((Object)application.getDescription(), (Object)pwaShortcut.getDescription());
        Assertions.assertEquals((Object)application.getTitle(), (Object)pwaShortcut.getShortName());
        Assert.assertNotNull((Object)pwaShortcut.getIcons());
        Assertions.assertEquals((int)1, (int)pwaShortcut.getIcons().size());
        Assertions.assertEquals((Object)(CommonsUtils.getCurrentDomain() + application.getImageUrl() + "&sizes=192x192"), (Object)((PwaShortcutIcon)pwaShortcut.getIcons().get(0)).getSrc());
    }
}

