/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.appcenter.portlet;

import io.meeds.social.portlet.CMSPortlet;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Enumeration;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;

public class MyApplicationsPortlet
extends CMSPortlet {
    private static final String OBJECT_TYPE = "myApplicationsPortlet";
    private static final String APPLICATION_ID = "applicationId";
    private static final String IS_ADMIN = "isAdmin";
    private UserACL userAcl;
    private final SecureRandom random = new SecureRandom();

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.contentType = OBJECT_TYPE;
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        if (!this.canEditSettings()) {
            throw new PortletException("User is not allowed to edit settings");
        }
        PortletPreferences preferences = request.getPreferences();
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String name = (String)parameterNames.nextElement();
            if (StringUtils.equals((CharSequence)name, (CharSequence)"action") || StringUtils.contains((CharSequence)name, (CharSequence)"portal:")) continue;
            String value = request.getParameter(name);
            preferences.setValue(name, value);
        }
        preferences.store();
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        request.setAttribute(APPLICATION_ID, (Object)this.getOrCreateApplicationId(request.getPreferences()));
        request.setAttribute(IS_ADMIN, (Object)this.getUserAcl().isAdministrator(this.getCurrentIdentity()));
        super.doView(request, response);
    }

    private boolean canEditSettings() {
        return this.getUserAcl().isAdministrator(this.getCurrentIdentity());
    }

    private Identity getCurrentIdentity() {
        return ConversationState.getCurrent() == null ? null : ConversationState.getCurrent().getIdentity();
    }

    private UserACL getUserAcl() {
        if (this.userAcl == null) {
            this.userAcl = (UserACL)ExoContainerContext.getService(UserACL.class);
        }
        return this.userAcl;
    }

    private String getOrCreateApplicationId(PortletPreferences preferences) {
        String applicationId = preferences.getValue(APPLICATION_ID, null);
        if (applicationId == null) {
            applicationId = String.valueOf(this.random.nextLong() & Long.MAX_VALUE);
            this.savePreference(APPLICATION_ID, applicationId);
        }
        return applicationId;
    }
}

