/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.StripeException;
import com.stripe.model.PaymentSource;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.param.PaymentSourceCollectionCreateParams;
import com.stripe.param.PaymentSourceCollectionListParams;
import com.stripe.param.PaymentSourceCollectionRetrieveParams;
import java.lang.reflect.Type;
import java.util.Map;

public class PaymentSourceCollection
extends StripeCollection<PaymentSource> {
    public PaymentSource create(Map<String, Object> params) throws StripeException {
        return this.create(params, (RequestOptions)null);
    }

    public PaymentSource create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = this.getUrl();
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (PaymentSource)this.getResponseGetter().request(request, (Type)((Object)PaymentSource.class));
    }

    public PaymentSource create(PaymentSourceCollectionCreateParams params) throws StripeException {
        return this.create(params, (RequestOptions)null);
    }

    public PaymentSource create(PaymentSourceCollectionCreateParams params, RequestOptions options) throws StripeException {
        String path = this.getUrl();
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (PaymentSource)this.getResponseGetter().request(request, (Type)((Object)PaymentSource.class));
    }

    public PaymentSourceCollection list(Map<String, Object> params) throws StripeException {
        return this.list(params, (RequestOptions)null);
    }

    public PaymentSourceCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = this.getUrl();
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (PaymentSourceCollection)this.getResponseGetter().request(request, (Type)((Object)PaymentSourceCollection.class));
    }

    public PaymentSourceCollection list(PaymentSourceCollectionListParams params) throws StripeException {
        return this.list(params, (RequestOptions)null);
    }

    public PaymentSourceCollection list(PaymentSourceCollectionListParams params, RequestOptions options) throws StripeException {
        String path = this.getUrl();
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (PaymentSourceCollection)this.getResponseGetter().request(request, (Type)((Object)PaymentSourceCollection.class));
    }

    public PaymentSource retrieve(String id) throws StripeException {
        return this.retrieve(id, (Map<String, Object>)null, (RequestOptions)null);
    }

    public PaymentSource retrieve(String id, RequestOptions options) throws StripeException {
        return this.retrieve(id, (Map<String, Object>)null, options);
    }

    public PaymentSource retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("%s/%s", this.getUrl(), ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (PaymentSource)this.getResponseGetter().request(request, (Type)((Object)PaymentSource.class));
    }

    public PaymentSource retrieve(String id, PaymentSourceCollectionRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("%s/%s", this.getUrl(), ApiResource.urlEncodeId(id));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (PaymentSource)this.getResponseGetter().request(request, (Type)((Object)PaymentSource.class));
    }
}

