/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.PaymentMethodConfiguration;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.PaymentMethodConfigurationCreateParams;
import com.stripe.param.PaymentMethodConfigurationListParams;
import com.stripe.param.PaymentMethodConfigurationRetrieveParams;
import com.stripe.param.PaymentMethodConfigurationUpdateParams;
import java.lang.reflect.Type;

public final class PaymentMethodConfigurationService
extends ApiService {
    public PaymentMethodConfigurationService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<PaymentMethodConfiguration> list(PaymentMethodConfigurationListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<PaymentMethodConfiguration> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<PaymentMethodConfiguration> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<PaymentMethodConfiguration> list(PaymentMethodConfigurationListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/payment_method_configurations";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<PaymentMethodConfiguration>>(){}.getType());
    }

    public PaymentMethodConfiguration create(PaymentMethodConfigurationCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public PaymentMethodConfiguration create(RequestOptions options) throws StripeException {
        return this.create(null, options);
    }

    public PaymentMethodConfiguration create() throws StripeException {
        return this.create(null, null);
    }

    public PaymentMethodConfiguration create(PaymentMethodConfigurationCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/payment_method_configurations";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (PaymentMethodConfiguration)this.request(request, (Type)((Object)PaymentMethodConfiguration.class));
    }

    public PaymentMethodConfiguration retrieve(String configuration, PaymentMethodConfigurationRetrieveParams params) throws StripeException {
        return this.retrieve(configuration, params, null);
    }

    public PaymentMethodConfiguration retrieve(String configuration, RequestOptions options) throws StripeException {
        return this.retrieve(configuration, null, options);
    }

    public PaymentMethodConfiguration retrieve(String configuration) throws StripeException {
        return this.retrieve(configuration, null, null);
    }

    public PaymentMethodConfiguration retrieve(String configuration, PaymentMethodConfigurationRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_method_configurations/%s", ApiResource.urlEncodeId(configuration));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (PaymentMethodConfiguration)this.request(request, (Type)((Object)PaymentMethodConfiguration.class));
    }

    public PaymentMethodConfiguration update(String configuration, PaymentMethodConfigurationUpdateParams params) throws StripeException {
        return this.update(configuration, params, null);
    }

    public PaymentMethodConfiguration update(String configuration, RequestOptions options) throws StripeException {
        return this.update(configuration, null, options);
    }

    public PaymentMethodConfiguration update(String configuration) throws StripeException {
        return this.update(configuration, null, null);
    }

    public PaymentMethodConfiguration update(String configuration, PaymentMethodConfigurationUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_method_configurations/%s", ApiResource.urlEncodeId(configuration));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (PaymentMethodConfiguration)this.request(request, (Type)((Object)PaymentMethodConfiguration.class));
    }
}

