/*
 * This file is part of the Meeds project (https://meeds.io/).
 *
 * Copyright (C) 2020 - 2025 Meeds Association contact@meeds.io
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package io.meeds.billing.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import lombok.Data;

import java.io.Serializable;

@Entity(name = "HubBillingPlan")
@Table(name = "HUB_BILLING_PLAN")
@Data
public class HubBillingPlanEntity implements Serializable {

  @Id
  @SequenceGenerator(name = "SEQ_BILLING_HUB_PLAN_ID", sequenceName = "SEQ_BILLING_HUB_PLAN_ID", allocationSize = 1)
  @GeneratedValue(strategy = GenerationType.AUTO, generator = "SEQ_BILLING_HUB_PLAN_ID")
  @Column(name = "PLAN_ID", nullable = false)
  private Long   id;

  @Column(name = "PLAN_UUID", nullable = false)
  private String planId;    // Stripe Plan/Price ID (e.g. price_123abc)

  @Column(name = "PRODUCT_ID")
  private String productId;

  @Column(name = "METER_ID")
  private String meterId;

  @Column(name = "MAX_USERS")
  private Long   maxUsers;

  @Column(name = "BILLING_SCHEME")
  private String billingScheme;

  @Column(name = "TIERS_MODE")
  private String tiersMode;
}
