<!--

This file is part of the Meeds project (https://meeds.io/).

Copyright (C) 2020 - 2025 Meeds Association contact@meeds.io

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 3 of the License, or (at your option) any later version.
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

-->
<%@page import="org.exoplatform.social.core.space.model.Space" %>
<%@page import="org.exoplatform.social.core.space.spi.SpaceService" %>
<%@page import="org.exoplatform.social.core.space.SpaceUtils" %>
<%@page import="org.exoplatform.commons.utils.CommonsUtils" %>
<%@page import="org.exoplatform.commons.utils.PropertyManager" %>
<%@page import="io.meeds.billing.utils.Utils" %>
<%@ page import="io.meeds.billing.model.HubBillingSettings" %>
<%@ page import="io.meeds.billing.service.HubSettingService" %>


<%
  boolean isManager = false;
  boolean isRestricted = false;
  boolean isHubBillingEnabled = false;
  boolean isMetredBilling = false;
  boolean maxOfUsersExceeded = false;

  String subscriptionStatus = null;
  String subscriptionPreviousStatus = null;
  String status = null;

  long maxOfUsers = 0;
  long spaceMembersCount = 0;

  Space space = SpaceUtils.getSpaceByContext();
  if (space != null) {
    SpaceService spaceService = CommonsUtils.getService(SpaceService.class);
    isManager = spaceService.canManageSpace(space, request.getRemoteUser());
    HubSettingService hubSettingService = CommonsUtils.getService(HubSettingService.class);
    HubBillingSettings hubBillingSettings = hubSettingService.getSettingsBySpaceId(space.getId());
    if (hubBillingSettings != null) {
      subscriptionStatus = hubBillingSettings.getSubscriptionStatus();
      subscriptionPreviousStatus = hubBillingSettings.getSubscriptionPreviousStatus();
      if (subscriptionStatus != null) {
        subscriptionStatus = subscriptionStatus.toLowerCase();
      }
      isMetredBilling = hubBillingSettings.getHubBillingPlan() != null
              && hubBillingSettings.getHubBillingPlan().getMeterId() != null;
      spaceMembersCount = space.getMembers().length;
      maxOfUsers = hubBillingSettings.getHubBillingPlan() != null
              ? hubBillingSettings.getHubBillingPlan().getMaxUsers()
              : 0;
      maxOfUsersExceeded = maxOfUsers > 0 && maxOfUsers < spaceMembersCount && !isMetredBilling;
      boolean isPastDue = Utils.SubscriptionStatus.PAST_DUE.name().equalsIgnoreCase(subscriptionStatus)
              || Utils.SubscriptionStatus.INCOMPLETE.name().equalsIgnoreCase(subscriptionStatus);
      boolean isTrialExpired = isPastDue
              && Utils.SubscriptionStatus.TRIALING.name().equalsIgnoreCase(subscriptionPreviousStatus);
      boolean isCanceledSubscription = Utils.SubscriptionStatus.CANCELED.name().equalsIgnoreCase(subscriptionStatus);
      String billingEnabledProperty = PropertyManager.getProperty(Utils.BILLING_ENABLED_PROPERTY);
      isHubBillingEnabled = Boolean.parseBoolean(
              billingEnabledProperty != null ? billingEnabledProperty.trim() : "false"
      );

      isRestricted = isHubBillingEnabled && (isPastDue || maxOfUsersExceeded || isCanceledSubscription);
      status = isTrialExpired ? "trial_expired" : subscriptionStatus;
    }
  }
%>
<% if (isRestricted) { %>
<div class="VuetifyApp">
  <div data-app="true"
       class="v-application v-application--is-ltr theme--light"
       id="hubSubscriptionRestriction">
    <script type="text/javascript">
        require(['PORTLET/billing/HubSubscriptionRestriction'],
            app => app.init(
                <%=isManager%>,
                '<%=status%>',
                <%=spaceMembersCount%>,
                <%=maxOfUsers%>)
        );
    </script>
  </div>
</div>
<% }%>