const path = require('path');
const ESLintPlugin = require('eslint-webpack-plugin');
const { VueLoaderPlugin } = require('vue-loader')

const config = {
  context: path.resolve(__dirname, '.'),
  module: {
    rules: [
      {
        test: /\.js$/,
        exclude: /node_modules/,
        use: [
          'babel-loader',
        ]
      },
      {
        test: /\.vue$/,
        use: [
          'vue-loader',
        ]
      }
    ]
  },
  entry: {
    pricingTable: './src/main/webapp/vue-app/pricing-table/main.js',
    customerPortal: './src/main/webapp/vue-app/customer-portal/main.js',
    hubSubscriptionInfos: './src/main/webapp/vue-app/hub-subscription-infos/main.js',
    hubSubscriptionRestriction: './src/main/webapp/vue-app/hub-subscription-restriction/main.js',
  },
  plugins: [
    new ESLintPlugin({
      files: [
        './src/main/webapp/vue-app/*.js',
        './src/main/webapp/vue-app/*.vue',
        './src/main/webapp/vue-app/**/*.js',
        './src/main/webapp/vue-app/**/*.vue',
      ],
    }),
    new VueLoaderPlugin()
  ],
  externals: {
    vuetify: 'Vuetify',
    vue: 'Vue',
  }
};

module.exports = config;
