/*
 * This file is part of the Meeds project (https://meeds.io/).
 * Copyright (C) 2020 - 2025 Meeds Association contact@meeds.io
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package io.meeds.billig.listener;

import io.meeds.billing.listener.SpaceSiteCreatedListener;
import io.meeds.billing.model.HubBilling;
import io.meeds.billing.service.BillingService;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.config.serialize.model.SiteLayout;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.test.context.bean.override.mockito.MockitoBean;

import java.util.Collections;
import java.util.List;

import static org.assertj.core.api.Assertions.assertThat;
import static org.mockito.Mockito.doNothing;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

@SpringBootTest(classes = { SpaceSiteCreatedListener.class })
@ExtendWith(MockitoExtension.class)
public class SpaceSiteCreatedListenerTest {

  @MockitoBean
  private HubBilling               hubBilling;

  @MockitoBean
  private SpaceService             spaceService;

  @MockitoBean
  private ListenerService          listenerService;

  @MockBean
  private BillingService billingService;

  @Autowired
  private SpaceSiteCreatedListener spaceSiteCreatedListener;

  @BeforeEach
  void setUp() {
    spaceSiteCreatedListener.init();
  }

  @Test
  public void onEvent() throws Exception {
    Space space = new Space();
    space.setGroupId("/spaces/test");
    space.setTemplateId(1L);

    SiteKey siteKey = new SiteKey(SiteType.GROUP, space.getGroupId());

    when(hubBilling.isEnabled()).thenReturn(true);
    List<Long> templateIds = Collections.singletonList(1L);
    when(hubBilling.getSpaceTemplateIds()).thenReturn(templateIds);
    when(spaceService.getSpaceByGroupId(siteKey.getName())).thenReturn(space);

    doNothing().when(billingService).updateBillableSpaceLayout(siteKey);

    Event event = new Event(UserPortalConfigService.SITE_TEMPLATE_INSTANTIATED, "", siteKey);

    spaceSiteCreatedListener.onEvent(event);

    // Verify save of portal config
    verify(billingService).updateBillableSpaceLayout(siteKey);

  }

}
